/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.alf.validation.typing;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.uml.alf.alf.InstanceCreationExpression;
import org.eclipse.papyrus.uml.alf.alf.InstanceCreationTupleElement;
import org.eclipse.papyrus.uml.alf.alf.QualifiedNameWithBinding;
import org.eclipse.papyrus.uml.alf.scoping.AlfScopeProvider;
import org.eclipse.papyrus.uml.alf.validation.typing.DefaultConstructorFacade;
import org.eclipse.papyrus.uml.alf.validation.typing.ErrorTypeFacade;
import org.eclipse.papyrus.uml.alf.validation.typing.SignatureFacade;
import org.eclipse.papyrus.uml.alf.validation.typing.TypeExpression;
import org.eclipse.papyrus.uml.alf.validation.typing.TypeExpressionFactory;
import org.eclipse.papyrus.uml.alf.validation.typing.TypeFacade;
import org.eclipse.papyrus.uml.alf.validation.typing.TypeFacadeFactory;
import org.eclipse.papyrus.uml.alf.validation.typing.TypeInferenceException;
import org.eclipse.papyrus.uml.alf.validation.typing.TypeUtils;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.PrimitiveType;

public class SignatureFacadeFactory {
    public static SignatureFacadeFactory eInstance = new SignatureFacadeFactory();

    public SignatureFacade createSignatureFacade(EObject o) {
        return new SignatureFacade(o);
    }

    public SignatureFacade createConstructorFacade(InstanceCreationExpression exp) throws Exception {
        ArrayList<TypeExpression> arguments = new ArrayList<TypeExpression>();
        HashMap<String, TypeExpression> argumentsMap = new HashMap<String, TypeExpression>();
        if (exp.getSequenceConstuctionCompletion() != null) {
            TypeFacade classifier = TypeFacadeFactory.eInstance.createVoidFacade(exp.getConstructor());
            TypeExpression typeExpression = TypeExpressionFactory.eInstance.createTypeExpression(classifier, 0, -1, false, true);
            if (classifier instanceof ErrorTypeFacade) {
                throw new TypeInferenceException(typeExpression);
            }
            TypeExpression typeOfSequenceElements = new TypeUtils().getTypeOfSequenceConstructionExpression(exp.getSequenceConstuctionCompletion().getExpression());
            if (typeOfSequenceElements.getTypeFacade() instanceof ErrorTypeFacade) {
                throw new TypeInferenceException(typeOfSequenceElements);
            }
            if (typeExpression.isCompatibleWithMe(typeOfSequenceElements) == 0) {
                throw new Exception("Elements of the sequence are not compatible with invoked constructor");
            }
            return new DefaultConstructorFacade(typeExpression);
        }
        if (exp.getTuple().getInstanceCreationTupleElement() != null) {
            for (InstanceCreationTupleElement tupleElement : exp.getTuple().getInstanceCreationTupleElement()) {
                TypeExpression typeOfArgument = new TypeUtils().getTypeOfExpression(tupleElement.getObject());
                if (typeOfArgument.getTypeFacade() instanceof ErrorTypeFacade) {
                    throw new TypeInferenceException(typeOfArgument);
                }
                arguments.add(typeOfArgument);
                argumentsMap.put(tupleElement.getRole(), typeOfArgument);
            }
        }
        TypeFacade cddClassifier = TypeFacadeFactory.eInstance.createVoidFacade(exp.getConstructor());
        boolean errorInResolutionOfClassifier = false;
        if (cddClassifier instanceof ErrorTypeFacade) {
            errorInResolutionOfClassifier = true;
        } else {
            Classifier referencedType = cddClassifier.extractActualType();
            if (referencedType instanceof PrimitiveType) {
                throw new Exception("Constructor invocations do not apply to primitive types");
            }
            if (referencedType instanceof Enumeration) {
                throw new Exception("Constructor invocations do not apply to enumerations");
            }
            if (referencedType.isAbstract()) {
                throw new Exception("Abstract classifiers cannot be instantiated");
            }
            if (referencedType instanceof Class) {
                List<EObject> visibleConstructor = AlfScopeProvider.scopingTool.getVisibleOperationsOrBehaviors((EObject)referencedType).resolveByName(referencedType.getName());
                if (visibleConstructor.size() > 1) {
                    String errorMessage;
                    ArrayList<SignatureFacade> visibleConstructorSignatures = new ArrayList<SignatureFacade>();
                    for (EObject cddConstructor : visibleConstructor) {
                        SignatureFacade cddConstructorSignature = eInstance.createSignatureFacade(cddConstructor);
                        if (!cddConstructorSignature.isAConstructor()) continue;
                        visibleConstructorSignatures.add(cddConstructorSignature);
                    }
                    List<SignatureFacade> matchingSignatures = SignatureFacade.findNearestSignature(arguments, visibleConstructorSignatures);
                    if (matchingSignatures.size() > 1) {
                        errorMessage = String.valueOf(referencedType.getName()) + "(";
                        boolean first = true;
                        for (TypeExpression arg : arguments) {
                            if (first) {
                                first = false;
                            } else {
                                errorMessage = String.valueOf(errorMessage) + ", ";
                            }
                            errorMessage = String.valueOf(errorMessage) + arg.getLabel();
                        }
                        errorMessage = String.valueOf(errorMessage) + ") resolves to multiple constructors";
                        throw new Exception(errorMessage);
                    }
                    if (matchingSignatures.size() == 0) {
                        errorMessage = "Constructor " + referencedType.getName() + "(";
                        boolean first = true;
                        for (TypeExpression arg : arguments) {
                            if (first) {
                                first = false;
                            } else {
                                errorMessage = String.valueOf(errorMessage) + ", ";
                            }
                            errorMessage = String.valueOf(errorMessage) + arg.getLabel();
                        }
                        errorMessage = String.valueOf(errorMessage) + ") is undefined";
                        throw new Exception(errorMessage);
                    }
                    return matchingSignatures.get(0);
                }
                if (visibleConstructor.size() == 0) {
                    if (arguments.size() > 0) {
                        String errorMessage = "Constructor " + referencedType.getName() + "(";
                        boolean first = true;
                        for (TypeExpression t : arguments) {
                            if (first) {
                                first = false;
                            } else {
                                errorMessage = String.valueOf(errorMessage) + ", ";
                            }
                            errorMessage = String.valueOf(errorMessage) + t.getLabel();
                        }
                        errorMessage = String.valueOf(errorMessage) + ") is undefined";
                        throw new Exception(errorMessage);
                    }
                    return new DefaultConstructorFacade((Class)referencedType);
                }
                SignatureFacade constructor = this.createSignatureFacade(visibleConstructor.get(0));
                if (!constructor.isAConstructor()) {
                    String errorMessage = "Constructor " + referencedType.getName() + "(";
                    boolean first = true;
                    for (TypeExpression t : arguments) {
                        if (first) {
                            first = false;
                        } else {
                            errorMessage = String.valueOf(errorMessage) + ", ";
                        }
                        errorMessage = String.valueOf(errorMessage) + t.getLabel();
                    }
                    errorMessage = String.valueOf(errorMessage) + ") is undefined";
                    throw new Exception(errorMessage);
                }
                String potentialErrorMessage = constructor.isCompatibleWithMe(argumentsMap);
                if (potentialErrorMessage.length() == 0) {
                    return constructor;
                }
                throw new Exception(potentialErrorMessage);
            }
            if (referencedType instanceof DataType) {
                DefaultConstructorFacade defaultDataTypeConstructor = new DefaultConstructorFacade((DataType)referencedType);
                String errorMessage = defaultDataTypeConstructor.isCompatibleWithMe(argumentsMap);
                if (errorMessage.length() != 0) {
                    throw new Exception(errorMessage);
                }
                return defaultDataTypeConstructor;
            }
        }
        if (errorInResolutionOfClassifier) {
            if (exp.getConstructor().getRemaining() == null) {
                throw new Exception("Constructor " + exp.getConstructor().getId() + " is undefined");
            }
            QualifiedNameWithBinding remaining = exp.getConstructor();
            QualifiedNameWithBinding cddClassName = exp.getConstructor();
            QualifiedNameWithBinding cddConstructorName = exp.getConstructor();
            EObject previousPackage = null;
            while (cddConstructorName.getRemaining() != null) {
                cddClassName = cddConstructorName;
                cddConstructorName = cddConstructorName.getRemaining();
            }
            if (remaining != cddClassName) {
                List<EObject> visiblePackages = AlfScopeProvider.scopingTool.getVisiblePackages(exp).resolveByName(remaining.getId());
                if (visiblePackages.isEmpty()) {
                    throw new Exception("Could not resolve package " + remaining.getId());
                }
                if (visiblePackages.size() > 1) {
                    throw new Exception(String.valueOf(remaining.getId()) + " resolves to multiple packages");
                }
                previousPackage = visiblePackages.get(0);
                remaining = remaining.getRemaining();
                while (remaining != cddClassName) {
                    List<EObject> nestedVisiblePackages = AlfScopeProvider.scopingTool.getVisiblePackages(previousPackage).resolveByName(remaining.getId());
                    if (nestedVisiblePackages.isEmpty()) {
                        throw new Exception("Could not resolve package " + remaining.getId());
                    }
                    if (nestedVisiblePackages.size() > 1) {
                        throw new Exception(String.valueOf(remaining.getId()) + " resolves to multiple packages");
                    }
                    previousPackage = nestedVisiblePackages.get(0);
                    remaining = remaining.getRemaining();
                }
            }
            List<EObject> visibleClassifiers = null;
            EObject resolvedClassifier = null;
            visibleClassifiers = previousPackage != null ? AlfScopeProvider.scopingTool.getVisibleClassifiers(previousPackage).resolveByName(cddClassName.getId()) : AlfScopeProvider.scopingTool.getVisibleClassifiers(exp).resolveByName(cddClassName.getId());
            if (visibleClassifiers.isEmpty()) {
                throw new Exception("Could not resolve classifier " + cddClassName.getId());
            }
            if (visibleClassifiers.size() > 1) {
                throw new Exception(String.valueOf(remaining.getId()) + " resolves to multiple classifiers.");
            }
            resolvedClassifier = visibleClassifiers.get(0);
            List<EObject> visibleConstructor = AlfScopeProvider.scopingTool.getVisibleOperationsOrBehaviors(resolvedClassifier).resolveByName(cddConstructorName.getId());
            if (visibleConstructor.size() > 1) {
                String errorMessage;
                ArrayList<SignatureFacade> visibleConstructorSignatures = new ArrayList<SignatureFacade>();
                for (EObject cddConstructor : visibleConstructor) {
                    SignatureFacade cddConstructorSignature = eInstance.createSignatureFacade(cddConstructor);
                    if (!cddConstructorSignature.isAConstructor()) continue;
                    visibleConstructorSignatures.add(cddConstructorSignature);
                }
                List<SignatureFacade> matchingSignatures = SignatureFacade.findNearestSignature(arguments, visibleConstructorSignatures);
                if (matchingSignatures.size() > 1) {
                    errorMessage = String.valueOf(cddConstructorName.getId()) + "(";
                    boolean first = true;
                    for (TypeExpression arg : arguments) {
                        if (first) {
                            first = false;
                        } else {
                            errorMessage = String.valueOf(errorMessage) + ", ";
                        }
                        errorMessage = String.valueOf(errorMessage) + arg.getLabel();
                    }
                    errorMessage = String.valueOf(errorMessage) + ") resolves to multiple constructors";
                    throw new Exception(errorMessage);
                }
                if (matchingSignatures.size() == 0) {
                    errorMessage = "Constructor " + cddConstructorName.getId() + "(";
                    boolean first = true;
                    for (TypeExpression arg : arguments) {
                        if (first) {
                            first = false;
                        } else {
                            errorMessage = String.valueOf(errorMessage) + ", ";
                        }
                        errorMessage = String.valueOf(errorMessage) + arg.getLabel();
                    }
                    errorMessage = String.valueOf(errorMessage) + ") is undefined";
                    throw new Exception(errorMessage);
                }
                return matchingSignatures.get(0);
            }
            if (visibleConstructor.size() == 0) {
                String errorMessage = "Constructor " + cddConstructorName.getId() + "(";
                boolean first = true;
                for (TypeExpression arg : arguments) {
                    if (first) {
                        first = false;
                    } else {
                        errorMessage = String.valueOf(errorMessage) + ", ";
                    }
                    errorMessage = String.valueOf(errorMessage) + arg.getLabel();
                }
                errorMessage = String.valueOf(errorMessage) + ") is undefined";
                throw new Exception(errorMessage);
            }
            SignatureFacade constructor = this.createSignatureFacade(visibleConstructor.get(0));
            if (!constructor.isAConstructor()) {
                String errorMessage = "Constructor " + cddConstructorName.getId() + "(";
                boolean first = true;
                for (TypeExpression t : arguments) {
                    if (first) {
                        first = false;
                    } else {
                        errorMessage = String.valueOf(errorMessage) + ", ";
                    }
                    errorMessage = String.valueOf(errorMessage) + t.getLabel();
                }
                errorMessage = String.valueOf(errorMessage) + ") is undefined";
                throw new Exception(errorMessage);
            }
            String potentialErrorMessage = constructor.isCompatibleWithMe(arguments, true);
            if (potentialErrorMessage.length() == 0) {
                return constructor;
            }
            throw new Exception(potentialErrorMessage);
        }
        throw new Exception("Not supported case");
    }
}

