/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.activity.locator;

import org.eclipse.draw2d.AbstractPointListShape;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.PolylineShape;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.IMapMode;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.MapModeUtil;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.papyrus.uml.diagram.activity.edit.parts.AcceptEventActionEditPart;
import org.eclipse.papyrus.uml.diagram.activity.edit.parts.ActionInputPinInCallBeActEditPart;
import org.eclipse.papyrus.uml.diagram.activity.edit.parts.ActionInputPinInCallOpActAsTargetEditPart;
import org.eclipse.papyrus.uml.diagram.activity.edit.parts.ActionInputPinInCallOpActEditPart;
import org.eclipse.papyrus.uml.diagram.activity.edit.parts.ActionInputPinInOpaqueActEditPart;
import org.eclipse.papyrus.uml.diagram.activity.edit.parts.ActionInputPinInSendObjActAsReqEditPart;
import org.eclipse.papyrus.uml.diagram.activity.edit.parts.ActionInputPinInSendObjActAsTargetEditPart;
import org.eclipse.papyrus.uml.diagram.activity.edit.parts.ActionInputPinInSendSigActAsTargetEditPart;
import org.eclipse.papyrus.uml.diagram.activity.edit.parts.ActionInputPinInSendSigActEditPart;
import org.eclipse.papyrus.uml.diagram.activity.edit.parts.InputPinInAddStructuralFeatureValueActionAsObjectEditPart;
import org.eclipse.papyrus.uml.diagram.activity.edit.parts.InputPinInAddStructuralFeatureValueActionAsValueEditPart;
import org.eclipse.papyrus.uml.diagram.activity.edit.parts.InputPinInAddVariableValueActionAsInsertAtEditPart;
import org.eclipse.papyrus.uml.diagram.activity.edit.parts.InputPinInAddVariableValueActionAsValueEditPart;
import org.eclipse.papyrus.uml.diagram.activity.edit.parts.InputPinInBroadcastSignalActionEditPart;
import org.eclipse.papyrus.uml.diagram.activity.edit.parts.InputPinInCallBeActEditPart;
import org.eclipse.papyrus.uml.diagram.activity.edit.parts.InputPinInCallOpActAsTargetEditPart;
import org.eclipse.papyrus.uml.diagram.activity.edit.parts.InputPinInCallOpActEditPart;
import org.eclipse.papyrus.uml.diagram.activity.edit.parts.InputPinInDestroyObjectActionEditPart;
import org.eclipse.papyrus.uml.diagram.activity.edit.parts.InputPinInOpaqueActEditPart;
import org.eclipse.papyrus.uml.diagram.activity.edit.parts.InputPinInReadStructuralFeatureAsObjectEditPart;
import org.eclipse.papyrus.uml.diagram.activity.edit.parts.InputPinInSendObjActAsReqEditPart;
import org.eclipse.papyrus.uml.diagram.activity.edit.parts.InputPinInSendObjActAsTargetEditPart;
import org.eclipse.papyrus.uml.diagram.activity.edit.parts.InputPinInSendSigActAsTargetEditPart;
import org.eclipse.papyrus.uml.diagram.activity.edit.parts.InputPinInSendSigActEditPart;
import org.eclipse.papyrus.uml.diagram.activity.edit.parts.OutputPinInAcceptEventActionEditPart;
import org.eclipse.papyrus.uml.diagram.activity.edit.parts.OutputPinInAddStructuralFeatureValueActionAsResultEditPart;
import org.eclipse.papyrus.uml.diagram.activity.edit.parts.OutputPinInCallBeActEditPart;
import org.eclipse.papyrus.uml.diagram.activity.edit.parts.OutputPinInCallOpActEditPart;
import org.eclipse.papyrus.uml.diagram.activity.edit.parts.OutputPinInCreateObjectActionAsResultEditPart;
import org.eclipse.papyrus.uml.diagram.activity.edit.parts.OutputPinInOpaqueActEditPart;
import org.eclipse.papyrus.uml.diagram.activity.edit.parts.OutputPinInReadStructuralFeatureAsResultEditPart;
import org.eclipse.papyrus.uml.diagram.activity.edit.parts.OutputPinInReadVariableActionAsResultEditPart;
import org.eclipse.papyrus.uml.diagram.activity.edit.parts.OutputPinInValSpecActEditPart;
import org.eclipse.papyrus.uml.diagram.activity.edit.parts.ReadSelfActionOutputPinEditPart;
import org.eclipse.papyrus.uml.diagram.activity.edit.parts.ValuePinInCallBeActEditPart;
import org.eclipse.papyrus.uml.diagram.activity.edit.parts.ValuePinInCallOpActAsTargetEditPart;
import org.eclipse.papyrus.uml.diagram.activity.edit.parts.ValuePinInCallOpActEditPart;
import org.eclipse.papyrus.uml.diagram.activity.edit.parts.ValuePinInOpaqueActEditPart;
import org.eclipse.papyrus.uml.diagram.activity.edit.parts.ValuePinInSendObjActAsReqEditPart;
import org.eclipse.papyrus.uml.diagram.activity.edit.parts.ValuePinInSendObjActAsTargetEditPart;
import org.eclipse.papyrus.uml.diagram.activity.edit.parts.ValuePinInSendSigActAsTargetEditPart;
import org.eclipse.papyrus.uml.diagram.activity.edit.parts.ValuePinInSendSigActEditPart;
import org.eclipse.papyrus.uml.diagram.activity.helper.ActivityFigureDrawer;
import org.eclipse.papyrus.uml.diagram.common.figure.node.PapyrusSendNodeFigure;
import org.eclipse.papyrus.uml.diagram.common.locator.AdvancedBorderItemLocator;
import org.eclipse.uml2.uml.Action;
import org.eclipse.uml2.uml.CallOperationAction;

public class PinPositionLocator
extends AdvancedBorderItemLocator {
    public static final int EXTRA_BORDER_DEFAULT_OFFSET = 8;
    public static final int DEFAULT_PIN_SIZE = 16;
    private static final int SEND_SIGNAL_ACTION_MAX_X = 150;
    private static final int SEND_SIGNAL_ACTION_WIDTH = 200;

    public PinPositionLocator(IFigure parentFigure) {
        super(parentFigure);
    }

    public PinPositionLocator(IFigure borderItem, IFigure parentFigure, Rectangle constraint) {
        super(borderItem, parentFigure, constraint);
    }

    public PinPositionLocator(IFigure parentFigure, int preferredSide) {
        super(parentFigure, preferredSide);
    }

    public Rectangle getValidLocation(Rectangle proposedLocation, IFigure borderItem) {
        Rectangle realLocation = new Rectangle(proposedLocation);
        realLocation.height = realLocation.width = Math.max(realLocation.width, realLocation.height);
        int side = this.findClosestAuthorizedSideOfParent(proposedLocation, this.getParentBorder());
        Point newTopLeft = this.locateOnBorder(realLocation.getTopLeft(), side, 0, borderItem);
        realLocation.setLocation(newTopLeft);
        return realLocation;
    }

    protected Point locateOnBorder(Point suggestedLocation, int suggestedSide, int circuitCount, IFigure borderItem) {
        int maxLocation;
        Point suggestedCenter = borderItem.getBounds().getCopy().setLocation(suggestedLocation).getCenter();
        suggestedSide = this.redefineSuggestedSide(suggestedCenter, suggestedSide);
        if (this.isInSendSignalAction() && (suggestedSide == 4 || suggestedSide == 1) && suggestedLocation.x > (maxLocation = this.getParentBorder().x + this.getParentBorder().width * 150 / 200 - this.getSize((IFigure)borderItem).width)) {
            suggestedLocation.x = maxLocation;
        }
        Point recommendedLocation = super.locateOnBorder(suggestedLocation, suggestedSide, circuitCount, borderItem);
        return recommendedLocation;
    }

    protected Point locateOnParent(Point suggestedLocation, int suggestedSide, IFigure borderItem) {
        Rectangle bounds = this.getParentBorder();
        int parentFigureWidth = bounds.width;
        int parentFigureHeight = bounds.height;
        int parentFigureX = bounds.x;
        int parentFigureY = bounds.y;
        Dimension borderItemSize = this.getSize(borderItem);
        int newX = suggestedLocation.x;
        int newY = suggestedLocation.y;
        int westX = parentFigureX - borderItemSize.width + this.getBorderItemOffset().width;
        int eastX = parentFigureX + parentFigureWidth - this.getBorderItemOffset().width;
        int maxX = 0;
        if (this.isInSendSignalAction() && (suggestedSide == 4 || suggestedSide == 1)) {
            maxX = parentFigureX + parentFigureWidth * 150 / 200 - this.getBorderItemOffset().width;
        }
        int southY = parentFigureY + parentFigureHeight - this.getBorderItemOffset().height;
        int northY = parentFigureY - borderItemSize.height + this.getBorderItemOffset().height;
        if (suggestedSide == 8) {
            if (suggestedLocation.x != westX) {
                newX = westX;
            }
            if (suggestedLocation.y < bounds.getTopLeft().y) {
                newY = northY + borderItemSize.height;
            } else if (suggestedLocation.y > bounds.getBottomLeft().y - borderItemSize.height) {
                newY = southY - borderItemSize.height;
            }
        } else if (suggestedSide == 16) {
            if (suggestedLocation.x != eastX) {
                newX = eastX;
            }
            if (suggestedLocation.y < bounds.getTopLeft().y) {
                newY = northY + borderItemSize.height;
            } else if (suggestedLocation.y > bounds.getBottomLeft().y - borderItemSize.height) {
                newY = southY - borderItemSize.height;
            }
        } else if (suggestedSide == 4) {
            if (suggestedLocation.y != southY) {
                newY = southY;
            }
            if (suggestedLocation.x < bounds.getBottomLeft().x) {
                newX = westX + borderItemSize.width;
            } else if (suggestedLocation.x > bounds.getBottomRight().x - borderItemSize.width) {
                newX = eastX - borderItemSize.width;
            }
        } else {
            if (suggestedLocation.y != northY) {
                newY = northY;
            }
            if (suggestedLocation.x < bounds.getBottomLeft().x) {
                newX = westX + borderItemSize.width;
            } else if (suggestedLocation.x > bounds.getBottomRight().x - borderItemSize.width) {
                newX = eastX - borderItemSize.width;
            }
        }
        if (maxX > 0 && newX > maxX) {
            newX = maxX;
        }
        return new Point(newX, newY);
    }

    private int redefineSuggestedSide(Point childCenter, int suggestedSide) {
        if (this.isInSendSignalAction()) {
            if (suggestedSide == 16) {
                Point parentCenter = this.getParentBorder().getCenter();
                suggestedSide = childCenter.y < parentCenter.y ? 1 : 4;
            }
        } else if (this.isInAcceptEventAction()) {
            Point parentCenter;
            if (suggestedSide == 8) {
                parentCenter = this.getParentBorder().getCenter();
                suggestedSide = childCenter.y < parentCenter.y ? 1 : 4;
            }
            if (suggestedSide == 16 && this.isInAcceptTimeEventAction()) {
                parentCenter = this.getParentBorder().getCenter();
                suggestedSide = childCenter.y < parentCenter.y ? 1 : 4;
            }
        }
        return suggestedSide;
    }

    public int findClosestAuthorizedSideOfParent(Rectangle proposedLocation, Rectangle parentBorder) {
        int side = PinPositionLocator.findClosestSideOfParent((Rectangle)proposedLocation, (Rectangle)parentBorder);
        side = this.redefineSuggestedSide(proposedLocation.getCenter(), side);
        return side;
    }

    private boolean isInSendSignalAction() {
        IFigure parentFigure = this.getParentFigure();
        for (Object child : parentFigure.getChildren()) {
            if (!(child instanceof PapyrusSendNodeFigure)) continue;
            return true;
        }
        return false;
    }

    private boolean isInAcceptEventAction() {
        IFigure parentFigure = this.getParentFigure();
        for (Object child : parentFigure.getChildren()) {
            if (!(child instanceof AcceptEventActionEditPart.AcceptEventActionFigure)) continue;
            ((AcceptEventActionEditPart.AcceptEventActionFigure)((Object)child)).isTemplateForAcceptTimeEventActionUsed();
            return true;
        }
        return false;
    }

    private boolean isInAcceptTimeEventAction() {
        IFigure parentFigure = this.getParentFigure();
        for (Object child : parentFigure.getChildren()) {
            if (!(child instanceof AcceptEventActionEditPart.AcceptEventActionFigure)) continue;
            return ((AcceptEventActionEditPart.AcceptEventActionFigure)((Object)child)).isTemplateForAcceptTimeEventActionUsed();
        }
        return false;
    }

    public void relocate(IFigure borderItem) {
        Dimension size = this.getSize(borderItem);
        Rectangle rectSuggested = this.getConstraint().getCopy();
        if (rectSuggested.getTopLeft().x == 0 && rectSuggested.getTopLeft().y == 0) {
            rectSuggested.setLocation(this.getPreferredLocation(borderItem));
        } else {
            rectSuggested.setLocation(rectSuggested.getLocation().translate(this.getParentBorder().getTopLeft()));
        }
        rectSuggested.setSize(size);
        Rectangle validLocation = this.getValidLocation(rectSuggested, borderItem);
        borderItem.setBounds(validLocation);
        this.setCurrentSideOfParent(this.findClosestAuthorizedSideOfParent(borderItem.getBounds(), this.getParentBorder()));
        for (Object subfigure : borderItem.getChildren()) {
            if (!(subfigure instanceof IFigure)) continue;
            for (Object child : ((IFigure)subfigure).getChildren()) {
                this.refreshPinDescriptorArrow(child, MapModeUtil.getMapMode((IFigure)borderItem), size);
            }
        }
    }

    private void refreshPinDescriptorArrow(Object child, IMapMode mapMode, Dimension size) {
        boolean arrowIn = false;
        PolylineShape arrow = null;
        if (child instanceof InputPinInOpaqueActEditPart.PinDescriptor) {
            arrowIn = true;
            arrow = ((InputPinInOpaqueActEditPart.PinDescriptor)((Object)child)).getOptionalArrowFigure();
        } else if (child instanceof InputPinInCallBeActEditPart.PinDescriptor) {
            arrowIn = true;
            arrow = ((InputPinInCallBeActEditPart.PinDescriptor)((Object)child)).getOptionalArrowFigure();
        } else if (child instanceof InputPinInCallOpActEditPart.PinDescriptor) {
            arrowIn = true;
            arrow = ((InputPinInCallOpActEditPart.PinDescriptor)((Object)child)).getOptionalArrowFigure();
        } else if (child instanceof InputPinInCallOpActAsTargetEditPart.PinDescriptor) {
            arrowIn = true;
            arrow = ((InputPinInCallOpActAsTargetEditPart.PinDescriptor)((Object)child)).getOptionalArrowFigure();
        } else if (child instanceof InputPinInSendObjActAsReqEditPart.PinDescriptor) {
            arrowIn = true;
            arrow = ((InputPinInSendObjActAsReqEditPart.PinDescriptor)((Object)child)).getOptionalArrowFigure();
        } else if (child instanceof InputPinInSendObjActAsTargetEditPart.PinDescriptor) {
            arrowIn = true;
            arrow = ((InputPinInSendObjActAsTargetEditPart.PinDescriptor)((Object)child)).getOptionalArrowFigure();
        } else if (child instanceof InputPinInSendSigActEditPart.PinDescriptor) {
            arrowIn = true;
            arrow = ((InputPinInSendSigActEditPart.PinDescriptor)((Object)child)).getOptionalArrowFigure();
        } else if (child instanceof InputPinInSendSigActAsTargetEditPart.PinDescriptor) {
            arrowIn = true;
            arrow = ((InputPinInSendSigActAsTargetEditPart.PinDescriptor)((Object)child)).getOptionalArrowFigure();
        } else if (child instanceof ActionInputPinInOpaqueActEditPart.PinDescriptor) {
            arrowIn = true;
            arrow = ((ActionInputPinInOpaqueActEditPart.PinDescriptor)((Object)child)).getOptionalArrowFigure();
        } else if (child instanceof ActionInputPinInCallBeActEditPart.PinDescriptor) {
            arrowIn = true;
            arrow = ((ActionInputPinInCallBeActEditPart.PinDescriptor)((Object)child)).getOptionalArrowFigure();
        } else if (child instanceof ActionInputPinInCallOpActEditPart.PinDescriptor) {
            arrowIn = true;
            arrow = ((ActionInputPinInCallOpActEditPart.PinDescriptor)((Object)child)).getOptionalArrowFigure();
        } else if (child instanceof ActionInputPinInCallOpActAsTargetEditPart.PinDescriptor) {
            arrowIn = true;
            arrow = ((ActionInputPinInCallOpActAsTargetEditPart.PinDescriptor)((Object)child)).getOptionalArrowFigure();
        } else if (child instanceof ActionInputPinInSendObjActAsReqEditPart.PinDescriptor) {
            arrowIn = true;
            arrow = ((ActionInputPinInSendObjActAsReqEditPart.PinDescriptor)((Object)child)).getOptionalArrowFigure();
        } else if (child instanceof ActionInputPinInSendObjActAsTargetEditPart.PinDescriptor) {
            arrowIn = true;
            arrow = ((ActionInputPinInSendObjActAsTargetEditPart.PinDescriptor)((Object)child)).getOptionalArrowFigure();
        } else if (child instanceof ActionInputPinInSendSigActEditPart.PinDescriptor) {
            arrowIn = true;
            arrow = ((ActionInputPinInSendSigActEditPart.PinDescriptor)((Object)child)).getOptionalArrowFigure();
        } else if (child instanceof ActionInputPinInSendSigActAsTargetEditPart.PinDescriptor) {
            arrowIn = true;
            arrow = ((ActionInputPinInSendSigActAsTargetEditPart.PinDescriptor)((Object)child)).getOptionalArrowFigure();
        } else if (child instanceof ValuePinInOpaqueActEditPart.PinDescriptor) {
            arrowIn = true;
            arrow = ((ValuePinInOpaqueActEditPart.PinDescriptor)((Object)child)).getOptionalArrowFigure();
        } else if (child instanceof ValuePinInCallBeActEditPart.PinDescriptor) {
            arrowIn = true;
            arrow = ((ValuePinInCallBeActEditPart.PinDescriptor)((Object)child)).getOptionalArrowFigure();
        } else if (child instanceof ValuePinInCallOpActEditPart.PinDescriptor) {
            arrowIn = true;
            arrow = ((ValuePinInCallOpActEditPart.PinDescriptor)((Object)child)).getOptionalArrowFigure();
        } else if (child instanceof ValuePinInCallOpActAsTargetEditPart.PinDescriptor) {
            arrowIn = true;
            arrow = ((ValuePinInCallOpActAsTargetEditPart.PinDescriptor)((Object)child)).getOptionalArrowFigure();
        } else if (child instanceof ValuePinInSendObjActAsReqEditPart.PinDescriptor) {
            arrowIn = true;
            arrow = ((ValuePinInSendObjActAsReqEditPart.PinDescriptor)((Object)child)).getOptionalArrowFigure();
        } else if (child instanceof ValuePinInSendObjActAsTargetEditPart.PinDescriptor) {
            arrowIn = true;
            arrow = ((ValuePinInSendObjActAsTargetEditPart.PinDescriptor)((Object)child)).getOptionalArrowFigure();
        } else if (child instanceof ValuePinInSendSigActEditPart.PinDescriptor) {
            arrowIn = true;
            arrow = ((ValuePinInSendSigActEditPart.PinDescriptor)((Object)child)).getOptionalArrowFigure();
        } else if (child instanceof ValuePinInSendSigActAsTargetEditPart.PinDescriptor) {
            arrowIn = true;
            arrow = ((ValuePinInSendSigActAsTargetEditPart.PinDescriptor)((Object)child)).getOptionalArrowFigure();
        } else if (child instanceof OutputPinInOpaqueActEditPart.PinDescriptor) {
            arrowIn = false;
            arrow = ((OutputPinInOpaqueActEditPart.PinDescriptor)((Object)child)).getOptionalArrowFigure();
        } else if (child instanceof OutputPinInCallBeActEditPart.PinDescriptor) {
            arrowIn = false;
            arrow = ((OutputPinInCallBeActEditPart.PinDescriptor)((Object)child)).getOptionalArrowFigure();
        } else if (child instanceof OutputPinInCallOpActEditPart.PinDescriptor) {
            arrowIn = false;
            arrow = ((OutputPinInCallOpActEditPart.PinDescriptor)((Object)child)).getOptionalArrowFigure();
        } else if (child instanceof OutputPinInAcceptEventActionEditPart.PinDescriptor) {
            arrowIn = false;
            arrow = ((OutputPinInAcceptEventActionEditPart.PinDescriptor)((Object)child)).getOptionalArrowFigure();
        } else if (child instanceof OutputPinInCreateObjectActionAsResultEditPart.PinDescriptor) {
            arrowIn = false;
            arrow = ((OutputPinInCreateObjectActionAsResultEditPart.PinDescriptor)((Object)child)).getOptionalArrowFigure();
        } else if (child instanceof ReadSelfActionOutputPinEditPart.PinDescriptor) {
            arrowIn = false;
            arrow = ((ReadSelfActionOutputPinEditPart.PinDescriptor)((Object)child)).getOptionalArrowFigure();
        } else if (child instanceof OutputPinInValSpecActEditPart.PinDescriptor) {
            arrowIn = false;
            arrow = ((OutputPinInValSpecActEditPart.PinDescriptor)((Object)child)).getOptionalArrowFigure();
        } else if (child instanceof OutputPinInReadStructuralFeatureAsResultEditPart.PinDescriptor) {
            arrowIn = false;
            arrow = ((OutputPinInReadStructuralFeatureAsResultEditPart.PinDescriptor)((Object)child)).getOptionalArrowFigure();
        } else if (child instanceof InputPinInReadStructuralFeatureAsObjectEditPart.PinDescriptor) {
            arrowIn = true;
            arrow = ((InputPinInReadStructuralFeatureAsObjectEditPart.PinDescriptor)((Object)child)).getOptionalArrowFigure();
        } else if (child instanceof InputPinInAddStructuralFeatureValueActionAsObjectEditPart.PinDescriptor) {
            arrowIn = true;
            arrow = ((InputPinInAddStructuralFeatureValueActionAsObjectEditPart.PinDescriptor)((Object)child)).getOptionalArrowFigure();
        } else if (child instanceof InputPinInAddStructuralFeatureValueActionAsValueEditPart.PinDescriptor) {
            arrowIn = true;
            arrow = ((InputPinInAddStructuralFeatureValueActionAsValueEditPart.PinDescriptor)((Object)child)).getOptionalArrowFigure();
        } else if (child instanceof OutputPinInAddStructuralFeatureValueActionAsResultEditPart.PinDescriptor) {
            arrowIn = false;
            arrow = ((OutputPinInAddStructuralFeatureValueActionAsResultEditPart.PinDescriptor)((Object)child)).getOptionalArrowFigure();
        } else if (child instanceof InputPinInDestroyObjectActionEditPart.PinDescriptor) {
            arrowIn = true;
            arrow = ((InputPinInDestroyObjectActionEditPart.PinDescriptor)((Object)child)).getOptionalArrowFigure();
        } else if (child instanceof InputPinInAddVariableValueActionAsValueEditPart.PinDescriptor) {
            arrowIn = true;
            arrow = ((InputPinInAddVariableValueActionAsValueEditPart.PinDescriptor)((Object)child)).getOptionalArrowFigure();
        } else if (child instanceof InputPinInAddVariableValueActionAsInsertAtEditPart.PinDescriptor) {
            arrowIn = true;
            arrow = ((InputPinInAddVariableValueActionAsInsertAtEditPart.PinDescriptor)((Object)child)).getOptionalArrowFigure();
        } else if (child instanceof OutputPinInReadVariableActionAsResultEditPart.PinDescriptor) {
            arrowIn = false;
            arrow = ((OutputPinInReadVariableActionAsResultEditPart.PinDescriptor)((Object)child)).getOptionalArrowFigure();
        } else if (child instanceof InputPinInBroadcastSignalActionEditPart.PinDescriptor) {
            arrowIn = true;
            arrow = ((InputPinInBroadcastSignalActionEditPart.PinDescriptor)((Object)child)).getOptionalArrowFigure();
        }
        if (arrow != null && arrow.getPoints().size() > 0) {
            int arrowDirection;
            int side = this.getCurrentSideOfParent();
            switch (side) {
                case 1: {
                    if (arrowIn) {
                        arrowDirection = 4;
                        break;
                    }
                    arrowDirection = 1;
                    break;
                }
                case 16: {
                    if (arrowIn) {
                        arrowDirection = 8;
                        break;
                    }
                    arrowDirection = 16;
                    break;
                }
                case 4: {
                    if (arrowIn) {
                        arrowDirection = 1;
                        break;
                    }
                    arrowDirection = 4;
                    break;
                }
                default: {
                    arrowDirection = arrowIn ? 16 : 8;
                }
            }
            ActivityFigureDrawer.redrawPinArrow((AbstractPointListShape)arrow, mapMode, size, arrowDirection);
        }
    }

    protected Point getPreferredLocation(int side, IFigure borderItem) {
        Rectangle bounds = this.getParentBorder();
        int parentFigureWidth = bounds.width;
        int parentFigureHeight = bounds.height;
        int parentFigureX = bounds.x;
        int parentFigureY = bounds.y;
        int x = parentFigureX;
        int y = parentFigureY;
        Dimension borderItemSize = this.getSize(borderItem);
        switch (side) {
            case 1: {
                x += 8 + this.getBorderItemOffset().width;
                y += -borderItemSize.height + this.getBorderItemOffset().height;
                break;
            }
            case 16: {
                x += parentFigureWidth - this.getBorderItemOffset().width;
                y += parentFigureHeight - borderItemSize.height - 8 - this.getBorderItemOffset().height;
                break;
            }
            case 4: {
                x += 8 + this.getBorderItemOffset().width;
                y += parentFigureHeight - this.getBorderItemOffset().height;
                break;
            }
            default: {
                x += -borderItemSize.width + this.getBorderItemOffset().width;
                y += 8 + this.getBorderItemOffset().height;
            }
        }
        return new Point(x, y);
    }

    public static Bounds adaptActionHeight(Bounds boundsConstraint, EObject domainElement) {
        if (domainElement instanceof Action) {
            int pinsOnHeight = 0;
            int numberOfInputs = ((Action)domainElement).getInputs().size();
            int numberOfOutputs = ((Action)domainElement).getOutputs().size();
            pinsOnHeight = domainElement instanceof CallOperationAction ? Math.max(numberOfInputs - 1, numberOfOutputs) : Math.max(numberOfInputs, numberOfOutputs);
            if (pinsOnHeight > 0) {
                int heightInPx = 16 + pinsOnHeight * 24 - 8;
                boundsConstraint.setHeight(heightInPx);
            }
        }
        return boundsConstraint;
    }
}

