/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.activity.providers;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.validation.AbstractModelConstraint;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.emf.validation.model.IClientSelector;
import org.eclipse.emf.validation.model.IConstraintStatus;
import org.eclipse.emf.validation.service.IValidationListener;
import org.eclipse.emf.validation.service.ModelValidationService;
import org.eclipse.emf.validation.service.ValidationEvent;
import org.eclipse.gmf.runtime.emf.core.util.EMFCoreUtil;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.uml.diagram.activity.helper.SafeDialogOpenerDuringValidation;
import org.eclipse.papyrus.uml.diagram.activity.helper.UMLValidationHelper;
import org.eclipse.papyrus.uml.diagram.activity.part.Messages;
import org.eclipse.papyrus.uml.diagram.activity.part.UMLDiagramEditorPlugin;
import org.eclipse.papyrus.uml.diagram.activity.part.UMLVisualIDRegistry;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.uml2.uml.ActivityEdge;
import org.eclipse.uml2.uml.DecisionNode;
import org.eclipse.uml2.uml.ExceptionHandler;
import org.eclipse.uml2.uml.ObjectFlow;
import org.eclipse.uml2.uml.ObjectNode;
import org.eclipse.uml2.uml.ValuePin;

public class UMLValidationProvider {
    private static boolean constraintsActive = false;
    protected static final Collection<String> SELF_MANAGING_CONSTRAINTS = Arrays.asList("org.eclipse.papyrus.uml.diagram.activity.helper.PinAndParameterSynchronizer", "org.eclipse.papyrus.uml.diagram.activity.helper.ActivityParameterAndParameterSynchronizer");

    static {
        ModelValidationService.getInstance().addValidationListener((IValidationListener)new ValidationReportListener());
    }

    public static boolean shouldConstraintsBePrivate() {
        return false;
    }

    public static void runWithConstraints(TransactionalEditingDomain editingDomain, Runnable operation) {
        final Runnable op = operation;
        Runnable task = new Runnable(){

            public void run() {
                try {
                    constraintsActive = true;
                    op.run();
                }
                finally {
                    constraintsActive = false;
                }
            }
        };
        if (editingDomain != null) {
            try {
                editingDomain.runExclusive(task);
            }
            catch (Exception e) {
                UMLDiagramEditorPlugin.getInstance().logError("Validation failed", e);
            }
        } else {
            task.run();
        }
    }

    static boolean isInDefaultEditorContext(Object object) {
        EObject eObj;
        Resource resource;
        if (UMLValidationProvider.shouldConstraintsBePrivate() && !constraintsActive) {
            return false;
        }
        if (object instanceof View) {
            return constraintsActive && "PapyrusUMLActivityDiagram".equals(UMLVisualIDRegistry.getModelID((View)object));
        }
        if (object instanceof EObject && (resource = (eObj = (EObject)object).eResource()) != null) {
            ResourceSet set = resource.getResourceSet();
            return set instanceof ModelSet;
        }
        return false;
    }

    static String formatElement(EObject object) {
        return EMFCoreUtil.getQualifiedName((EObject)object, (boolean)true);
    }

    public static class Adapter13
    extends AbstractModelConstraint {
        public IStatus validate(IValidationContext ctx) {
            ValuePin context = (ValuePin)ctx.getTarget();
            return UMLValidationHelper.validateCompatibleType(context, ctx);
        }
    }

    public static class Adapter16
    extends AbstractModelConstraint {
        public IStatus validate(IValidationContext ctx) {
            ActivityEdge context = (ActivityEdge)ctx.getTarget();
            return UMLValidationHelper.validateSourceAndTarget(context, ctx);
        }
    }

    public static class Adapter21
    extends AbstractModelConstraint {
        public IStatus validate(IValidationContext ctx) {
            ObjectFlow context = (ObjectFlow)ctx.getTarget();
            return UMLValidationHelper.validateCompatibleTypes(context, ctx);
        }
    }

    public static class Adapter22
    extends AbstractModelConstraint {
        public IStatus validate(IValidationContext ctx) {
            ObjectFlow context = (ObjectFlow)ctx.getTarget();
            return UMLValidationHelper.validateSameUpperBounds(context, ctx);
        }
    }

    public static class Adapter23
    extends AbstractModelConstraint {
        public IStatus validate(IValidationContext ctx) {
            ObjectFlow context = (ObjectFlow)ctx.getTarget();
            return UMLValidationHelper.validateTarget(context, ctx);
        }
    }

    public static class Adapter24
    extends AbstractModelConstraint {
        public IStatus validate(IValidationContext ctx) {
            ObjectFlow context = (ObjectFlow)ctx.getTarget();
            return UMLValidationHelper.validateTransformationBehaviour(context, ctx);
        }
    }

    public static class Adapter26
    extends AbstractModelConstraint {
        public IStatus validate(IValidationContext ctx) {
            ObjectFlow context = (ObjectFlow)ctx.getTarget();
            return UMLValidationHelper.validateInputAndOutputParameter(context, ctx);
        }
    }

    public static class Adapter34
    extends AbstractModelConstraint {
        public IStatus validate(IValidationContext ctx) {
            DecisionNode context = (DecisionNode)ctx.getTarget();
            return UMLValidationHelper.validateIncomingObjectOneInputParameter(context, ctx);
        }
    }

    public static class Adapter35
    extends AbstractModelConstraint {
        public IStatus validate(IValidationContext ctx) {
            DecisionNode context = (DecisionNode)ctx.getTarget();
            return UMLValidationHelper.validateIncomingControlOneInputParameter(context, ctx);
        }
    }

    public static class Adapter36
    extends AbstractModelConstraint {
        public IStatus validate(IValidationContext ctx) {
            DecisionNode context = (DecisionNode)ctx.getTarget();
            return UMLValidationHelper.validateTwoInputParameters(context, ctx);
        }
    }

    public static class Adapter62
    extends AbstractModelConstraint {
        public IStatus validate(IValidationContext ctx) {
            ExceptionHandler context = (ExceptionHandler)ctx.getTarget();
            return UMLValidationHelper.validateException_HandlerBody_Constraint4(context, ctx);
        }
    }

    public static class Adapter63
    extends AbstractModelConstraint {
        public IStatus validate(IValidationContext ctx) {
            ActivityEdge context = (ActivityEdge)ctx.getTarget();
            return UMLValidationHelper.validateInterruptibleEdge(context, ctx);
        }
    }

    public static class Adapter64
    extends AbstractModelConstraint {
        public IStatus validate(IValidationContext ctx) {
            ExceptionHandler context = (ExceptionHandler)ctx.getTarget();
            return UMLValidationHelper.validateException_StructuredActivityNode_Constraint3(context, ctx);
        }
    }

    public static class Adapter65
    extends AbstractModelConstraint {
        public IStatus validate(IValidationContext ctx) {
            ExceptionHandler context = (ExceptionHandler)ctx.getTarget();
            return UMLValidationHelper.validateException_SourceAndTargetEdge_Constraint1(context, ctx);
        }
    }

    public static class Adapter66
    extends AbstractModelConstraint {
        public IStatus validate(IValidationContext ctx) {
            ActivityEdge context = (ActivityEdge)ctx.getTarget();
            return UMLValidationHelper.validateException_StructuredActivityNode_Constraint2(context, ctx);
        }
    }

    public static class Adapter7
    extends AbstractModelConstraint {
        public IStatus validate(IValidationContext ctx) {
            ObjectNode context = (ObjectNode)ctx.getTarget();
            return UMLValidationHelper.validateInputOutputParameter(context, ctx);
        }
    }

    public static class DefaultCtx
    implements IClientSelector {
        public boolean selects(Object object) {
            return UMLValidationProvider.isInDefaultEditorContext(object);
        }
    }

    private static class ValidationReportListener
    implements IValidationListener {
        private ValidationReportListener() {
        }

        public void validationOccurred(ValidationEvent event) {
            boolean needReport = false;
            if (event.getSeverity() >= 2) {
                needReport = true;
            }
            if (needReport && event.getEvaluationMode().isLive()) {
                SafeDialogOpenerDuringValidation opener;
                StringBuffer messageBuff = new StringBuffer();
                LinkedList<String> handledConstraints = new LinkedList<String>(SELF_MANAGING_CONSTRAINTS);
                for (IConstraintStatus status : event.getValidationResults()) {
                    if (status.getSeverity() < event.getSeverity()) continue;
                    String constraintId = status.getConstraint().getDescriptor().getId();
                    String constraintPlugin = status.getConstraint().getDescriptor().getPluginId();
                    if (!"org.eclipse.papyrus.uml.diagram.activity".equals(constraintPlugin) || handledConstraints.contains(constraintId)) continue;
                    handledConstraints.add(constraintId);
                    messageBuff.append(status.getMessage());
                }
                if (messageBuff.length() == 0) {
                    return;
                }
                final String message = messageBuff.toString();
                if (event.getSeverity() >= 4) {
                    opener = new SafeDialogOpenerDuringValidation<Void>(){

                        @Override
                        protected Void openDialog() {
                            MessageDialog.openWarning((Shell)new Shell(Display.getDefault()), (String)Messages.UMLValidation_ErrorTitle, (String)message);
                            return null;
                        }
                    };
                    opener.execute();
                } else {
                    opener = new SafeDialogOpenerDuringValidation<Void>(){

                        @Override
                        protected Void openDialog() {
                            MessageDialog.openInformation((Shell)new Shell(Display.getDefault()), (String)Messages.UMLValidation_WarningTitle, (String)message);
                            return null;
                        }
                    };
                    opener.execute();
                }
            }
        }
    }
}

