/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.draw2d;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Shape;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;

public class LifelineDotLineFigure
extends Shape {
    private final int SOLID_SIZE = 6;
    private final int DASHED_SIZE = 10;
    private NodeFigure dashLineRectangle = new NodeFigure();

    public LifelineDotLineFigure() {
        this.dashLineRectangle.setParent((IFigure)this);
    }

    protected void fillShape(Graphics graphics) {
    }

    protected void outlineShape(Graphics graphics) {
        Rectangle r = this.getBounds();
        Point pStart = new Point();
        Point pEnd = new Point();
        Point pAux = new Point();
        pStart.x = r.x + r.width / 2;
        pStart.y = r.y + 1;
        pEnd.x = pStart.x;
        pEnd.y = pStart.y + r.height - 1;
        pAux = pStart.getCopy();
        while (pAux.y <= pEnd.y) {
            int yEnd = pAux.y + 6;
            if (yEnd > pEnd.y) {
                yEnd = pEnd.y;
            }
            graphics.drawLine(pAux, new Point(pAux.x, yEnd));
            pAux.y += 10;
        }
        this.dashLineRectangle.setSize(1, pEnd.y - pStart.y);
        this.dashLineRectangle.setLocation(pStart);
    }

    public void setBounds(Rectangle rect) {
        super.setBounds(rect);
        Point pStart = new Point();
        Point pEnd = new Point();
        pStart.x = rect.x + rect.width / 2;
        pStart.y = rect.y + 1;
        pEnd.x = pStart.x;
        pEnd.y = pStart.y + rect.height - 1;
        this.dashLineRectangle.setSize(1, pEnd.y - pStart.y);
        this.dashLineRectangle.setLocation(pStart);
    }

    private void drawCrossAtEnd(Graphics graphics, Point pEnd, int pixels) {
        Point p1Start = new Point();
        Point p1End = new Point();
        Point p2Start = new Point();
        Point p2End = new Point();
        p1Start.x = pEnd.x - pixels;
        p1Start.y = pEnd.y;
        p1End.x = pEnd.x + pixels;
        p1End.y = pEnd.y - 2 * pixels;
        p2Start.x = pEnd.x + pixels;
        p2Start.y = pEnd.y;
        p2End.x = pEnd.x - pixels;
        p2End.y = pEnd.y - 2 * pixels;
        graphics.setLineStyle(1);
        graphics.drawLine(p1Start, p1End);
        graphics.drawLine(p2Start, p2End);
    }

    public NodeFigure getDashLineRectangle() {
        return this.dashLineRectangle;
    }
}

