/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.editpolicies;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.CompartmentEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.OpenEditPolicy;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.papyrus.infra.core.editorsfactory.IPageIconsRegistry;
import org.eclipse.papyrus.infra.core.editorsfactory.PageIconsRegistry;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.utils.EditorUtils;
import org.eclipse.papyrus.infra.gmfdiag.common.DiagramsUtil;
import org.eclipse.papyrus.infra.gmfdiag.navigation.ExistingNavigableElement;
import org.eclipse.papyrus.infra.gmfdiag.navigation.NavigableElement;
import org.eclipse.papyrus.infra.gmfdiag.navigation.NavigationHelper;
import org.eclipse.papyrus.infra.hyperlink.helper.HyperLinkHelperFactory;
import org.eclipse.papyrus.infra.hyperlink.object.HyperLinkObject;
import org.eclipse.papyrus.infra.hyperlink.ui.EditorNavigationDialog;
import org.eclipse.papyrus.infra.hyperlink.util.HyperLinkHelpersRegistrationUtil;
import org.eclipse.papyrus.uml.diagram.common.Activator;
import org.eclipse.papyrus.uml.diagram.common.ui.hyperlinkshell.AdvancedHLManager;
import org.eclipse.papyrus.uml.diagram.common.ui.hyperlinkshell.HyperLinkDiagram;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;

public class NavigationEditPolicy
extends OpenEditPolicy {
    public static final String NAVIGATION_POLICY = "NavigationEditPolicy";

    public static Package topPackage(Element element) {
        if (element.getOwner() == null) {
            return (Package)element;
        }
        return NavigationEditPolicy.topPackage(element.getOwner());
    }

    protected Command getOpenCommand(Request request) {
        final IGraphicalEditPart gep = (IGraphicalEditPart)this.getHost() instanceof CompartmentEditPart ? (IGraphicalEditPart)this.getHost().getParent() : (IGraphicalEditPart)this.getHost();
        EObject semanticElement = gep.resolveSemanticElement();
        List navElements = null;
        final ArrayList<Object> defaultHyperLinkObject = new ArrayList<Object>();
        HashMap<NavigableElement, List> existingDiagrams = new HashMap<NavigableElement, List>();
        if (semanticElement == null) {
            return UnexecutableCommand.INSTANCE;
        }
        ArrayList hyperLinkHelpers = new ArrayList();
        hyperLinkHelpers.addAll(HyperLinkHelpersRegistrationUtil.INSTANCE.getAllRegisteredHyperLinkHelper());
        final HyperLinkHelperFactory hyperlinkHelperFactory = new HyperLinkHelperFactory(hyperLinkHelpers);
        try {
            Command command;
            final ArrayList hyperLinkObjectList = hyperlinkHelperFactory.getAllreferenced((EModelElement)gep.getNotationView());
            for (HyperLinkObject hyperlinkObject : hyperLinkObjectList) {
                if (!hyperlinkObject.getIsDefault()) continue;
                defaultHyperLinkObject.add(hyperlinkObject);
            }
            navElements = NavigationHelper.getInstance().getAllNavigableElements(semanticElement);
            HashMap possibleCreations = new HashMap();
            String navigationKind = Activator.getDefault().getPreferenceStore().getString("PAPYRUS_NAVIGATION_DOUBLECLICK_KIND");
            if (navigationKind.equals("NO_NAVIGATION")) {
                return UnexecutableCommand.INSTANCE;
            }
            if (navigationKind.equals("EXPLICIT_IMPLICIT_NAVIGATION")) {
                for (NavigableElement navElement : navElements) {
                    EObject element = navElement.getElement();
                    if (!(navElement instanceof ExistingNavigableElement)) continue;
                    List associatedDiagrams = DiagramsUtil.getAssociatedDiagrams((EObject)element, null);
                    associatedDiagrams.remove(gep.getNotationView().getDiagram());
                    if (associatedDiagrams == null || associatedDiagrams.isEmpty()) continue;
                    existingDiagrams.put(navElement, associatedDiagrams);
                }
                for (List list : existingDiagrams.values()) {
                    for (Diagram diagram : list) {
                        HyperLinkDiagram hyperLinkDiagram = new HyperLinkDiagram();
                        hyperLinkDiagram.setDiagram(diagram);
                        hyperLinkDiagram.setTooltipText(String.valueOf(diagram.getName()) + " (found by heuristic)");
                        HyperLinkObject foundHyperlink = null;
                        int i = 0;
                        while (i < defaultHyperLinkObject.size() && foundHyperlink == null) {
                            if (((HyperLinkObject)defaultHyperLinkObject.get(i)).getObject().equals(diagram)) {
                                foundHyperlink = (HyperLinkObject)defaultHyperLinkObject.get(i);
                            }
                            ++i;
                        }
                        if (foundHyperlink != null) continue;
                        defaultHyperLinkObject.add((Object)hyperLinkDiagram);
                    }
                }
            }
            if (defaultHyperLinkObject.size() == 0) {
                command = new Command(){

                    public void execute() {
                        EObject semanticElement = gep.getNotationView().getElement();
                        if (semanticElement instanceof Element) {
                            AdvancedHLManager hyperLinkManagerShell = new AdvancedHLManager(NavigationEditPolicy.this.createEditorRegistry(), ((GraphicalEditPart)NavigationEditPolicy.this.getHost()).getEditingDomain(), (Element)semanticElement, gep.getNotationView(), NavigationEditPolicy.topPackage((Element)semanticElement), hyperlinkHelperFactory);
                            hyperLinkManagerShell.setInput(hyperLinkObjectList);
                            hyperLinkManagerShell.open();
                        }
                    }
                };
                return command;
            }
            if (defaultHyperLinkObject.size() == 1) {
                command = new Command(){

                    public void execute() {
                        super.execute();
                        ((HyperLinkObject)defaultHyperLinkObject.get(0)).executeSelectPressed();
                    }
                };
                return command;
            }
            if (defaultHyperLinkObject.size() > 1) {
                EditorNavigationDialog diagramNavigationDialog = new EditorNavigationDialog(this.getHost().getViewer().getControl().getShell(), defaultHyperLinkObject);
                diagramNavigationDialog.open();
                final List hList = diagramNavigationDialog.getSelectedHyperlinks();
                Command command2 = new Command(){

                    public void execute() {
                        super.execute();
                        for (HyperLinkObject hyperlinkObject : hList) {
                            hyperlinkObject.executeSelectPressed();
                        }
                    }
                };
                return command2;
            }
        }
        catch (Exception e) {
            Activator.log.error("Impossible to load hyperlinks", (Throwable)e);
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected IPageIconsRegistry createEditorRegistry() {
        try {
            return (IPageIconsRegistry)EditorUtils.getServiceRegistry().getService(IPageIconsRegistry.class);
        }
        catch (ServiceException e) {
            return new PageIconsRegistry();
        }
    }
}

