/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.providers;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.Locator;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.handles.HandleBounds;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.Decoration;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.IDecoration;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.IDecoratorTarget;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.MapModeUtil;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.services.decoration.util.Decoration;
import org.eclipse.papyrus.infra.services.decoration.util.IPapyrusDecoration;
import org.eclipse.swt.graphics.Image;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiagramDecorationAdapter {
    protected IDecoratorTarget decoratorTarget;
    protected EList<IDecoration> decorations;
    protected EList<IPapyrusDecoration> pDecorations;
    protected Image decorationImage;

    public DiagramDecorationAdapter(IDecoratorTarget decoratorTarget) {
        this.decoratorTarget = decoratorTarget;
    }

    public IDecoratorTarget getDecoratorTarget() {
        return this.decoratorTarget;
    }

    public void removeDecorations() {
        if (this.decoratorTarget == null || this.decorations == null) {
            return;
        }
        for (IDecoration decoration : this.decorations) {
            this.removeDecoration(decoration);
        }
    }

    public void setDecoratorTarget(IDecoratorTarget decoratorTarget) {
        this.decoratorTarget = decoratorTarget;
    }

    public Image getDecorationImage() {
        return this.decorationImage;
    }

    public Label getToolTip(String message) {
        return new Label(message, this.getDecorationImage());
    }

    public EList<IDecoration> setDecorations(EList<IPapyrusDecoration> pDecorations, int percentageFromSource, int margin, boolean isVolatile) {
        int distBetweenIconsPercent = 20;
        int percentageMin = 10;
        int percentageMax = 90;
        this.decorations = new BasicEList();
        if (pDecorations.size() > 1) {
            percentageFromSource -= 10 * (pDecorations.size() - 1);
        }
        if (percentageFromSource < 10) {
            percentageFromSource = 10;
        }
        for (IPapyrusDecoration pDecoration : pDecorations) {
            Image image = pDecoration.getDecorationImageForGE().createImage();
            IDecoration decoration = this.setDecoration(this.decoratorTarget, image, percentageFromSource, margin, isVolatile);
            this.decorations.add((Object)decoration);
            String message = pDecoration.getMessage();
            Label toolTip = this.getToolTip(message);
            if (decoration instanceof Decoration) {
                ((Decoration)decoration).setToolTip((IFigure)toolTip);
            }
            if ((percentageFromSource += 20) > 90) {
                percentageFromSource = 90;
            }
            margin += image.getBounds().width;
        }
        this.pDecorations = pDecorations;
        return this.decorations;
    }

    public void removeDecoration(IDecoration decoration) {
        GraphicalEditPart ownerEditPart;
        IFigure parent;
        if (decoration == null || this.decoratorTarget == null) {
            return;
        }
        if (decoration instanceof IFigure && (parent = ((IFigure)decoration).getParent()) != null) {
            parent.remove((IFigure)decoration);
        }
        if ((ownerEditPart = (GraphicalEditPart)this.decoratorTarget.getAdapter(GraphicalEditPart.class)).getViewer() != null) {
            ownerEditPart.getViewer().getVisualPartMap().remove(decoration);
        }
    }

    public IDecoration setDecoration(IDecoratorTarget decoratorTarget, Image image, int percentageFromSource, int margin, boolean isVolatile) {
        View view = (View)decoratorTarget.getAdapter(View.class);
        IDecoration decoration = null;
        if (view == null || view.eResource() == null || image == null) {
            return decoration;
        }
        EditPart editPart = (EditPart)decoratorTarget.getAdapter(EditPart.class);
        if (editPart == null || editPart.getViewer() == null) {
            return decoration;
        }
        if (editPart instanceof GraphicalEditPart) {
            GraphicalEditPart gEditPart = (GraphicalEditPart)editPart;
            if (view instanceof Edge) {
                decoration = decoratorTarget.addConnectionDecoration(image, percentageFromSource, isVolatile);
            } else {
                IFigure parentFig = gEditPart.getFigure();
                margin = MapModeUtil.getMapMode((IFigure)parentFig).DPtoLP(margin);
                MultiIconTopRightLocator locator = new MultiIconTopRightLocator(parentFig, margin);
                decoration = decoratorTarget.addShapeDecoration(image, IDecoratorTarget.Direction.NORTH_EAST, margin, isVolatile);
                if (decoration instanceof Decoration) {
                    ((Decoration)decoration).setLocator((Locator)locator);
                }
            }
        }
        return decoration;
    }

    public IDecoration setDecoration(IDecoratorTarget decoratorTarget, IFigure figure, int percentageFromSource, int margin, boolean isVolatile) {
        View view = (View)decoratorTarget.getAdapter(View.class);
        IDecoration decoration = null;
        if (view == null || view.eResource() == null || figure == null) {
            return decoration;
        }
        EditPart editPart = (EditPart)decoratorTarget.getAdapter(EditPart.class);
        if (editPart == null || editPart.getViewer() == null) {
            return decoration;
        }
        if (editPart instanceof GraphicalEditPart) {
            if (view instanceof Edge) {
                decoration = decoratorTarget.addConnectionDecoration(figure, percentageFromSource, isVolatile);
            } else {
                IFigure parentFig = ((GraphicalEditPart)editPart).getFigure();
                margin = MapModeUtil.getMapMode((IFigure)parentFig).DPtoLP(margin);
                decoration = decoratorTarget.addShapeDecoration(figure, IDecoratorTarget.Direction.NORTH_EAST, margin, isVolatile);
            }
        }
        return decoration;
    }

    @Deprecated
    private IDecoratorTarget.Direction getDirection(Decoration.PreferedPosition position) {
        switch (position) {
            case NORTH_WEST: {
                return IDecoratorTarget.Direction.NORTH_WEST;
            }
            case NORTH: {
                return IDecoratorTarget.Direction.NORTH;
            }
            case NORTH_EAST: {
                return IDecoratorTarget.Direction.NORTH_EAST;
            }
            case EAST: {
                return IDecoratorTarget.Direction.EAST;
            }
            case SOUTH_EAST: {
                return IDecoratorTarget.Direction.SOUTH_EAST;
            }
            case SOUTH: {
                return IDecoratorTarget.Direction.SOUTH;
            }
            case SOUTH_WEST: {
                return IDecoratorTarget.Direction.SOUTH_WEST;
            }
            case WEST: {
                return IDecoratorTarget.Direction.WEST;
            }
            case CENTER: {
                return IDecoratorTarget.Direction.CENTER;
            }
        }
        return IDecoratorTarget.Direction.NORTH_EAST;
    }

    public class MultiIconTopRightLocator
    implements Locator {
        protected IFigure reference;
        protected int rightMargin;

        public MultiIconTopRightLocator(IFigure parentFig, int rightMargin) {
            this.reference = parentFig;
            if (rightMargin < 0) {
                rightMargin = 0;
            }
            this.rightMargin = rightMargin;
        }

        public void relocate(IFigure target) {
            PrecisionRectangle bounds = this.reference instanceof HandleBounds ? new PrecisionRectangle(((HandleBounds)this.reference).getHandleBounds()) : new PrecisionRectangle(this.reference.getBounds());
            this.reference.translateToAbsolute((Translatable)bounds);
            target.translateToRelative((Translatable)bounds);
            Point pTR = bounds.getTopRight();
            Point pTL = bounds.getTopLeft();
            Point pDecoration = new Point(pTR);
            int decorationX = pTR.x - target.getSize().width - this.rightMargin;
            if (decorationX > pTL.x) {
                pDecoration.setX(decorationX);
            } else {
                pDecoration.setX(pTL.x);
            }
            target.setLocation(pDecoration);
        }
    }
}

