/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.gef.palette.CombinedTemplateCreationEntry;
import org.eclipse.gef.palette.PaletteContainer;
import org.eclipse.gef.palette.PaletteDrawer;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.palette.PaletteSeparator;
import org.eclipse.gef.palette.PaletteStack;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.papyrus.uml.diagram.common.Activator;
import org.eclipse.papyrus.uml.diagram.common.service.AbstractXMLDefinitionPaletteFactory;
import org.eclipse.papyrus.uml.diagram.common.service.AspectCreationEntry;
import org.eclipse.papyrus.uml.diagram.common.service.IPapyrusPaletteConstant;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLDefinitionPaletteFactory
extends AbstractXMLDefinitionPaletteFactory
implements IPapyrusPaletteConstant {
    protected PaletteRoot root;
    protected Map<String, PaletteEntry> predefinedEntries;

    public XMLDefinitionPaletteFactory(PaletteRoot root, Map<String, PaletteEntry> predefinedEntries) {
        this.root = root;
        this.predefinedEntries = predefinedEntries;
    }

    @Override
    public void traverseContentNode(Node node) {
    }

    @Override
    public void traverseDrawerNode(Node node) {
        String id = node.getAttributes().getNamedItem("id").getNodeValue();
        PaletteEntry entry = this.predefinedEntries.get(id);
        if (entry == null) {
            String name = node.getAttributes().getNamedItem("name").getNodeValue();
            String iconPath = node.getAttributes().getNamedItem("iconpath").getNodeValue();
            entry = new PaletteDrawer(name);
            entry.setId(id);
            entry.setDescription("Drawer " + name);
            if (iconPath != null && !iconPath.equals("")) {
                entry.setSmallIcon(Activator.getImageDescriptor(iconPath));
                entry.setLargeIcon(Activator.getImageDescriptor(iconPath));
            }
            this.predefinedEntries.put(id, entry);
        }
        XMLDefinitionPaletteFactory.appendPaletteEntry(this.root, this.predefinedEntries, this.computePath(node), entry);
    }

    protected String computePath(Node node) {
        String path = "/";
        Node parentNode = node;
        while (parentNode.getParentNode() != null && !parentNode.getParentNode().getNodeName().equals("content")) {
            parentNode = parentNode.getParentNode();
            path = "/" + parentNode.getAttributes().getNamedItem("id").getNodeValue() + path;
        }
        return path;
    }

    @Override
    public void traverseSeparatorNode(Node node) {
        String id = node.getAttributes().getNamedItem("id").getNodeValue();
        PaletteEntry entry = this.predefinedEntries.get(id);
        if (entry == null) {
            entry = new PaletteSeparator(id);
            this.predefinedEntries.put(id, entry);
        }
        XMLDefinitionPaletteFactory.appendPaletteEntry(this.root, this.predefinedEntries, this.computePath(node), entry);
    }

    @Override
    public void traverseStackNode(Node node) {
        String id = node.getAttributes().getNamedItem("id").getNodeValue();
        PaletteEntry entry = this.predefinedEntries.get(id);
        if (entry == null) {
            entry = new PaletteStack(null, null, null);
            entry.setId(id);
            this.predefinedEntries.put(id, entry);
        }
        XMLDefinitionPaletteFactory.appendPaletteEntry(this.root, this.predefinedEntries, this.computePath(node), entry);
    }

    @Override
    public void traverseToolEntryNode(Node node) {
        String id = node.getAttributes().getNamedItem("id").getNodeValue();
        PaletteEntry entry = this.predefinedEntries.get(id);
        XMLDefinitionPaletteFactory.appendPaletteEntry(this.root, this.predefinedEntries, this.computePath(node), entry);
    }

    @Override
    public void traverseAspectToolEntryNode(Node node) {
        CombinedTemplateCreationEntry entry;
        String id = node.getAttributes().getNamedItem("id").getNodeValue();
        String refToolID = node.getAttributes().getNamedItem("refToolId").getNodeValue();
        Node nameNode = node.getAttributes().getNamedItem("name");
        Node descNode = node.getAttributes().getNamedItem("description");
        Node iconPathNode = node.getAttributes().getNamedItem("iconpath");
        HashMap<String, NodeList> properties = new HashMap<String, NodeList>();
        if (node.getChildNodes().getLength() > 0) {
            properties.put("aspectActions", node.getChildNodes());
        }
        if ((entry = (CombinedTemplateCreationEntry)this.predefinedEntries.get(refToolID)) == null) {
            Activator.log.error("could not find entry " + refToolID, null);
            return;
        }
        ImageDescriptor iconDesc = null;
        String name = null;
        String desc = null;
        iconDesc = iconPathNode != null ? Activator.getImageDescriptor(iconPathNode.getNodeValue()) : entry.getSmallIcon();
        name = nameNode != null ? nameNode.getNodeValue() : entry.getLabel();
        desc = descNode != null ? descNode.getNodeValue() : entry.getDescription();
        AspectCreationEntry realEntry = new AspectCreationEntry(name, desc, id, iconDesc, entry, properties);
        this.predefinedEntries.put(id, (PaletteEntry)realEntry);
        XMLDefinitionPaletteFactory.appendPaletteEntry(this.root, this.predefinedEntries, this.computePath(node), (PaletteEntry)realEntry);
    }

    private static void appendPaletteEntry(PaletteRoot root, Map predefinedEntries, String path, PaletteEntry paletteEntry) {
        PaletteEntry fEntry = XMLDefinitionPaletteFactory.findPaletteEntry((PaletteEntry)root, path);
        if (fEntry == null) {
            fEntry = XMLDefinitionPaletteFactory.findPredefinedEntry(predefinedEntries, path);
        }
        if (fEntry == null) {
            Activator.log.error("Invalid palette entry path: " + path, null);
        } else if (fEntry instanceof PaletteContainer) {
            if (!((PaletteContainer)fEntry).getChildren().contains(paletteEntry)) {
                ((PaletteContainer)fEntry).add(paletteEntry);
            }
        } else if (fEntry instanceof PaletteSeparator) {
            XMLDefinitionPaletteFactory.appendTo((PaletteSeparator)fEntry, paletteEntry);
        } else {
            fEntry.getParent().add(fEntry.getParent().getChildren().indexOf(fEntry) + 1, paletteEntry);
        }
    }

    private static PaletteEntry findPaletteEntry(PaletteEntry root, String aPath) {
        StringTokenizer tokens = new StringTokenizer(aPath, "/");
        while (tokens.hasMoreElements()) {
            if (root instanceof PaletteContainer) {
                root = XMLDefinitionPaletteFactory.findChildPaletteEntry((PaletteContainer)root, tokens.nextToken());
                continue;
            }
            return null;
        }
        return root;
    }

    private static PaletteEntry findChildPaletteEntry(PaletteContainer container, String childId) {
        for (PaletteEntry entry : container.getChildren()) {
            if (!entry.getId().equals(childId)) continue;
            return entry;
        }
        return null;
    }

    private static PaletteEntry findPredefinedEntry(Map predefinedEntries, String path) {
        StringTokenizer tokens = new StringTokenizer(path, "/");
        PaletteEntry root = (PaletteEntry)predefinedEntries.get(tokens.nextToken());
        while (tokens.hasMoreElements()) {
            if (root instanceof PaletteContainer) {
                root = XMLDefinitionPaletteFactory.findChildPaletteEntry((PaletteContainer)root, tokens.nextToken());
                continue;
            }
            return null;
        }
        return root;
    }

    private static void appendTo(PaletteSeparator separator, PaletteEntry entry) {
        List children = separator.getParent().getChildren();
        int index = children.indexOf(separator);
        ++index;
        while (index < children.size()) {
            if (children.get(index) instanceof PaletteSeparator) break;
            ++index;
        }
        separator.getParent().add(index, entry);
    }
}

