/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.service.palette;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.AbstractEMFOperation;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramGraphicalViewer;
import org.eclipse.gmf.runtime.diagram.ui.util.EditPartUtil;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.papyrus.commands.wrappers.EMFtoGMFCommandWrapper;
import org.eclipse.papyrus.infra.core.utils.EditorUtils;
import org.eclipse.papyrus.uml.appearance.helper.AppliedStereotypeHelper;
import org.eclipse.papyrus.uml.diagram.common.Activator;
import org.eclipse.papyrus.uml.diagram.common.service.palette.GraphicalPostAction;
import org.eclipse.papyrus.uml.diagram.common.service.palette.IAspectActionProvider;
import org.eclipse.papyrus.uml.diagram.common.service.palette.IPaletteAspectToolEntryProxy;
import org.eclipse.papyrus.uml.diagram.common.service.palette.IPaletteEntryProxy;
import org.eclipse.papyrus.uml.diagram.common.service.palette.IPostAction;
import org.eclipse.papyrus.uml.diagram.common.service.palette.StereotypePostAction;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Stereotype;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DisplayAppliedStereotypePostAction
extends GraphicalPostAction {
    protected List<String> stereotypesToDisplay = new ArrayList<String>();
    protected List<String> stereotypesQNToDisplay = new ArrayList<String>();
    protected IPaletteEntryProxy entryProxy;
    protected List<Profile> appliedProfiles;
    protected static final String ICONS_ADD = "/icons/obj16/Add_16x16.gif";
    protected static final String ICONS_REMOVE = "/icons/delete.gif";
    private TableViewer stereotypesToShowTableViewer;
    protected HashMap<String, Integer> listOfDisplayableStereotypes = new HashMap();
    private final int DONT_DISPLAY = 0;
    private final int DISPLAY_SIMPLE_NAME = 1;
    private final int DISPLAY_QUALIFIED_NAME = 2;
    private String[] diplayOptions = new String[]{"Do not display", "Display the stereotype", "Display qualified name of the stereotype"};

    @Override
    public void init(Node configurationNode, IAspectActionProvider factory) {
        super.init(configurationNode, factory);
        if (configurationNode == null) {
            return;
        }
        NodeList childNodes = configurationNode.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            Node stereotypeNameNode;
            String nodeName = childNodes.item(i).getNodeName();
            if ("displayName".equals(nodeName)) {
                stereotypeNameNode = childNodes.item(i).getAttributes().getNamedItem("name");
                if (stereotypeNameNode != null) {
                    this.stereotypesToDisplay.add(stereotypeNameNode.getNodeValue());
                }
            } else if ("displayQualifiedName".equals(nodeName) && (stereotypeNameNode = childNodes.item(i).getAttributes().getNamedItem("name")) != null) {
                this.stereotypesQNToDisplay.add(stereotypeNameNode.getNodeValue());
            }
            ++i;
        }
    }

    @Override
    public void save(Node parentNode) {
        for (String stereotypeName : this.listOfDisplayableStereotypes.keySet()) {
            switch (this.listOfDisplayableStereotypes.get(stereotypeName)) {
                case 1: {
                    Element displayName = ((Element)parentNode).getOwnerDocument().createElement("displayName");
                    displayName.setAttribute("name", stereotypeName);
                    ((Element)parentNode).appendChild(displayName);
                    break;
                }
                case 2: {
                    Element displayQualifiedName = ((Element)parentNode).getOwnerDocument().createElement("displayQualifiedName");
                    displayQualifiedName.setAttribute("name", stereotypeName);
                    ((Element)parentNode).appendChild(displayQualifiedName);
                    break;
                }
            }
        }
    }

    @Override
    public void run(EditPart editPart) {
        final CompositeCommand compositeCommand = new CompositeCommand("Modify Stereotype Display");
        View view = (View)editPart.getModel();
        TransactionalEditingDomain editingDomain = EditorUtils.getTransactionalEditingDomain();
        for (String stereotypeName : this.stereotypesToDisplay) {
            String presentationKind = AppliedStereotypeHelper.getAppliedStereotypePresentationKind((EModelElement)view);
            RecordingCommand command = AppliedStereotypeHelper.getAddAppliedStereotypeCommand((TransactionalEditingDomain)editingDomain, (EModelElement)view, (String)stereotypeName, (String)presentationKind);
            compositeCommand.add((IUndoableOperation)new EMFtoGMFCommandWrapper((Command)command));
        }
        for (String stereotypeName : this.stereotypesQNToDisplay) {
            RecordingCommand command = AppliedStereotypeHelper.getAddAppliedStereotypeToDisplayWithQNCommand((TransactionalEditingDomain)editingDomain, (EModelElement)view, (String)stereotypeName);
            compositeCommand.add((IUndoableOperation)new EMFtoGMFCommandWrapper((Command)command));
        }
        org.eclipse.uml2.uml.Element element = (org.eclipse.uml2.uml.Element)((View)editPart.getModel()).getElement();
        for (Stereotype stereo : element.getAppliedStereotypes()) {
            if (this.stereotypesQNToDisplay.contains(stereo.getQualifiedName()) || this.stereotypesToDisplay.contains(stereo.getQualifiedName())) continue;
            String presentationKind = AppliedStereotypeHelper.getAppliedStereotypePresentationKind((EModelElement)view);
            RecordingCommand command = AppliedStereotypeHelper.getRemoveAppliedStereotypeCommand((TransactionalEditingDomain)editingDomain, (EModelElement)view, (String)stereo.getQualifiedName(), (String)presentationKind);
            compositeCommand.add((IUndoableOperation)new EMFtoGMFCommandWrapper((Command)command));
        }
        compositeCommand.reduce();
        if (compositeCommand.canExecute()) {
            boolean isActivating = true;
            Map<String, Boolean> options = null;
            EditPartViewer viewer = editPart.getViewer();
            if (viewer instanceof DiagramGraphicalViewer) {
                isActivating = ((DiagramGraphicalViewer)viewer).isInitializing();
            }
            if (isActivating || !EditPartUtil.isWriteTransactionInProgress((IGraphicalEditPart)((IGraphicalEditPart)editPart), (boolean)false, (boolean)false)) {
                options = Collections.singletonMap("unprotected", Boolean.TRUE);
            }
            AbstractEMFOperation operation = new AbstractEMFOperation(((IGraphicalEditPart)editPart).getEditingDomain(), "", options){

                protected IStatus doExecute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                    compositeCommand.execute(monitor, info);
                    return Status.OK_STATUS;
                }
            };
            try {
                operation.execute((IProgressMonitor)new NullProgressMonitor(), null);
            }
            catch (ExecutionException e) {
                Activator.log.error((Throwable)e);
            }
        } else {
            Activator.log.error("Impossible to execute graphical post action " + this.propertiesToUpdate, null);
        }
    }

    @Override
    public Control createConfigurationComposite(Composite parent, IPaletteEntryProxy entryProxy, List<Profile> appliedProfiles) {
        this.appliedProfiles = appliedProfiles;
        this.entryProxy = entryProxy;
        if (entryProxy instanceof IPaletteAspectToolEntryProxy) {
            for (IPostAction postAction : ((IPaletteAspectToolEntryProxy)entryProxy).getPostActions()) {
                if (!(postAction instanceof StereotypePostAction)) continue;
                for (String stereotype : ((StereotypePostAction)postAction).getStereotypesToApply()) {
                    if (this.listOfDisplayableStereotypes.containsKey(stereotype)) continue;
                    this.listOfDisplayableStereotypes.put(stereotype, 0);
                }
            }
        }
        for (String stereotypeName : this.stereotypesToDisplay) {
            if (!this.listOfDisplayableStereotypes.containsKey(stereotypeName)) continue;
            this.listOfDisplayableStereotypes.put(stereotypeName, 1);
        }
        for (String stereotypeName : this.stereotypesQNToDisplay) {
            if (!this.listOfDisplayableStereotypes.containsKey(stereotypeName)) continue;
            this.listOfDisplayableStereotypes.put(stereotypeName, 2);
        }
        Composite composite = new Composite(parent, 2048);
        composite.setLayout((Layout)new GridLayout(1, false));
        Label label = new Label(composite, 0);
        label.setText("Choose applied stereotypes to display : ");
        GridData data = new GridData(4, 0x1000000, true, false);
        label.setLayoutData((Object)data);
        this.stereotypesToShowTableViewer = new TableViewer(composite, 65536);
        GridData layoutData = new GridData(4, 4, true, true);
        this.stereotypesToShowTableViewer.getControl().setLayoutData((Object)layoutData);
        this.createColumns(this.stereotypesToShowTableViewer);
        this.stereotypesToShowTableViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof HashMap) {
                    return ((HashMap)inputElement).keySet().toArray();
                }
                return null;
            }
        });
        this.stereotypesToShowTableViewer.setLabelProvider((IBaseLabelProvider)new StereotypeToDisplayLabelProvider());
        this.stereotypesToShowTableViewer.setInput(this.listOfDisplayableStereotypes);
        return composite;
    }

    protected void createColumns(TableViewer viewer) {
        TableViewerColumn columnStereotype = new TableViewerColumn(viewer, 0);
        columnStereotype.getColumn().setText("Stereotype");
        columnStereotype.getColumn().setWidth(300);
        columnStereotype.getColumn().setResizable(true);
        columnStereotype.getColumn().setMoveable(false);
        TableViewerColumn columnDisplay = new TableViewerColumn(viewer, 0);
        columnDisplay.getColumn().setText("Display");
        columnDisplay.getColumn().setWidth(300);
        columnDisplay.getColumn().setResizable(true);
        columnDisplay.getColumn().setMoveable(false);
        columnDisplay.setEditingSupport((EditingSupport)new StereotypeToDisplayEditingSupport((ColumnViewer)viewer));
        Table table = viewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
    }

    class StereotypeToDisplayEditingSupport
    extends EditingSupport {
        private CellEditor editor;

        public StereotypeToDisplayEditingSupport(ColumnViewer viewer) {
            super(viewer);
            this.editor = new ComboBoxCellEditor((Composite)((TableViewer)viewer).getTable(), DisplayAppliedStereotypePostAction.this.diplayOptions);
        }

        protected CellEditor getCellEditor(Object element) {
            return this.editor;
        }

        protected boolean canEdit(Object element) {
            return true;
        }

        protected Object getValue(Object element) {
            return DisplayAppliedStereotypePostAction.this.listOfDisplayableStereotypes.get(element);
        }

        protected void setValue(Object element, Object value) {
            DisplayAppliedStereotypePostAction.this.listOfDisplayableStereotypes.put((String)element, (Integer)value);
            this.getViewer().update(element, null);
        }
    }

    class StereotypeToDisplayLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        StereotypeToDisplayLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return (String)element;
                }
                case 1: {
                    return DisplayAppliedStereotypePostAction.this.diplayOptions[DisplayAppliedStereotypePostAction.this.listOfDisplayableStereotypes.get(element)];
                }
            }
            return null;
        }
    }
}

