/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.ui.hyperlinkshell;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.commands.wrappers.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.core.editorsfactory.IPageIconsRegistry;
import org.eclipse.papyrus.infra.hyperlink.helper.HyperLinkHelperFactory;
import org.eclipse.papyrus.infra.hyperlink.object.HyperLinkObject;
import org.eclipse.papyrus.infra.hyperlink.ui.AbstractHyperLinkTab;
import org.eclipse.papyrus.infra.hyperlink.ui.HyperLinkManagerShell;
import org.eclipse.papyrus.uml.diagram.common.ui.hyperlinkshell.HyperLinkDiagram;
import org.eclipse.papyrus.uml.diagram.common.ui.hyperlinkshell.LocalDefaultLinkDiagramTab;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdvancedHLManager
extends HyperLinkManagerShell {
    public AdvancedHLManager(IPageIconsRegistry editorFactoryRegistry, TransactionalEditingDomain domain, Element umlElement, View aview, Package model, HyperLinkHelperFactory hyperHelperFactory) {
        super(editorFactoryRegistry, domain, (EModelElement)umlElement, (EModelElement)aview, (EModelElement)model, hyperHelperFactory);
    }

    protected ArrayList<HyperLinkDiagram> getCreatedHyperlinkDiagramsWithHeuristic(ICommand creationcommand) {
        CompositeCommand compositeCommand;
        Object value;
        ArrayList diagrams = new ArrayList();
        if (creationcommand instanceof CompositeCommand && (value = (compositeCommand = (CompositeCommand)creationcommand).getCommandResult().getReturnValue()) instanceof ArrayList) {
            diagrams.addAll((Collection)value);
        }
        ArrayList<HyperLinkDiagram> hyperLinkDiagrams = new ArrayList<HyperLinkDiagram>();
        int i = 0;
        while (i < diagrams.size()) {
            HyperLinkDiagram hyperLinkDiagram = new HyperLinkDiagram();
            hyperLinkDiagram.setDiagram((Diagram)diagrams.get(i));
            hyperLinkDiagram.setIsDefault(true);
            hyperLinkDiagram.setTooltipText(((Diagram)diagrams.get(i)).getName());
            hyperLinkDiagrams.add(hyperLinkDiagram);
            ++i;
        }
        return hyperLinkDiagrams;
    }

    protected void doAction() {
        super.doAction();
        LocalDefaultLinkDiagramTab heuristicTab = this.getHeuristicTab();
        ArrayList<HyperLinkDiagram> defaultdiagramsWithHeuristic = new ArrayList<HyperLinkDiagram>();
        if (heuristicTab.getDefaultHyperlinkComposite().isVisible()) {
            heuristicTab.okPressed();
            ICommand creationCommand = heuristicTab.getCommand();
            this.transactionalEditingDomain.getCommandStack().execute((Command)new GMFtoEMFCommandWrapper(heuristicTab.getCommand()));
            defaultdiagramsWithHeuristic.addAll(this.getCreatedHyperlinkDiagramsWithHeuristic(creationCommand));
        }
        int i = 0;
        while (i < defaultdiagramsWithHeuristic.size()) {
            this.allhypHyperlinkObjects.add(0, (HyperLinkObject)defaultdiagramsWithHeuristic.get(i));
            ++i;
        }
    }

    private LocalDefaultLinkDiagramTab getHeuristicTab() {
        int i = 0;
        LocalDefaultLinkDiagramTab tab = null;
        for (AbstractHyperLinkTab current : this.tabList) {
            if (!(current instanceof LocalDefaultLinkDiagramTab)) continue;
            tab = (LocalDefaultLinkDiagramTab)current;
            ++i;
        }
        Assert.isTrue((i == 1 ? 1 : 0) != 0);
        Assert.isNotNull(tab);
        return tab;
    }
}

