/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.ElementImport;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.EnumerationLiteral;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageImport;
import org.eclipse.uml2.uml.PrimitiveType;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Util {
    public static boolean isMetaclass(Type type) {
        Stereotype firstStereotype;
        boolean isMetaclass = false;
        if (type instanceof Class && type.getAppliedStereotypes() != null && type.getAppliedStereotypes().size() > 0 && (firstStereotype = (Stereotype)type.getAppliedStereotypes().get(0)).getName().equals("Metaclass")) {
            isMetaclass = true;
        }
        return isMetaclass;
    }

    public static ArrayList getInstancesFilteredByType(Package topPackage, java.lang.Class metaType, Stereotype appliedStereotype) {
        TreeIterator iter = topPackage.eAllContents();
        ArrayList filteredElements = new ArrayList();
        while (iter.hasNext()) {
            Object currentElt = iter.next();
            if (currentElt instanceof ElementImport) {
                ElementImport elementImport = (ElementImport)currentElt;
                currentElt = elementImport.getImportedElement();
            } else if (currentElt instanceof PackageImport) {
                TreeIterator piIter = ((PackageImport)currentElt).getImportedPackage().eAllContents();
                while (piIter.hasNext()) {
                    Object piCurrentElt = piIter.next();
                    if (!(piCurrentElt instanceof Element)) continue;
                    if (appliedStereotype != null) {
                        for (Stereotype currentSt : ((Element)piCurrentElt).getAppliedStereotypes()) {
                            if (!currentSt.conformsTo((Classifier)appliedStereotype)) continue;
                            filteredElements.add(piCurrentElt);
                        }
                        continue;
                    }
                    if (metaType.isInstance(piCurrentElt)) {
                        filteredElements.add(piCurrentElt);
                        continue;
                    }
                    if (!(piCurrentElt instanceof ElementImport)) continue;
                    TreeIterator eIter = ((ElementImport)piCurrentElt).getImportedElement().eAllContents();
                    while (eIter.hasNext()) {
                        Object currentEIelt = eIter.next();
                        if (!metaType.isInstance(currentEIelt)) continue;
                        filteredElements.add(currentEIelt);
                    }
                }
            }
            if (!(currentElt instanceof Element)) continue;
            if (appliedStereotype != null) {
                for (Stereotype currentSt : ((Element)currentElt).getAppliedStereotypes()) {
                    if (!currentSt.conformsTo((Classifier)appliedStereotype)) continue;
                    filteredElements.add(currentElt);
                }
                continue;
            }
            if (metaType.isInstance(currentElt)) {
                filteredElements.add(currentElt);
                continue;
            }
            if (!(currentElt instanceof ElementImport)) continue;
            TreeIterator eIter = ((ElementImport)currentElt).getImportedElement().eAllContents();
            while (eIter.hasNext()) {
                Object currentEIelt = eIter.next();
                if (!metaType.isInstance(currentEIelt)) continue;
                filteredElements.add(currentEIelt);
            }
        }
        return filteredElements;
    }

    public static Package topPackage(Element element) {
        if (element.getOwner() == null) {
            return (Package)element;
        }
        return Util.topPackage(element.getOwner());
    }

    public static <T extends Element> T getCommonParent(Element element1, Element element2, java.lang.Class<T> parentClass) {
        int depth1 = 0;
        Element ancestor1 = element1.getOwner();
        while (ancestor1 != null) {
            ++depth1;
            ancestor1 = ancestor1.getOwner();
        }
        int depth2 = 0;
        Element ancestor2 = element2.getOwner();
        while (ancestor2 != null) {
            ++depth2;
            ancestor2 = ancestor2.getOwner();
        }
        ancestor1 = element1.getOwner();
        ancestor2 = element2.getOwner();
        Element commonParent = null;
        while (depth1 > 0 && depth2 > 0 && commonParent == null) {
            if (depth1 > depth2) {
                ancestor1 = ancestor1.getOwner();
                --depth1;
                continue;
            }
            if (depth2 > depth1) {
                ancestor2 = ancestor2.getOwner();
                --depth2;
                continue;
            }
            if (ancestor1 == ancestor2) {
                commonParent = ancestor1;
                continue;
            }
            ancestor1 = ancestor1.getOwner();
            --depth1;
            ancestor2 = ancestor2.getOwner();
            --depth2;
        }
        while (commonParent != null && !parentClass.isInstance(commonParent)) {
            commonParent = commonParent.getOwner();
        }
        return (T)commonParent;
    }

    public static Object getValueFromString(Property property, ArrayList<String> stringValues) {
        ArrayList<Object> returnedValue = new ArrayList<Object>();
        Type type = property.getType();
        if (type instanceof PrimitiveType) {
            if (type.getQualifiedName().equals("UMLPrimitiveTypes::Integer")) {
                int i = 0;
                while (i < stringValues.size()) {
                    returnedValue.add(Integer.valueOf(stringValues.get(i)));
                    ++i;
                }
            } else if (type.getQualifiedName().equals("UMLPrimitiveTypes::UnlimitedNatural")) {
                int i = 0;
                while (i < stringValues.size()) {
                    returnedValue.add(Integer.valueOf(stringValues.get(i)));
                    ++i;
                }
            } else if (type.getQualifiedName().equals("UMLPrimitiveTypes::String")) {
                int i = 0;
                while (i < stringValues.size()) {
                    returnedValue.add(stringValues.get(i));
                    ++i;
                }
            } else if (type.getQualifiedName().equals("UMLPrimitiveTypes::Boolean")) {
                int i = 0;
                while (i < stringValues.size()) {
                    returnedValue.add(Boolean.valueOf(stringValues.get(i)));
                    ++i;
                }
            } else {
                int i = 0;
                while (i < stringValues.size()) {
                    returnedValue.add(stringValues.get(i));
                    ++i;
                }
            }
        } else if (type instanceof DataType) {
            int i = 0;
            while (i < stringValues.size()) {
                returnedValue.add(stringValues.get(i));
                ++i;
            }
        }
        if (property.getUpper() == 1) {
            return returnedValue.get(0);
        }
        return returnedValue;
    }

    public static Object retrievesMetaclassElementFromString(Property property, ArrayList<String> stringValues, Element packageContainer) {
        EList profiles = ((Package)packageContainer).getAllAppliedProfiles();
        ArrayList returnedValues = new ArrayList();
        ArrayList metaclassElement = new ArrayList();
        String metaclassName = ((Class)property.getType()).getName();
        java.lang.Class<?> metaType = null;
        try {
            metaType = java.lang.Class.forName("org.eclipse.uml2.uml." + metaclassName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (Profile profile : profiles) {
            metaclassElement.addAll(Util.getInstancesFilteredByType((Package)profile, metaType, null));
        }
        for (String valuesQualifiedName : stringValues) {
            for (Object metaclassRepresentation : metaclassElement) {
                if (!(metaclassRepresentation instanceof NamedElement) || !((NamedElement)metaclassRepresentation).getQualifiedName().equals(valuesQualifiedName)) continue;
                returnedValues.add(metaclassRepresentation);
            }
        }
        if (property.getUpper() != 1) {
            return returnedValues;
        }
        if (returnedValues.size() > 0) {
            return returnedValues.get(0);
        }
        return null;
    }

    public static Object retrievesStereotypedElementFromString(Property property, ArrayList<String> stringValues, Element packageContainer) {
        ArrayList<Object> returnedValues = new ArrayList<Object>();
        ArrayList stereotypedElement = new ArrayList();
        EList profiles = ((Package)packageContainer).getAllAppliedProfiles();
        for (Profile profile : profiles) {
            stereotypedElement.addAll(Util.getInstancesFilteredByType((Package)profile, null, (Stereotype)property.getType()));
        }
        block1: for (String valuesQualifiedName : stringValues) {
            for (Object element : stereotypedElement) {
                EList subStereotypes;
                if (!(element instanceof NamedElement) || !((NamedElement)element).getQualifiedName().equals(valuesQualifiedName)) continue;
                EObject newValue = ((NamedElement)element).getStereotypeApplication((Stereotype)property.getType());
                if (newValue == null && !(subStereotypes = ((NamedElement)element).getAppliedSubstereotypes((Stereotype)property.getType())).isEmpty()) {
                    newValue = ((NamedElement)element).getStereotypeApplication((Stereotype)subStereotypes.get(0));
                }
                if (newValue != null) {
                    returnedValues.add(newValue);
                }
                returnedValues.add(element);
                continue block1;
            }
        }
        if (property.getUpper() != 1) {
            return returnedValues;
        }
        if (returnedValues.size() > 0) {
            return returnedValues.get(0);
        }
        return null;
    }

    public static Object retrievesEnumerationLiteralFromString(Property property, ArrayList<String> stringValues, Element packageContainer) {
        Enumeration enume = null;
        Type type = property.getType();
        Assert.isTrue((boolean)(type instanceof Enumeration));
        enume = (Enumeration)type;
        ArrayList<EnumerationLiteral> returnedValues = new ArrayList<EnumerationLiteral>();
        int i = 0;
        while (i < stringValues.size()) {
            EnumerationLiteral obj = enume.getOwnedLiteral(stringValues.get(i));
            returnedValues.add(obj);
            ++i;
        }
        if (property.getUpper() != 1) {
            return returnedValues;
        }
        if (returnedValues.size() > 0) {
            return returnedValues.get(0);
        }
        return null;
    }

    @Deprecated
    public static boolean isAffixedChildNode(EditPart ep) {
        return org.eclipse.papyrus.infra.gmfdiag.common.utils.Util.isAffixedChildNode((EditPart)ep);
    }

    public static Set<Classifier> getAllSuperClasses(Set<Classifier> visitedClassifier, Classifier clazz) {
        Assert.isNotNull((Object)clazz);
        if (visitedClassifier == null) {
            visitedClassifier = new HashSet<Classifier>();
        }
        for (Classifier classifier : clazz.getGenerals()) {
            if (visitedClassifier.contains(classifier)) continue;
            visitedClassifier.add(classifier);
            visitedClassifier.addAll(Util.getAllSuperClasses(visitedClassifier, classifier));
        }
        return visitedClassifier;
    }
}

