/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.component.custom.actions;

import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gmf.runtime.common.ui.util.DisplayUtils;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.papyrus.uml.diagram.common.handlers.GraphicalCommandHandler;
import org.eclipse.papyrus.uml.diagram.component.custom.messages.Messages;
import org.eclipse.papyrus.uml.diagram.component.custom.ui.InterfaceManagerDialog;
import org.eclipse.papyrus.uml.diagram.component.edit.parts.PortEditPart;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Type;

public class ManageProvidedInterfacesHandler
extends GraphicalCommandHandler {
    protected Command getCommand() throws ExecutionException {
        List selection = this.getSelectedElements();
        if (selection.size() != 1) {
            return UnexecutableCommand.INSTANCE;
        }
        if (!(selection.get(0) instanceof PortEditPart)) {
            return UnexecutableCommand.INSTANCE;
        }
        ManageProvidedInterfaceAction action = new ManageProvidedInterfaceAction((IGraphicalEditPart)selection.get(0));
        return action.getCommand();
    }

    public boolean isEnabled() {
        if (this.getSelectedElements().size() == 1) {
            EObject obj = ((View)((IGraphicalEditPart)this.getSelectedElements().get(0)).getModel()).getElement();
            return obj instanceof Port;
        }
        return false;
    }

    public class ManageProvidedInterfaceAction {
        private Port port;
        private Type type;

        public ManageProvidedInterfaceAction(IGraphicalEditPart editpart) {
            EObject obj = ((View)editpart.getModel()).getElement();
            Assert.isTrue((boolean)(obj instanceof Port));
            this.port = (Port)obj;
            this.type = this.port.getType();
        }

        public Command getCommand() {
            if (this.type != null && !(this.type instanceof Classifier)) {
                return UnexecutableCommand.INSTANCE;
            }
            if (this.type == null) {
                MessageDialog dialog = new MessageDialog(DisplayUtils.getDefaultShell(), Messages.InterfaceManagerDialog_Title, null, Messages.ManageProvidedInterfacesHandler_TheTypeOfThePortIsNotDefined, 4, new String[]{Messages.ManageProvidedInterfacesHandler_OK}, 0);
                dialog.open();
            } else {
                InterfaceManagerDialog dialog = new InterfaceManagerDialog(DisplayUtils.getDefaultShell(), this.port);
                if (dialog.open() == 0) {
                    return dialog.getCommand();
                }
            }
            return UnexecutableCommand.INSTANCE;
        }
    }
}

