/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.composite.custom.edit.command;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateRelationshipRequest;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.papyrus.uml.diagram.composite.custom.messages.Messages;
import org.eclipse.papyrus.uml.diagram.composite.custom.ui.CollaborationRoleTreeContentProvider;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.uml2.uml.CollaborationUse;
import org.eclipse.uml2.uml.ConnectableElement;
import org.eclipse.uml2.uml.Dependency;
import org.eclipse.uml2.uml.UMLFactory;

public class RoleBindingCreateCommand
extends org.eclipse.papyrus.uml.diagram.composite.edit.commands.RoleBindingCreateCommand {
    public RoleBindingCreateCommand(CreateRelationshipRequest request, EObject source, EObject target) {
        super(request, source, target);
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (!this.canExecute()) {
            throw new ExecutionException(Messages.RoleBindingCreateCommand_INVALID_ARGS_MSG);
        }
        CollaborationUse graphicalSource = (CollaborationUse)this.getSource();
        ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        Shell currentShell = new Shell(Display.getCurrent(), 67680);
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(currentShell, (ILabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)adapterFactory), (ITreeContentProvider)new CollaborationRoleTreeContentProvider());
        dialog.setTitle(Messages.RoleBindingRoleSelectionDialog_Title);
        dialog.setMessage(Messages.RoleBindingRoleSelectionDialog_Message);
        dialog.setAllowMultiple(false);
        dialog.setHelpAvailable(false);
        dialog.setInput((Object)graphicalSource);
        dialog.open();
        if (dialog.getReturnCode() == 0) {
            ConnectableElement roleToBind = (ConnectableElement)dialog.getFirstResult();
            Dependency newBinding = UMLFactory.eINSTANCE.createDependency();
            this.getContainer().getPackagedElements().add((Object)newBinding);
            newBinding.getClients().add((Object)roleToBind);
            newBinding.setName("binding_" + roleToBind.getName() + "_" + this.getTarget().getName());
            newBinding.getSuppliers().add((Object)this.getTarget());
            graphicalSource.getRoleBindings().add((Object)newBinding);
            this.doConfigure(newBinding, monitor, info);
            ((CreateElementRequest)this.getRequest()).setNewElement((EObject)newBinding);
            return CommandResult.newOKCommandResult((Object)newBinding);
        }
        return CommandResult.newCancelledCommandResult();
    }
}

