/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.composite.custom.helper;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.editpolicies.IMaskManagedLabelEditPolicy;
import org.eclipse.papyrus.uml.diagram.common.helper.StereotypedElementLabelHelper;
import org.eclipse.papyrus.uml.tools.utils.ParameterUtil;
import org.eclipse.uml2.uml.Parameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParameterLabelHelper
extends StereotypedElementLabelHelper {
    private static ParameterLabelHelper labelHelper;
    protected final Map<Integer, String> masks = new HashMap<Integer, String>(7);

    public static ParameterLabelHelper getInstance() {
        if (labelHelper == null) {
            labelHelper = new ParameterLabelHelper();
        }
        return labelHelper;
    }

    public String getMaskLabel(int value) {
        return this.masks.get(value);
    }

    public Collection<String> getMaskLabels() {
        return this.masks.values();
    }

    public Map<Integer, String> getMasks() {
        return this.masks;
    }

    public Set<Integer> getMaskValues() {
        return this.masks.keySet();
    }

    protected ParameterLabelHelper() {
        this.masks.clear();
        this.masks.put(2048, "Direction");
        this.masks.put(4096, "Name");
        this.masks.put(256, "Type");
    }

    protected String elementLabel(GraphicalEditPart editPart) {
        Parameter elem;
        int displayValue = 6400;
        IMaskManagedLabelEditPolicy policy = (IMaskManagedLabelEditPolicy)editPart.getEditPolicy((Object)"MaskManagedLabelPolicy");
        if (policy != null) {
            displayValue = policy.getCurrentDisplayValue();
        }
        if ((elem = this.getUMLElement(editPart)) != null) {
            return ParameterUtil.getCustomLabel((Parameter)elem, (int)displayValue);
        }
        return "";
    }

    public Parameter getUMLElement(GraphicalEditPart editPart) {
        return (Parameter)((View)editPart.getModel()).getElement();
    }
}

