/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.profile.custom.commands;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.profile.definition.PapyrusDefinitionAnnotation;
import org.eclipse.papyrus.uml.profile.definition.ProfileRedefinition;
import org.eclipse.papyrus.uml.tools.utils.PackageUtil;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;

public class DefineProfileCommand
extends AbstractTransactionalCommand {
    private EditPartViewer viewer;
    private PapyrusDefinitionAnnotation papyrusAnnotation;
    private Profile rootProfile;

    public DefineProfileCommand(TransactionalEditingDomain domain, PapyrusDefinitionAnnotation papyrusAnnotation, Profile rootProfile, EditPartViewer viewer) {
        super(domain, "DefineProfileCommand", null);
        this.viewer = viewer;
        this.rootProfile = rootProfile;
        this.papyrusAnnotation = papyrusAnnotation;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        PackageUtil.defineProfiles((Package)this.rootProfile);
        try {
            ProfileRedefinition.redefineProfile((Package)this.rootProfile, (PapyrusDefinitionAnnotation)this.papyrusAnnotation);
            ProfileRedefinition.cleanProfile((Package)this.rootProfile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setResult(CommandResult.newOKCommandResult());
        return CommandResult.newOKCommandResult();
    }

    public List getAffectedFiles() {
        View view;
        EditPart editpart;
        if (this.viewer != null && (editpart = this.viewer.getRootEditPart().getContents()) instanceof IGraphicalEditPart && (view = (View)((IGraphicalEditPart)editpart).getModel()) != null) {
            IFile f = WorkspaceSynchronizer.getFile((Resource)view.eResource());
            return f != null ? Collections.singletonList(f) : Collections.EMPTY_LIST;
        }
        return super.getAffectedFiles();
    }
}

