/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.statemachine.custom.listeners;

import java.util.Collections;
import java.util.Set;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.GroupRequest;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.CommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.internal.commands.RefreshEditPartCommand;
import org.eclipse.gmf.runtime.diagram.ui.requests.DropObjectsRequest;
import org.eclipse.papyrus.uml.diagram.statemachine.custom.listeners.AbstractModifcationTriggerListener;
import org.eclipse.papyrus.uml.diagram.statemachine.edit.parts.StateEditPart;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.UMLPackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StateBehaviorsListener
extends AbstractModifcationTriggerListener {
    @Override
    protected boolean isCorrectStructuralfeature(EStructuralFeature eStructuralFeature) {
        return UMLPackage.Literals.STATE__DO_ACTIVITY.equals(eStructuralFeature) || UMLPackage.Literals.STATE__EXIT.equals(eStructuralFeature) || UMLPackage.Literals.STATE__ENTRY.equals(eStructuralFeature);
    }

    @Override
    protected CompositeCommand getModificationCommand(Notification notif) {
        Request createRequest = null;
        Request deleteRequest = null;
        if (notif.getEventType() == 1) {
            Object object = notif.getNewValue();
            Object oldObject = notif.getOldValue();
            StateEditPart stateEditPart = this.getContainingEditPart(notif.getNotifier());
            if (stateEditPart != null) {
                Command cmd2;
                if (object instanceof Behavior) {
                    createRequest = this.getCreateRequest(object, stateEditPart);
                }
                deleteRequest = this.getDeleteRequest(oldObject, stateEditPart);
                CompositeCommand cc = new CompositeCommand("Modification command triggered by modedication of one of the behaviros of selected state");
                Command cmd1 = this.getCommandFromRequest(createRequest, (IGraphicalEditPart)stateEditPart);
                if (cmd1 != null && cmd1.canExecute()) {
                    cc.compose((IUndoableOperation)new CommandProxy(cmd1));
                }
                if ((cmd2 = this.getCommandFromRequest(deleteRequest, (IGraphicalEditPart)stateEditPart)) != null && cmd2.canExecute()) {
                    cc.compose((IUndoableOperation)new CommandProxy(cmd2));
                }
                this.refreshEditParts(cc, Collections.singleton(stateEditPart));
                return cc;
            }
        }
        return null;
    }

    protected Command getCommandFromRequest(Request request, IGraphicalEditPart editPart) {
        if (request != null) {
            return editPart.getCommand(request);
        }
        return null;
    }

    private Request getDeleteRequest(Object oldObject, StateEditPart stateEditPart) {
        Behavior oldBehavior;
        IGraphicalEditPart iGrapEditPart;
        GroupRequest request = null;
        if (oldObject instanceof Behavior && (iGrapEditPart = this.getChildByEObject((EObject)(oldBehavior = (Behavior)oldObject), (IGraphicalEditPart)stateEditPart, false)) != null) {
            request = new GroupRequest((Object)"delete");
            request.setEditParts((EditPart)iGrapEditPart);
        }
        return request;
    }

    private Request getCreateRequest(Object object, StateEditPart stateEditPart) {
        Behavior behavior = (Behavior)object;
        DropObjectsRequest request = new DropObjectsRequest();
        request.setLocation(new Point(1, 1));
        request.setObjects(Collections.singletonList(behavior));
        return request;
    }

    protected StateEditPart getContainingEditPart(Object toTest) {
        if (toTest == null && toTest instanceof EObject) {
            return null;
        }
        IGraphicalEditPart found = this.getChildByEObject((EObject)toTest, (IGraphicalEditPart)this.getDiagramEditPart(), false);
        if (found instanceof StateEditPart) {
            return (StateEditPart)found;
        }
        return null;
    }

    protected void refreshEditParts(CompositeCommand cc, Set<IGraphicalEditPart> set) {
        for (IGraphicalEditPart part : set) {
            RefreshEditPartCommand refreshEditPart = new RefreshEditPartCommand(part, true);
            if (refreshEditPart == null || !refreshEditPart.canExecute()) continue;
            cc.compose((IUndoableOperation)refreshEditPart);
        }
    }
}

