/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.usecase.edit.policies;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.DeferredLayoutCommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.SetBoundsCommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.SetViewMutabilityCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.CanonicalEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateConnectionViewRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.emf.commands.core.command.CompositeTransactionalCommand;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.Location;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.Size;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.diagram.usecase.part.UMLDiagramUpdater;
import org.eclipse.papyrus.uml.diagram.usecase.part.UMLLinkDescriptor;
import org.eclipse.papyrus.uml.diagram.usecase.part.UMLNodeDescriptor;
import org.eclipse.papyrus.uml.diagram.usecase.part.UMLVisualIDRegistry;
import org.eclipse.uml2.uml.UMLPackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UseCaseDiagramCanonicalEditPolicy
extends CanonicalEditPolicy {
    private Set<EStructuralFeature> myFeaturesToSynchronize;

    protected void refreshOnActivate() {
        List c = this.getHost().getChildren();
        int i = 0;
        while (i < c.size()) {
            ((EditPart)c.get(i)).activate();
            ++i;
        }
        super.refreshOnActivate();
    }

    protected List getSemanticChildrenList() {
        View viewObject = (View)this.getHost().getModel();
        LinkedList<EObject> result = new LinkedList<EObject>();
        List<UMLNodeDescriptor> childDescriptors = UMLDiagramUpdater.getPackage_1000SemanticChildren(viewObject);
        for (UMLNodeDescriptor d : childDescriptors) {
            result.add(d.getModelElement());
        }
        return result;
    }

    protected boolean isOrphaned(Collection<EObject> semanticChildren, View view) {
        return this.isMyDiagramElement(view) && !semanticChildren.contains(view.getElement());
    }

    private boolean isMyDiagramElement(View view) {
        int visualID = UMLVisualIDRegistry.getVisualID(view);
        switch (visualID) {
            case 2011: 
            case 2012: 
            case 2013: 
            case 2014: 
            case 2015: 
            case 2016: 
            case 2017: 
            case 2018: 
            case 2019: 
            case 2022: 
            case 2023: {
                return true;
            }
        }
        return false;
    }

    protected Set getFeaturesToSynchronize() {
        if (this.myFeaturesToSynchronize == null) {
            this.myFeaturesToSynchronize = new HashSet<EStructuralFeature>();
            this.myFeaturesToSynchronize.add((EStructuralFeature)UMLPackage.eINSTANCE.getPackage_PackagedElement());
            this.myFeaturesToSynchronize.add((EStructuralFeature)UMLPackage.eINSTANCE.getElement_OwnedComment());
        }
        return this.myFeaturesToSynchronize;
    }

    protected void refreshSemantic() {
        if (this.resolveSemanticElement() == null) {
            return;
        }
        LinkedList<IAdaptable> createdViews = new LinkedList<IAdaptable>();
        List<UMLNodeDescriptor> childDescriptors = UMLDiagramUpdater.getPackage_1000SemanticChildren((View)this.getHost().getModel());
        LinkedList orphaned = new LinkedList();
        LinkedList<View> knownViewChildren = new LinkedList<View>();
        for (View v : this.getViewChildren()) {
            if (!this.isMyDiagramElement(v)) continue;
            knownViewChildren.add(v);
        }
        HashMap potentialViews = new HashMap();
        Iterator<UMLNodeDescriptor> descriptorsIterator = childDescriptors.iterator();
        while (descriptorsIterator.hasNext()) {
            UMLNodeDescriptor next = descriptorsIterator.next();
            String hint = UMLVisualIDRegistry.getType(next.getVisualID());
            LinkedList perfectMatch = new LinkedList();
            LinkedList<View> potentialMatch = new LinkedList<View>();
            for (View childView : this.getViewChildren()) {
                EObject semanticElement = childView.getElement();
                if (!next.getModelElement().equals(semanticElement)) continue;
                if (hint.equals(childView.getType())) {
                    perfectMatch.add(childView);
                    continue;
                }
                potentialMatch.add(childView);
            }
            if (perfectMatch.size() > 0) {
                descriptorsIterator.remove();
                knownViewChildren.remove(perfectMatch.getFirst());
                continue;
            }
            if (potentialMatch.size() <= 0) continue;
            potentialViews.put(next, potentialMatch);
        }
        orphaned.addAll(knownViewChildren);
        CompositeTransactionalCommand boundsCommand = new CompositeTransactionalCommand(this.host().getEditingDomain(), DiagramUIMessages.SetLocationCommand_Label_Resize);
        ArrayList<CreateViewRequest.ViewDescriptor> viewDescriptors = new ArrayList<CreateViewRequest.ViewDescriptor>(childDescriptors.size());
        for (UMLNodeDescriptor next : childDescriptors) {
            String hint = UMLVisualIDRegistry.getType(next.getVisualID());
            CanonicalEditPolicy.CanonicalElementAdapter elementAdapter = new CanonicalEditPolicy.CanonicalElementAdapter(next.getModelElement(), hint);
            CreateViewRequest.ViewDescriptor descriptor = new CreateViewRequest.ViewDescriptor((IAdaptable)elementAdapter, Node.class, hint, -1, false, this.host().getDiagramPreferencesHint());
            viewDescriptors.add(descriptor);
            LinkedList possibleMatches = (LinkedList)potentialViews.get(next);
            if (possibleMatches != null) {
                possibleMatches.retainAll(knownViewChildren);
            }
            if (possibleMatches == null || possibleMatches.isEmpty()) continue;
            View originalView = (View)possibleMatches.getFirst();
            knownViewChildren.remove(originalView);
            if (!(originalView instanceof Node)) continue;
            if (((Node)originalView).getLayoutConstraint() instanceof Bounds) {
                Bounds b = (Bounds)((Node)originalView).getLayoutConstraint();
                boundsCommand.add((IUndoableOperation)new SetBoundsCommand(boundsCommand.getEditingDomain(), boundsCommand.getLabel(), (IAdaptable)descriptor, new Rectangle(b.getX(), b.getY(), b.getWidth(), b.getHeight())));
                continue;
            }
            if (((Node)originalView).getLayoutConstraint() instanceof Location) {
                Location l = (Location)((Node)originalView).getLayoutConstraint();
                boundsCommand.add((IUndoableOperation)new SetBoundsCommand(boundsCommand.getEditingDomain(), boundsCommand.getLabel(), (IAdaptable)descriptor, new Point(l.getX(), l.getY())));
                continue;
            }
            if (!(((Node)originalView).getLayoutConstraint() instanceof Size)) continue;
            Size s = (Size)((Node)originalView).getLayoutConstraint();
            boundsCommand.add((IUndoableOperation)new SetBoundsCommand(boundsCommand.getEditingDomain(), boundsCommand.getLabel(), (IAdaptable)descriptor, new Dimension(s.getWidth(), s.getHeight())));
        }
        boolean changed = this.deleteViews(orphaned.iterator());
        CreateViewRequest request = this.getCreateViewRequest(viewDescriptors);
        Command cmd = this.getCreateViewCommand((CreateRequest)request);
        if (cmd != null && cmd.canExecute()) {
            SetViewMutabilityCommand.makeMutable((IAdaptable)new EObjectAdapter((EObject)this.host().getNotationView())).execute();
            this.executeCommand(cmd);
            if (boundsCommand.canExecute()) {
                this.executeCommand((Command)new ICommandProxy(boundsCommand.reduce()));
            }
            List nl = (List)request.getNewObject();
            createdViews.addAll(nl);
        }
        if (changed || createdViews.size() > 0) {
            this.postProcessRefreshSemantic(createdViews);
        }
        Collection<IAdaptable> createdConnectionViews = this.refreshConnections();
        if (createdViews.size() > 1) {
            DeferredLayoutCommand layoutCmd = new DeferredLayoutCommand(this.host().getEditingDomain(), createdViews, this.host());
            this.executeCommand((Command)new ICommandProxy((ICommand)layoutCmd));
        }
        createdViews.addAll(createdConnectionViews);
        this.makeViewsImmutable(createdViews);
    }

    private Diagram getDiagram() {
        return ((View)this.getHost().getModel()).getDiagram();
    }

    private Collection<IAdaptable> refreshConnections() {
        HashMap<EObject, View> domain2NotationMap = new HashMap<EObject, View>();
        Collection<UMLLinkDescriptor> linkDescriptors = this.collectAllLinks((View)this.getDiagram(), domain2NotationMap);
        LinkedList existingLinks = new LinkedList(this.getDiagram().getEdges());
        Iterator linksIterator = existingLinks.iterator();
        block0: while (linksIterator.hasNext()) {
            Edge nextDiagramLink = (Edge)linksIterator.next();
            int diagramLinkVisualID = UMLVisualIDRegistry.getVisualID((View)nextDiagramLink);
            if (diagramLinkVisualID == -1) {
                if (nextDiagramLink.getSource() == null || nextDiagramLink.getTarget() == null) continue;
                linksIterator.remove();
                continue;
            }
            EObject diagramLinkObject = nextDiagramLink.getElement();
            EObject diagramLinkSrc = nextDiagramLink.getSource().getElement();
            EObject diagramLinkDst = nextDiagramLink.getTarget().getElement();
            Iterator<UMLLinkDescriptor> linkDescriptorsIterator = linkDescriptors.iterator();
            while (linkDescriptorsIterator.hasNext()) {
                UMLLinkDescriptor nextLinkDescriptor = linkDescriptorsIterator.next();
                if (diagramLinkObject != nextLinkDescriptor.getModelElement() || diagramLinkSrc != nextLinkDescriptor.getSource() || diagramLinkDst != nextLinkDescriptor.getDestination() || diagramLinkVisualID != nextLinkDescriptor.getVisualID()) continue;
                linksIterator.remove();
                linkDescriptorsIterator.remove();
                continue block0;
            }
        }
        this.deleteViews(existingLinks.iterator());
        return this.createConnections(linkDescriptors, domain2NotationMap);
    }

    private Collection<UMLLinkDescriptor> collectAllLinks(View view, Map<EObject, View> domain2NotationMap) {
        if (!"UseCase".equals(UMLVisualIDRegistry.getModelID(view))) {
            return Collections.emptyList();
        }
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        switch (UMLVisualIDRegistry.getVisualID(view)) {
            case 1000: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getPackage_1000ContainedLinks(view));
                }
                if (domain2NotationMap.containsKey(view.getElement()) && view.getEAnnotation("Shortcut") != null) break;
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 2011: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getActor_2011ContainedLinks(view));
                }
                if (domain2NotationMap.containsKey(view.getElement()) && view.getEAnnotation("Shortcut") != null) break;
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 2012: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getActor_2012ContainedLinks(view));
                }
                if (domain2NotationMap.containsKey(view.getElement()) && view.getEAnnotation("Shortcut") != null) break;
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 2013: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getUseCase_2013ContainedLinks(view));
                }
                if (domain2NotationMap.containsKey(view.getElement()) && view.getEAnnotation("Shortcut") != null) break;
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 2014: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getUseCase_2014ContainedLinks(view));
                }
                if (domain2NotationMap.containsKey(view.getElement()) && view.getEAnnotation("Shortcut") != null) break;
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 2015: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getClassifier_2015ContainedLinks(view));
                }
                if (domain2NotationMap.containsKey(view.getElement()) && view.getEAnnotation("Shortcut") != null) break;
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 2016: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getPackage_2016ContainedLinks(view));
                }
                if (domain2NotationMap.containsKey(view.getElement()) && view.getEAnnotation("Shortcut") != null) break;
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 2017: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getConstraint_2017ContainedLinks(view));
                }
                if (domain2NotationMap.containsKey(view.getElement()) && view.getEAnnotation("Shortcut") != null) break;
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 2018: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getComment_2018ContainedLinks(view));
                }
                if (domain2NotationMap.containsKey(view.getElement()) && view.getEAnnotation("Shortcut") != null) break;
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 2022: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getNamedElement_2022ContainedLinks(view));
                }
                if (domain2NotationMap.containsKey(view.getElement()) && view.getEAnnotation("Shortcut") != null) break;
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 2023: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getNamedElement_2023ContainedLinks(view));
                }
                if (domain2NotationMap.containsKey(view.getElement()) && view.getEAnnotation("Shortcut") != null) break;
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 2019: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getDiagram_2019ContainedLinks(view));
                }
                if (domain2NotationMap.containsKey(view.getElement()) && view.getEAnnotation("Shortcut") != null) break;
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 3009: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getUseCase_3009ContainedLinks(view));
                }
                if (domain2NotationMap.containsKey(view.getElement()) && view.getEAnnotation("Shortcut") != null) break;
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 3016: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getComponent_3016ContainedLinks(view));
                }
                if (domain2NotationMap.containsKey(view.getElement()) && view.getEAnnotation("Shortcut") != null) break;
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 3015: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getComment_3015ContainedLinks(view));
                }
                if (domain2NotationMap.containsKey(view.getElement()) && view.getEAnnotation("Shortcut") != null) break;
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 3017: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getConstraint_3017ContainedLinks(view));
                }
                if (domain2NotationMap.containsKey(view.getElement()) && view.getEAnnotation("Shortcut") != null) break;
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 3018: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getActor_3018ContainedLinks(view));
                }
                if (domain2NotationMap.containsKey(view.getElement()) && view.getEAnnotation("Shortcut") != null) break;
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 3010: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getConstraint_3010ContainedLinks(view));
                }
                if (domain2NotationMap.containsKey(view.getElement()) && view.getEAnnotation("Shortcut") != null) break;
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 3011: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getActor_3011ContainedLinks(view));
                }
                if (domain2NotationMap.containsKey(view.getElement()) && view.getEAnnotation("Shortcut") != null) break;
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 3012: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getUseCase_3012ContainedLinks(view));
                }
                if (domain2NotationMap.containsKey(view.getElement()) && view.getEAnnotation("Shortcut") != null) break;
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 3013: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getComponent_3013ContainedLinks(view));
                }
                if (domain2NotationMap.containsKey(view.getElement()) && view.getEAnnotation("Shortcut") != null) break;
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 3014: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getPackage_3014ContainedLinks(view));
                }
                if (domain2NotationMap.containsKey(view.getElement()) && view.getEAnnotation("Shortcut") != null) break;
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 4008: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getInclude_4008ContainedLinks(view));
                }
                if (domain2NotationMap.containsKey(view.getElement()) && view.getEAnnotation("Shortcut") != null) break;
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 4009: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getExtend_4009ContainedLinks(view));
                }
                if (domain2NotationMap.containsKey(view.getElement()) && view.getEAnnotation("Shortcut") != null) break;
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 4010: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getGeneralization_4010ContainedLinks(view));
                }
                if (domain2NotationMap.containsKey(view.getElement()) && view.getEAnnotation("Shortcut") != null) break;
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 4011: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getAssociation_4011ContainedLinks(view));
                }
                if (domain2NotationMap.containsKey(view.getElement()) && view.getEAnnotation("Shortcut") != null) break;
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 4013: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getDependency_4013ContainedLinks(view));
                }
                if (domain2NotationMap.containsKey(view.getElement()) && view.getEAnnotation("Shortcut") != null) break;
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 4015: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getAbstraction_4015ContainedLinks(view));
                }
                if (domain2NotationMap.containsKey(view.getElement()) && view.getEAnnotation("Shortcut") != null) break;
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 4016: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getUsage_4016ContainedLinks(view));
                }
                if (domain2NotationMap.containsKey(view.getElement()) && view.getEAnnotation("Shortcut") != null) break;
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 4017: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getRealization_4017ContainedLinks(view));
                }
                if (domain2NotationMap.containsKey(view.getElement()) && view.getEAnnotation("Shortcut") != null) break;
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 4018: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getPackageMerge_4018ContainedLinks(view));
                }
                if (domain2NotationMap.containsKey(view.getElement()) && view.getEAnnotation("Shortcut") != null) break;
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 4019: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getPackageImport_4019ContainedLinks(view));
                }
                if (domain2NotationMap.containsKey(view.getElement()) && view.getEAnnotation("Shortcut") != null) break;
                domain2NotationMap.put(view.getElement(), view);
            }
        }
        Iterator children = view.getChildren().iterator();
        while (children.hasNext()) {
            result.addAll(this.collectAllLinks((View)children.next(), domain2NotationMap));
        }
        Iterator edges = view.getSourceEdges().iterator();
        while (edges.hasNext()) {
            result.addAll(this.collectAllLinks((View)edges.next(), domain2NotationMap));
        }
        return result;
    }

    private Collection<IAdaptable> createConnections(Collection<UMLLinkDescriptor> linkDescriptors, Map<EObject, View> domain2NotationMap) {
        LinkedList<IAdaptable> adapters = new LinkedList<IAdaptable>();
        for (UMLLinkDescriptor nextLinkDescriptor : linkDescriptors) {
            EditPart sourceEditPart = this.getEditPart(nextLinkDescriptor.getSource(), domain2NotationMap);
            EditPart targetEditPart = this.getEditPart(nextLinkDescriptor.getDestination(), domain2NotationMap);
            if (sourceEditPart == null || targetEditPart == null) continue;
            CreateConnectionViewRequest.ConnectionViewDescriptor descriptor = new CreateConnectionViewRequest.ConnectionViewDescriptor(nextLinkDescriptor.getSemanticAdapter(), UMLVisualIDRegistry.getType(nextLinkDescriptor.getVisualID()), -1, false, ((IGraphicalEditPart)this.getHost()).getDiagramPreferencesHint());
            CreateConnectionViewRequest ccr = new CreateConnectionViewRequest(descriptor);
            ccr.setType((Object)"connection start");
            ccr.setSourceEditPart(sourceEditPart);
            sourceEditPart.getCommand((Request)ccr);
            ccr.setTargetEditPart(targetEditPart);
            ccr.setType((Object)"connection end");
            Command cmd = targetEditPart.getCommand((Request)ccr);
            if (cmd == null || !cmd.canExecute()) continue;
            this.executeCommand(cmd);
            IAdaptable viewAdapter = (IAdaptable)ccr.getNewObject();
            if (viewAdapter == null) continue;
            adapters.add(viewAdapter);
        }
        return adapters;
    }

    private EditPart getEditPart(EObject domainModelElement, Map<EObject, View> domain2NotationMap) {
        View view = domain2NotationMap.get(domainModelElement);
        if (view != null) {
            return (EditPart)this.getHost().getViewer().getEditPartRegistry().get(view);
        }
        return null;
    }
}

