/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.oclconstraintevaluation;

import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.ocl.examples.domain.values.Value;
import org.eclipse.ocl.examples.pivot.Environment;
import org.eclipse.ocl.examples.pivot.ExpressionInOCL;
import org.eclipse.ocl.examples.pivot.OCL;
import org.eclipse.ocl.examples.pivot.helper.OCLHelper;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.pivot.utilities.PivotEnvironment;
import org.eclipse.ocl.examples.pivot.utilities.PivotEnvironmentFactory;
import org.eclipse.ocl.examples.xtext.base.utilities.ElementUtil;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.part.ViewPart;

public class OCLEvaluationView
extends ViewPart {
    private Text textViewer;
    public static String ID = "org.eclipse.papyrus.uml.oclconstraintevaluation.OCLEvaluationView";
    protected MetaModelManager metaModelManager = null;

    public void setFocus() {
        this.textViewer.setFocus();
    }

    public void createPartControl(Composite parent) {
        this.textViewer = new Text(parent, 2818);
        this.textViewer.setEditable(false);
        this.textViewer.setBackground(Display.getDefault().getSystemColor(1));
    }

    protected MetaModelManager getMetaModelManager(EObject contextObject) {
        MetaModelManager metaModelManager = ElementUtil.findMetaModelManager((EObject)contextObject);
        if (metaModelManager != null) {
            return metaModelManager;
        }
        if (metaModelManager == null) {
            metaModelManager = new MetaModelManager();
        }
        return metaModelManager;
    }

    public void compute(EObject contextObject, String expression) {
        MetaModelManager metaModelManager = this.getMetaModelManager(contextObject);
        PivotEnvironmentFactory envFactory = new PivotEnvironmentFactory(null, metaModelManager);
        PivotEnvironment environment = envFactory.createEnvironment();
        OCL ocl = OCL.newInstance((Environment)environment);
        OCLHelper oclHelper = ocl.createOCLHelper(contextObject);
        oclHelper.setContext((EClassifier)contextObject.eClass());
        try {
            ExpressionInOCL createQuery = oclHelper.createQuery(expression);
            Value evaluate = ocl.evaluate((Object)contextObject, createQuery);
            String print = evaluate.asObject().toString();
            this.textViewer.selectAll();
            this.textViewer.clearSelection();
            this.textViewer.setText("value = " + print);
        }
        catch (Exception ex) {
            this.textViewer.setText("\nERROR " + ex);
        }
    }
}

