/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.profilefacet.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.facet.infra.facet.Facet;
import org.eclipse.emf.facet.infra.facet.FacetSet;
import org.eclipse.emf.facet.infra.query.ModelQuerySet;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.FacetAttributeColumn;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.FacetReferenceColumn;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.TableInstance;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance2.TableInstance2;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.papyrus.commands.wrappers.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.table.controlmode.helpers.TableMoveHelper;
import org.eclipse.papyrus.infra.table.instance.papyrustableinstance.PapyrusTableInstance;
import org.eclipse.papyrus.uml.profilefacet.Activator;
import org.eclipse.papyrus.uml.profilefacet.metamodel.profilefacet.StereotypePropertyElement;
import org.eclipse.papyrus.uml.profilefacet.utils.AdditionalContentsUtils;
import org.eclipse.papyrus.uml.profilefacet.utils.ModelQuerySetUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ProfileFacetSetMoveHelper {
    private ProfileFacetSetMoveHelper() {
    }

    public static Collection<PapyrusTableInstance> getTablesToMove(EObject semanticObject) {
        return TableMoveHelper.getPapyrusTableInstances((EObject)semanticObject);
    }

    public static Command createMergeFacetSetsCommand(EditingDomain domain, EObject selection, Resource sourceResource, Resource targetResource) {
        Collection pTables = TableMoveHelper.getPapyrusTableInstances((EObject)selection);
        return ProfileFacetSetMoveHelper.createMergeFacetSetsCommand(domain, pTables, sourceResource, targetResource);
    }

    public static Command createMergeFacetSetsCommand(EditingDomain domain, Collection<PapyrusTableInstance> pTables, Resource sourceResource, Resource targetResource) {
        if (!(domain instanceof TransactionalEditingDomain)) {
            Activator.log.error("the editing domain is not transactional", null);
            return UnexecutableCommand.INSTANCE;
        }
        if (!(sourceResource instanceof XMIResource) || !(targetResource instanceof XMIResource)) {
            Activator.log.error("Resources are not XMI resources", null);
            return UnexecutableCommand.INSTANCE;
        }
        if (!pTables.isEmpty()) {
            CompoundCommand compoundCommand = new CompoundCommand();
            for (PapyrusTableInstance papyrusTableInstance : pTables) {
                MergeFacetSetsCommand mergeCommand = new MergeFacetSetsCommand((TransactionalEditingDomain)domain, papyrusTableInstance, (XMIResource)sourceResource, (XMIResource)targetResource);
                compoundCommand.append((Command)new GMFtoEMFCommandWrapper((ICommand)mergeCommand));
            }
            return compoundCommand;
        }
        return null;
    }

    public static void addAllFacetSetMoveCommands(EditingDomain domain, EObject selection, Resource source, Resource target, CompoundCommand commandToModify) {
        Command command = ProfileFacetSetMoveHelper.createMergeFacetSetsCommand(domain, selection, (Resource)((XMIResource)source), (Resource)((XMIResource)target));
        if (command != null) {
            commandToModify.append(command);
        }
    }

    public static final FacetSet getRootFacetSet(Facet facet) {
        FacetSet set = (FacetSet)facet.eContainer();
        while (set.eContainer() != null && set.eContainer() instanceof FacetSet) {
            set = (FacetSet)set.eContainer();
        }
        return set;
    }

    private static Command getUpdateFacetElementReferencesCommand(TransactionalEditingDomain domain, Collection<PapyrusTableInstance> papyrusTables, Map<EObject, EObject> sourceToTarget) {
        CompoundCommand updateCommand = new CompoundCommand("Update References To facet Element Command");
        ArrayList<TableInstance2> tableInstances = new ArrayList<TableInstance2>();
        for (PapyrusTableInstance pTable : papyrusTables) {
            tableInstances.add(pTable.getTable());
        }
        for (PapyrusTableInstance pTable : papyrusTables) {
            for (final EObject eobjectSource : sourceToTarget.keySet()) {
                EObject eobject;
                ECrossReferenceAdapter adapter;
                final EObject eobjectTarget = sourceToTarget.get(eobjectSource);
                if (eobjectSource instanceof StereotypePropertyElement) {
                    adapter = ECrossReferenceAdapter.getCrossReferenceAdapter((Notifier)eobjectSource);
                    for (final EStructuralFeature.Setting setting : adapter.getNonNavigableInverseReferences(eobjectSource)) {
                        TableInstance t;
                        eobject = setting.getEObject();
                        if (!(eobject instanceof FacetAttributeColumn) && !(eobject instanceof FacetReferenceColumn) || !tableInstances.contains(t = (TableInstance)eobject.eContainer())) continue;
                        AbstractTransactionalCommand cmd = new AbstractTransactionalCommand(domain, null, null){

                            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                                EcoreUtil.replace((EStructuralFeature.Setting)setting, (Object)eobjectSource, (Object)eobjectTarget);
                                return CommandResult.newOKCommandResult();
                            }
                        };
                        updateCommand.append((Command)new GMFtoEMFCommandWrapper((ICommand)cmd));
                    }
                    continue;
                }
                if (!(eobjectSource instanceof Facet)) continue;
                adapter = ECrossReferenceAdapter.getCrossReferenceAdapter((Notifier)eobjectSource);
                for (final EStructuralFeature.Setting setting : adapter.getNonNavigableInverseReferences(eobjectSource)) {
                    eobject = setting.getEObject();
                    if (!(eobject instanceof TableInstance2) || !tableInstances.contains(eobject)) continue;
                    AbstractTransactionalCommand cmd = new AbstractTransactionalCommand(domain, null, null){

                        protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                            EcoreUtil.replace((EStructuralFeature.Setting)setting, (Object)eobjectSource, (Object)eobjectTarget);
                            return CommandResult.newOKCommandResult();
                        }
                    };
                    updateCommand.append((Command)new GMFtoEMFCommandWrapper((ICommand)cmd));
                }
            }
        }
        if (updateCommand.isEmpty()) {
            return null;
        }
        return updateCommand;
    }

    public static void copyXMI_ID(Map<EObject, EObject> map) {
        for (EObject sourceValue : map.keySet()) {
            EObject targetValue = map.get(sourceValue);
            Assert.isNotNull((Object)targetValue);
            XMIResource sourceRes = (XMIResource)sourceValue.eResource();
            XMIResource targetRes = (XMIResource)targetValue.eResource();
            assert (sourceRes != null);
            assert (targetRes != null);
            String XMI_ID = sourceRes.getID(sourceValue);
            targetRes.setID(targetValue, XMI_ID);
        }
    }

    public static class MergeFacetSetsCommand
    extends AbstractTransactionalCommand {
        private PapyrusTableInstance papyrusTableInstance;
        private XMIResource sourceResource;
        private XMIResource targetResource;

        public MergeFacetSetsCommand(TransactionalEditingDomain domain, PapyrusTableInstance papyrusTableInstance, XMIResource sourceResource, XMIResource targetResource) {
            super(domain, "Merge Facet Sets", null, Arrays.asList(WorkspaceSynchronizer.getFile((Resource)sourceResource), WorkspaceSynchronizer.getFile((Resource)targetResource)));
            this.papyrusTableInstance = papyrusTableInstance;
            this.sourceResource = sourceResource;
            this.targetResource = targetResource;
        }

        protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            HashSet facetsUsed = new HashSet(this.papyrusTableInstance.getTable().getFacets2());
            HashSet<FacetSet> facetsets = new HashSet<FacetSet>();
            HashMap<ModelQuerySet, ModelQuerySet> sourceVSTargetModelQuerySet = new HashMap<ModelQuerySet, ModelQuerySet>();
            HashMap<String, FacetSet> sourceMap = new HashMap<String, FacetSet>();
            HashMap<String, FacetSet> targetMap = new HashMap<String, FacetSet>();
            for (Facet facet : facetsUsed) {
                FacetSet facetset = ProfileFacetSetMoveHelper.getRootFacetSet(facet);
                if (facetset.eResource() != this.sourceResource) continue;
                facetsets.add(facetset);
            }
            if (!facetsets.isEmpty()) {
                String XMI_ID;
                for (FacetSet current : facetsets) {
                    XMI_ID = this.sourceResource.getID((EObject)current);
                    sourceMap.put(XMI_ID, current);
                }
                for (FacetSet current : facetsets) {
                    XMI_ID = this.targetResource.getID((EObject)current);
                    targetMap.put(XMI_ID, current);
                }
            } else {
                return CommandResult.newOKCommandResult();
            }
            EPackage additionalEPackageTarget = AdditionalContentsUtils.getAdditionalContentsEPackage((Resource)this.targetResource);
            if (additionalEPackageTarget == null) {
                additionalEPackageTarget = AdditionalContentsUtils.createAdditionalContentsEPackage();
                this.targetResource.getContents().add((Object)additionalEPackageTarget);
            }
            CompoundCommand compoundCommand = new CompoundCommand();
            for (String XMI_ID : sourceMap.keySet()) {
                FacetSet sourceFacetSet = (FacetSet)sourceMap.get(XMI_ID);
                FacetSet targetFacetSet = (FacetSet)targetMap.get(XMI_ID);
                if (targetFacetSet != null) continue;
                EcoreUtil.Copier copier = new EcoreUtil.Copier();
                FacetSet copy = (FacetSet)copier.copy((EObject)sourceFacetSet);
                ModelQuerySet modelQuerySet = ModelQuerySetUtil.getModelQuerySet((EObject)sourceFacetSet);
                if (!sourceVSTargetModelQuerySet.containsKey(modelQuerySet)) {
                    ModelQuerySet duplicatedQuerySet = (ModelQuerySet)copier.copy((EObject)modelQuerySet);
                    sourceVSTargetModelQuerySet.put(modelQuerySet, duplicatedQuerySet);
                    this.targetResource.getContents().add((Object)duplicatedQuerySet);
                }
                copier.copyReferences();
                targetMap.put(XMI_ID, copy);
                additionalEPackageTarget.getESubpackages().add((Object)copy);
                ProfileFacetSetMoveHelper.copyXMI_ID((Map<EObject, EObject>)copier);
                Command tmp = ProfileFacetSetMoveHelper.getUpdateFacetElementReferencesCommand(this.getEditingDomain(), Arrays.asList(this.papyrusTableInstance), (Map)copier);
                if (tmp == null) continue;
                compoundCommand.append(tmp);
            }
            if (compoundCommand.canExecute()) {
                compoundCommand.execute();
            }
            return CommandResult.newOKCommandResult();
        }
    }
}

