/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.properties.profile.ui.actions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.papyrus.uml.extensionpoints.profile.FilteredRegisteredProfilesAsLibrarySelectionDialog;
import org.eclipse.papyrus.uml.extensionpoints.profile.RegisteredProfile;
import org.eclipse.papyrus.uml.extensionpoints.utils.Util;
import org.eclipse.papyrus.uml.profile.ui.dialogs.ProfileTreeSelectionDialog;
import org.eclipse.papyrus.uml.properties.profile.ui.actions.AbstractPackageImportAction;
import org.eclipse.papyrus.uml.tools.utils.PackageUtil;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.uml2.common.edit.command.ChangeCommand;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageImport;
import org.eclipse.uml2.uml.UMLFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportProfileAction
extends AbstractPackageImportAction {
    @Override
    public ChangeCommand getCommand(EditingDomain domain) {
        if (this.command == null) {
            this.command = new ImportProfileCommand(domain);
        }
        this.getAvailableProfiles();
        return this.command;
    }

    protected Collection<RegisteredProfile> getImportedProfiles() {
        ArrayList<RegisteredProfile> profiles = new ArrayList<RegisteredProfile>();
        RegisteredProfile[] allLibraries = RegisteredProfile.getRegisteredProfiles();
        int i = 0;
        while (i < allLibraries.length) {
            RegisteredProfile registeredProfile = allLibraries[i];
            List importedPackageNames = PackageUtil.getImportedPackagesNames((Package)this.getSelectedElement());
            if (importedPackageNames.contains(registeredProfile.getName())) {
                profiles.add(registeredProfile);
            }
            ++i;
        }
        return profiles;
    }

    protected void importProfiles(RegisteredProfile[] profilesToImport) {
        ResourceSet resourceSet = Util.getResourceSet((EObject)this.selectedElement);
        int i = 0;
        while (i < profilesToImport.length) {
            RegisteredProfile currentLibrary = profilesToImport[i];
            URI modelUri = currentLibrary.uri;
            Resource modelResource = resourceSet.getResource(modelUri, true);
            ProfileTreeSelectionDialog dialog = new ProfileTreeSelectionDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (Package)modelResource.getContents().get(0));
            int ret = dialog.open();
            if (ret == 0) {
                ArrayList result = dialog.getResult();
                for (Element element : result) {
                    PackageImport ei = UMLFactory.eINSTANCE.createPackageImport();
                    ei.setImportedPackage((Package)element);
                    EList importedPackages = this.getSelectedElement().getImportedPackages();
                    if (importedPackages.contains(element)) continue;
                    this.getSelectedElement().getPackageImports().add((Object)ei);
                }
            }
            ++i;
        }
    }

    protected Object getAvailableProfiles() {
        ArrayList<RegisteredProfile> profiles = new ArrayList<RegisteredProfile>();
        RegisteredProfile[] allProfiles = RegisteredProfile.getRegisteredProfiles();
        int i = 0;
        while (i < allProfiles.length) {
            RegisteredProfile registeredProfile = allProfiles[i];
            List importedPackageNames = PackageUtil.getImportedPackagesNames((Package)this.getSelectedElement());
            if (!importedPackageNames.contains(registeredProfile.getName())) {
                profiles.add(registeredProfile);
            }
            ++i;
        }
        return profiles.toArray(new RegisteredProfile[profiles.size()]);
    }

    public class ImportProfileCommand
    extends ChangeCommand {
        public ImportProfileCommand(EditingDomain editingDomain) {
            super(editingDomain, new Runnable(){

                public void run() {
                    Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                    Object[] allProfiles = RegisteredProfile.getRegisteredProfiles();
                    FilteredRegisteredProfilesAsLibrarySelectionDialog dialog = new FilteredRegisteredProfilesAsLibrarySelectionDialog(shell, true, allProfiles, ImportProfileAction.this.getImportedProfiles());
                    dialog.open();
                    if (dialog.getReturnCode() == 0) {
                        List<Object> profilesToImport = Arrays.asList(dialog.getResult());
                        ImportProfileAction.this.importProfiles(profilesToImport.toArray(new RegisteredProfile[profilesToImport.size()]));
                    }
                }
            }, "Import Profile", "Import Profile from Registred Profiles");
        }

        public boolean canExecute() {
            return ImportProfileAction.this.getSelectedElement() != null;
        }
    }
}

