/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.properties.profile.ui.compositesformodel;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.papyrus.infra.core.utils.EditorUtils;
import org.eclipse.papyrus.uml.profile.Activator;
import org.eclipse.papyrus.uml.profile.ImageManager;
import org.eclipse.papyrus.uml.profile.ui.dialogs.ProfileTreeSelectionDialog;
import org.eclipse.papyrus.uml.properties.profile.ui.dialogs.FileSelectionFilter;
import org.eclipse.papyrus.uml.properties.profile.ui.dialogs.FileSelectionValidator;
import org.eclipse.papyrus.uml.properties.profile.ui.dialogs.Message;
import org.eclipse.papyrus.uml.properties.profile.ui.dialogs.RegisteredProfileSelectionDialog;
import org.eclipse.papyrus.uml.properties.profile.ui.panels.AppliedProfilePanel;
import org.eclipse.papyrus.uml.tools.utils.PackageUtil;
import org.eclipse.papyrus.uml.tools.utils.UMLUtil;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageImport;
import org.eclipse.uml2.uml.Profile;

public class AppliedProfileCompositeOnModel
extends Composite {
    public static final String TAG_PROFILE_CHANGED = " (has changed, consider re-applying profile)";
    private Button addButton;
    private Button removeButton;
    private Button addRegisteredButton;
    private MouseListener addButtonListener;
    private MouseListener removeButtonListener;
    private MouseListener addRegisteredButtonListener;
    private CLabel appliedLabel;
    private TransactionalEditingDomain domain;
    protected TabbedPropertySheetWidgetFactory factory;
    private org.eclipse.swt.widgets.List profiles;
    private SelectionListener profilesListener;
    public Profile profiletoApply;
    protected ISelection selectedElement;

    public AppliedProfileCompositeOnModel(AppliedProfilePanel parent) {
        super((Composite)parent, 0);
        this.setLayout((Layout)new FormLayout());
    }

    public AppliedProfileCompositeOnModel(Composite parent, TabbedPropertySheetWidgetFactory factory) {
        super(parent, 0);
        this.setLayout((Layout)new FormLayout());
        this.factory = factory;
    }

    protected void applyProfile(final Package thepackage, final Profile profile, final boolean withSubProfiles) {
        try {
            this.getDomain().runExclusive(new Runnable(){

                public void run() {
                    Display.getCurrent().asyncExec(new Runnable(){

                        public void run() {
                            AppliedProfileCompositeOnModel.this.getDomain().getCommandStack().execute((Command)new RecordingCommand(AppliedProfileCompositeOnModel.this.domain){

                                protected void doExecute() {
                                    PackageUtil.applyProfile((Package)thepackage, (Profile)profile, (boolean)withSubProfiles);
                                    AppliedProfileCompositeOnModel.this.refresh();
                                }
                            });
                        }
                    });
                }
            });
        }
        catch (Exception e) {
            Activator.logException((Exception)e, (String)"Unable to apply selected profile.");
        }
    }

    protected void applyProfileButtonPressed() {
        WorkbenchLabelProvider lp = new WorkbenchLabelProvider();
        WorkbenchContentProvider cp = new WorkbenchContentProvider();
        ArrayList<String> filetypes = new ArrayList<String>();
        filetypes.add("uml");
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)lp, (ITreeContentProvider)cp);
        dialog.setTitle("Apply Profiles...");
        dialog.setMessage("Choose profiles to apply");
        dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        dialog.addFilter((ViewerFilter)new FileSelectionFilter(filetypes));
        dialog.setValidator((ISelectionStatusValidator)new FileSelectionValidator());
        dialog.setDoubleClickSelects(true);
        dialog.setHelpAvailable(false);
        dialog.setAllowMultiple(true);
        if (dialog.open() != 0) {
            return;
        }
        if (dialog.getResult() == null || dialog.getResult().length < 1) {
            return;
        }
        ArrayList<Package> importedModels = new ArrayList<Package>();
        Package package_ = this.getSelectedPackage();
        int i = 0;
        while (i < dialog.getResult().length) {
            IFile selectedFile = (IFile)dialog.getResult()[i];
            URI profileUri = URI.createURI((String)("platform:/resource" + selectedFile.getFullPath().toString()));
            ResourceSet resourceSet = package_.eResource().getResourceSet();
            Resource profileResource = resourceSet.getResource(profileUri, true);
            if (profileResource.getContents().get(0) instanceof Package) {
                Package importedModel = (Package)profileResource.getContents().get(0);
                importedModels.add(importedModel);
            }
            ++i;
        }
        if (importedModels.size() > 0) {
            ProfileTreeSelectionDialog profileDialog = new ProfileTreeSelectionDialog(this.getShell(), importedModels);
            if (profileDialog.open() != 0) {
                return;
            }
            ArrayList profilestoApply = profileDialog.getResult();
            Message message = new Message("Profile application", "Applying profile...");
            message.open();
            Iterator iterator = profilestoApply.iterator();
            while (iterator.hasNext()) {
                this.applyProfile(package_, (Profile)iterator.next(), false);
            }
            message.close();
        }
    }

    private void createApplyProfileButton() {
        FormData data = new FormData();
        this.addButton = this.factory.createButton((Composite)this, "", 8);
        this.addButton.setImage(ImageManager.IMG_ADD);
        this.addButton.setToolTipText("Apply profile...");
        this.addButton.setVisible(true);
        data.right = new FormAttachment((Control)this.addRegisteredButton, -5);
        data.top = new FormAttachment(0, 4);
        this.addButton.setLayoutData((Object)data);
        this.addButtonListener = new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
                AppliedProfileCompositeOnModel.this.applyProfileButtonPressed();
            }
        };
        this.addButton.addMouseListener(this.addButtonListener);
    }

    public void createContent() {
        this.createLabel();
        this.createUnapplyProfileButton();
        this.createRegiteredProfileButton();
        this.createApplyProfileButton();
        this.profiles = this.createProfilesList();
        this.profiles.setVisible(true);
    }

    private void createLabel() {
        FormData data = new FormData();
        this.appliedLabel = this.factory.createCLabel((Composite)this, "Applied profiles:", 0);
        data.left = new FormAttachment(0, 5);
        data.top = new FormAttachment(0, 4);
        this.appliedLabel.setLayoutData((Object)data);
    }

    private org.eclipse.swt.widgets.List createProfilesList() {
        FormData data = new FormData();
        org.eclipse.swt.widgets.List profiles = new org.eclipse.swt.widgets.List((Composite)this, 2562);
        data.left = new FormAttachment(0, 5);
        data.right = new FormAttachment(100, -5);
        data.top = new FormAttachment((Control)this.addButton, 4);
        data.bottom = new FormAttachment(100, -4);
        profiles.setLayoutData((Object)data);
        this.profilesListener = new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
            }
        };
        profiles.addSelectionListener(this.profilesListener);
        return profiles;
    }

    private void createRegiteredProfileButton() {
        FormData data = new FormData();
        this.addRegisteredButton = this.factory.createButton((Composite)this, "", 8);
        this.addRegisteredButton.setImage(ImageManager.IMG_ADDREG);
        this.addRegisteredButton.setToolTipText("Apply registered profile...");
        this.addRegisteredButton.setVisible(true);
        data.right = new FormAttachment((Control)this.removeButton, -5);
        data.top = new FormAttachment(0, 4);
        this.addRegisteredButton.setLayoutData((Object)data);
        this.addRegisteredButtonListener = new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
                AppliedProfileCompositeOnModel.this.registeredProfileButtonPressed();
            }
        };
        this.addRegisteredButton.addMouseListener(this.addRegisteredButtonListener);
    }

    private void createUnapplyProfileButton() {
        FormData data = new FormData();
        this.removeButton = this.factory.createButton((Composite)this, "", 8);
        this.removeButton.setImage(ImageManager.IMG_DELETE);
        this.removeButton.setToolTipText("Unapply profiles...");
        this.removeButton.setVisible(true);
        data.right = new FormAttachment(100, -5);
        data.top = new FormAttachment(0, 4);
        this.removeButton.setLayoutData((Object)data);
        this.removeButtonListener = new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
                AppliedProfileCompositeOnModel.this.unapplyProfileButtonPressed();
            }
        };
        this.removeButton.addMouseListener(this.removeButtonListener);
    }

    public void disposeListeners() {
        if (this.addButton != null && !this.addButton.isDisposed()) {
            this.addButton.removeMouseListener(this.addButtonListener);
        }
        if (this.removeButton != null && !this.removeButton.isDisposed()) {
            this.removeButton.removeMouseListener(this.removeButtonListener);
        }
        if (this.addRegisteredButton != null && !this.addRegisteredButton.isDisposed()) {
            this.addRegisteredButton.removeMouseListener(this.addRegisteredButtonListener);
        }
        if (this.profiles != null && !this.profiles.isDisposed()) {
            this.profiles.removeSelectionListener(this.profilesListener);
        }
    }

    public TransactionalEditingDomain getDomain() {
        return EditorUtils.getTransactionalEditingDomain();
    }

    protected org.eclipse.swt.widgets.List getProfiles() {
        return this.profiles;
    }

    public Package getSelectedPackage() {
        Package selectedPackage = null;
        Object input = ((IStructuredSelection)this.selectedElement).getFirstElement();
        Element element = UMLUtil.resolveUMLElement((Object)input);
        if (element != null && element instanceof Package) {
            selectedPackage = (Package)element;
        }
        return selectedPackage;
    }

    private boolean isDirty(Package _package, Profile _profile) {
        URI prof_URI;
        boolean isDirty = false;
        ResourceSet pkge_resourceSet = _package.eResource().getResourceSet();
        Resource modelResource = pkge_resourceSet.getResource(prof_URI = _profile.eResource().getURI(), true);
        if (modelResource.getContents().get(0) instanceof Profile) {
            Profile profileInFile = (Profile)modelResource.getContents().get(0);
            if (_package.getProfileApplication(_profile) != null) {
                String fileProfileName;
                EPackage appliedProfileDefinition = _package.getProfileApplication(_profile).getAppliedDefinition();
                EPackage fileProfileDefinition = null;
                String appliedProfileName = _profile.getQualifiedName();
                if (!appliedProfileName.equals(fileProfileName = profileInFile.getQualifiedName())) {
                    for (Profile current : PackageUtil.getSubProfiles((Package)profileInFile)) {
                        fileProfileName = current.getQualifiedName();
                        if (!fileProfileName.equals(appliedProfileName)) continue;
                        profileInFile = current;
                    }
                }
                if (appliedProfileDefinition != (fileProfileDefinition = profileInFile.getDefinition())) {
                    isDirty = true;
                }
            }
        }
        return isDirty;
    }

    public void refresh() {
        Package currentPackage = this.getSelectedPackage();
        if (currentPackage != null && !this.profiles.isDisposed()) {
            this.profiles.removeAll();
            EList appliedProfiles = currentPackage.getAllAppliedProfiles();
            int i = 0;
            while (i < appliedProfiles.size()) {
                Profile currentProfile = (Profile)appliedProfiles.get(i);
                String currentName = currentProfile.getQualifiedName();
                if (currentName == null) {
                    Activator.getDefault().getLog().log((IStatus)new Status(2, "org.eclipse.papyrus.uml.profile", "Warning a profile applied on " + currentPackage.getName() + " could not be found : \n\t" + currentProfile.toString()));
                } else if (this.isDirty(currentPackage, currentProfile)) {
                    this.profiles.add(String.valueOf(currentName) + TAG_PROFILE_CHANGED);
                    this.profiles.setData(currentName, (Object)currentProfile);
                } else {
                    this.profiles.add(currentName);
                    this.profiles.setData(currentName, (Object)currentProfile);
                }
                ++i;
            }
        }
    }

    protected void registeredProfileButtonPressed() {
        RegisteredProfileSelectionDialog profileSelectionDialog = new RegisteredProfileSelectionDialog((Composite)this.getShell(), this.getSelectedPackage());
        List<Profile> profilestoApply = profileSelectionDialog.run();
        Iterator<Profile> iterator = profilestoApply.iterator();
        while (iterator.hasNext()) {
            if (this.getSelectedPackage() == null) continue;
            this.applyProfile(this.getSelectedPackage(), iterator.next(), false);
        }
    }

    public void setDomain(TransactionalEditingDomain domain) {
        this.domain = domain;
    }

    public void setSelection(ISelection selection) {
        this.selectedElement = selection;
    }

    protected void unApplyProfile(final Package thepackage, final Profile profile) {
        try {
            this.getDomain().runExclusive(new Runnable(){

                public void run() {
                    Display.getCurrent().asyncExec(new Runnable(){

                        public void run() {
                            AppliedProfileCompositeOnModel.this.getDomain().getCommandStack().execute((Command)new RecordingCommand(AppliedProfileCompositeOnModel.this.domain){

                                protected void doExecute() {
                                    thepackage.unapplyProfile(profile);
                                    AppliedProfileCompositeOnModel.this.refresh();
                                }
                            });
                        }
                    });
                }
            });
        }
        catch (Exception e) {
            Activator.logException((Exception)e);
        }
    }

    protected void unapplyProfileButtonPressed() {
        int[] selectionIndices = this.profiles.getSelectionIndices();
        if (selectionIndices == null || selectionIndices.length == 0) {
            return;
        }
        int i = 0;
        while (i < selectionIndices.length) {
            int currentIndex = selectionIndices[i];
            String itemName = this.profiles.getItem(currentIndex).replace(TAG_PROFILE_CHANGED, "");
            Profile profileToUnapply = (Profile)this.profiles.getData(itemName);
            if (profileToUnapply == null) {
                return;
            }
            EList appliedProfiles = this.getSelectedPackage().getAppliedProfiles();
            if (appliedProfiles.contains((Object)profileToUnapply)) {
                EList importedPackages = this.getSelectedPackage().getPackageImports();
                Iterator iterPI = importedPackages.iterator();
                ArrayList<PackageImport> importedPackagesToRemove = new ArrayList<PackageImport>();
                while (iterPI.hasNext()) {
                    PackageImport pi = (PackageImport)iterPI.next();
                    if (pi.getImportedPackage().getOwner() == null || !pi.getImportedPackage().getOwner().equals(profileToUnapply)) continue;
                    importedPackagesToRemove.add(pi);
                }
                int j = 0;
                while (j < importedPackagesToRemove.size()) {
                    importedPackages.remove(importedPackagesToRemove.get(j));
                    ++j;
                }
            }
            this.unApplyProfile(this.getSelectedPackage(), profileToUnapply);
            ++i;
        }
    }

    private EObject resolveSemanticObject(Object object) {
        IAdaptable adaptable;
        if (object instanceof EObject) {
            return (EObject)object;
        }
        if (object instanceof IAdaptable && (adaptable = (IAdaptable)object).getAdapter(EObject.class) != null) {
            return (EObject)adaptable.getAdapter(EObject.class);
        }
        return null;
    }
}

