/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.properties.profile.ui.dialogs;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.papyrus.uml.profile.ui.dialogs.AlphabeticalViewerSorter;
import org.eclipse.papyrus.uml.profile.ui.dialogs.ChooseSetAssistedDialog;
import org.eclipse.papyrus.uml.profile.ui.dialogs.IChooseDialog;
import org.eclipse.papyrus.uml.properties.profile.ui.dialogs.StereotypeLabelProvider;
import org.eclipse.papyrus.uml.properties.profile.ui.dialogs.StereotypeQualifiedLabelProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Stereotype;

public class ChooseSetStereotypeDialog
extends ChooseSetAssistedDialog
implements IChooseDialog {
    private final StereotypeQualifiedLabelProvider qualifiedLabelProvider = new StereotypeQualifiedLabelProvider();

    public ChooseSetStereotypeDialog(Shell parentShell, Element theElement) {
        super(parentShell, "Applicable Stereotypes: ", "Applied Stereotypes: ");
        this.labelProvider = new StereotypeLabelProvider();
        this.decoratedContentProposalProvider = new StereotypeContentProposalProvider();
        Iterator stereotypes = theElement.getAppliedStereotypes().iterator();
        while (stereotypes.hasNext()) {
            this.selectedElementList.addElement(stereotypes.next());
        }
        for (Stereotype current : theElement.getApplicableStereotypes()) {
            if (this.selectedElementList.contains((Object)current)) continue;
            this.possibleElementList.addElement((Object)current);
        }
    }

    protected Control createDialogArea(Composite parent) {
        Control composite = super.createDialogArea(parent);
        this.possibleElementsTable.setHeaderVisible(true);
        TableColumn column = new TableColumn(this.possibleElementsTable, 0x1000000, 0);
        column.setText("Stereotype");
        column.setWidth(150);
        column.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ChooseSetStereotypeDialog.this.possibleElementsTableViewer.setSorter((ViewerSorter)new AlphabeticalViewerSorter(0));
            }
        });
        column = new TableColumn(this.possibleElementsTable, 16384, 1);
        column.setText("Information");
        column.setWidth(165);
        column.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ChooseSetStereotypeDialog.this.possibleElementsTableViewer.setSorter((ViewerSorter)new AlphabeticalViewerSorter(1));
            }
        });
        this.possibleElementsTableViewer.setSorter((ViewerSorter)new AlphabeticalViewerSorter(0));
        return composite;
    }

    protected void runAddElement(String name) {
        Stereotype stereotype = null;
        for (Stereotype element : this.possibleElementList.getElements()) {
            if (!name.equalsIgnoreCase(element.getName()) && !name.equalsIgnoreCase(element.getQualifiedName())) continue;
            stereotype = element;
        }
        if (stereotype != null) {
            this.runActionAdd(stereotype);
        }
    }

    protected boolean isSelectableElement(String text) {
        for (Stereotype element : this.possibleElementList.getElements()) {
            if (!text.equalsIgnoreCase(element.getName()) && !text.equalsIgnoreCase(element.getQualifiedName())) continue;
            return true;
        }
        return false;
    }

    public class StereotypeContentProposalProvider
    extends ChooseSetAssistedDialog.DecoratedContentProposalProvider {
        public StereotypeContentProposalProvider() {
            super((ChooseSetAssistedDialog)ChooseSetStereotypeDialog.this);
        }

        public ChooseSetAssistedDialog.DecoratedContentProposal[] getProposals(String contents, int position) {
            ArrayList<ChooseSetAssistedDialog.DecoratedContentProposal> proposals = new ArrayList<ChooseSetAssistedDialog.DecoratedContentProposal>();
            if (ChooseSetStereotypeDialog.this.possibleElementList != null) {
                for (Stereotype stereotype : ChooseSetStereotypeDialog.this.possibleElementList.getElements()) {
                    String simpleName = stereotype.getName();
                    String qualifiedName = stereotype.getQualifiedName();
                    if (position < simpleName.length() && contents.substring(0, position).equalsIgnoreCase(simpleName.substring(0, position))) {
                        proposals.add(new ChooseSetAssistedDialog.DecoratedContentProposal((ChooseSetAssistedDialog)ChooseSetStereotypeDialog.this, (Object)stereotype, ChooseSetStereotypeDialog.this.labelProvider));
                    }
                    if (position >= qualifiedName.length() || !contents.substring(0, position).equalsIgnoreCase(qualifiedName.substring(0, position))) continue;
                    proposals.add(new ChooseSetAssistedDialog.DecoratedContentProposal((ChooseSetAssistedDialog)ChooseSetStereotypeDialog.this, (Object)stereotype, (LabelProvider)ChooseSetStereotypeDialog.this.qualifiedLabelProvider));
                }
            }
            Collections.sort(proposals);
            return proposals.toArray(new ChooseSetAssistedDialog.DecoratedContentProposal[proposals.size()]);
        }
    }
}

