/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.properties.widgets;

import java.io.File;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.papyrus.commands.wrappers.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.core.utils.EditorUtils;
import org.eclipse.papyrus.infra.widgets.editors.AbstractEditor;
import org.eclipse.papyrus.uml.properties.Activator;
import org.eclipse.papyrus.uml.properties.modelelement.UMLModelElement;
import org.eclipse.papyrus.uml.tools.utils.ImageUtil;
import org.eclipse.papyrus.views.properties.modelelement.ModelElement;
import org.eclipse.papyrus.views.properties.widgets.AbstractPropertyEditor;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Image;

public class StereotypeImageEditor
extends AbstractPropertyEditor
implements SelectionListener {
    private Button browseButton;
    private Button removeButton;
    private Composite composite;
    private String addImagePath = "/icons/Add_32x32.gif";
    public final String PAPYRUS_FORMAT = "Papyrus";

    public StereotypeImageEditor(Composite parent, int style) {
        TabbedPropertySheetWidgetFactory factory = AbstractEditor.factory;
        this.composite = factory.createFlatFormComposite(parent);
        this.browseButton = factory.createButton(this.composite, "", 8);
        this.browseButton.setImage(Activator.getDefault().getImage(this.addImagePath));
        this.removeButton = factory.createButton(this.composite, "", 8);
        this.removeButton.setImage(Activator.getDefault().getImage("/icons/delete.gif"));
        CLabel iconLabel = factory.createCLabel(this.composite, "Content: ");
        FormData data = new FormData();
        data.left = new FormAttachment(0, 85);
        data.top = new FormAttachment(0, 5);
        this.browseButton.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment((Control)this.browseButton, 5);
        data.top = new FormAttachment((Control)this.browseButton, 0, 0x1000000);
        this.removeButton.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.top = new FormAttachment((Control)this.browseButton, 0, 0x1000000);
        iconLabel.setLayoutData((Object)data);
        this.browseButton.addSelectionListener((SelectionListener)this);
        this.removeButton.addSelectionListener((SelectionListener)this);
    }

    protected Element getElement() {
        ModelElement element = this.input.getModelElement(this.propertyPath);
        if (element instanceof UMLModelElement) {
            return (Element)((UMLModelElement)element).getSource();
        }
        return null;
    }

    protected void doBinding() {
        super.doBinding();
        this.refresh();
    }

    protected void browseAction() {
        FileDialog fd = new FileDialog(this.composite.getShell());
        String[] extensions = new String[]{"*.jpg;*.bmp;*.ico;*.gif;*.png;*.wmf;*.emf"};
        fd.setFilterExtensions(extensions);
        String iconSelected = fd.open();
        if (iconSelected == null) {
            return;
        }
        if (this.getElement() instanceof Image) {
            final File imgFile = new File(iconSelected);
            TransactionalEditingDomain domain = EditorUtils.getTransactionalEditingDomain();
            AbstractTransactionalCommand operation = new AbstractTransactionalCommand(domain, "Set Image content", null){

                protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                    try {
                        ImageUtil.setContent((Image)((Image)StereotypeImageEditor.this.getElement()), (File)imgFile);
                        ((Image)StereotypeImageEditor.this.getElement()).setFormat("Papyrus");
                    }
                    catch (Exception ex) {
                        return CommandResult.newErrorCommandResult((Throwable)ex);
                    }
                    return CommandResult.newOKCommandResult();
                }
            };
            domain.getCommandStack().execute((Command)new GMFtoEMFCommandWrapper((ICommand)operation));
            this.refresh();
        }
    }

    protected void removeAction() {
        if (this.getElement() instanceof Image) {
            TransactionalEditingDomain dom = EditorUtils.getTransactionalEditingDomain();
            AbstractTransactionalCommand operation = new AbstractTransactionalCommand(dom, "Remove Image content", null){

                protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                    try {
                        ImageUtil.setContent((Image)((Image)StereotypeImageEditor.this.getElement()), null);
                    }
                    catch (Exception ex) {
                        return CommandResult.newErrorCommandResult((Throwable)ex);
                    }
                    return CommandResult.newOKCommandResult();
                }
            };
            dom.getCommandStack().execute((Command)new GMFtoEMFCommandWrapper((ICommand)operation));
            this.refresh();
        }
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget == this.browseButton) {
            this.browseAction();
        } else if (e.widget == this.removeButton) {
            this.removeAction();
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void refresh() {
        if (!this.browseButton.isDisposed()) {
            if (!(this.getElement() instanceof Image)) {
                return;
            }
            org.eclipse.swt.graphics.Image image = null;
            try {
                image = ImageUtil.getContent((Image)((Image)this.getElement()));
            }
            catch (Exception e) {
                Activator.log.error((Throwable)e);
            }
            if (image != null) {
                org.eclipse.swt.graphics.Image resizedIcon = new org.eclipse.swt.graphics.Image(image.getDevice(), image.getImageData().scaledTo(32, 32));
                this.browseButton.setImage(resizedIcon);
                this.removeButton.setEnabled(true);
            } else {
                this.browseButton.setImage(Activator.getDefault().getImage(this.addImagePath));
                this.removeButton.setEnabled(false);
            }
        }
    }
}

