/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.cdo.internal.ui.customization.properties.storage;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.emf.cdo.eresource.CDOTextResource;
import org.eclipse.emf.cdo.util.CDOURIUtil;
import org.eclipse.emf.cdo.util.CDOUtil;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.cdo.view.CDOViewSet;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIHandler;
import org.eclipse.emf.ecore.resource.impl.URIHandlerImpl;
import org.eclipse.papyrus.cdo.internal.ui.customization.properties.storage.ClobInputStream;
import org.eclipse.papyrus.cdo.internal.ui.customization.properties.storage.ClobOutputStream;

public class CDOTextURIHandler
extends URIHandlerImpl {
    public static final String SCHEME = "papyrus.cdo.text";
    private final ResourceSet resourceSet;

    protected CDOTextURIHandler(ResourceSet resourceSet) {
        this.resourceSet = resourceSet;
    }

    public static CDOTextURIHandler install(ResourceSet resourceSet) {
        CDOTextURIHandler result = new CDOTextURIHandler(resourceSet);
        resourceSet.getURIConverter().getURIHandlers().add(0, (Object)result);
        return result;
    }

    public static void uninstall(ResourceSet resourceSet) {
        Iterator iter = resourceSet.getURIConverter().getURIHandlers().iterator();
        while (iter.hasNext()) {
            if (!(iter.next() instanceof CDOTextURIHandler)) continue;
            iter.remove();
        }
    }

    public void uninstall() {
        this.resourceSet.getURIConverter().getURIHandlers().remove((Object)this);
    }

    public static URI createURI(URI uri) {
        return URI.createHierarchicalURI((String)SCHEME, (String)uri.authority(), (String)uri.device(), (String[])uri.segments(), (String)uri.query(), (String)uri.fragment());
    }

    public boolean canHandle(URI uri) {
        return SCHEME.equals(uri.scheme());
    }

    public static URI translate(URI uri) {
        return URI.createHierarchicalURI((String)"cdo", (String)uri.authority(), (String)uri.device(), (String[])uri.segments(), (String)uri.query(), (String)uri.fragment());
    }

    protected URIHandler getDelegateHandler(URI translatedURI) {
        return this.resourceSet.getURIConverter().getURIHandler(translatedURI);
    }

    public static CDOView getView(ResourceSet resourceSet, URI uri) {
        CDOView result = null;
        CDOViewSet viewSet = CDOUtil.getViewSet((Notifier)resourceSet);
        if (viewSet != null) {
            if (SCHEME.equals(uri.scheme())) {
                uri = CDOTextURIHandler.translate(uri);
            }
            result = viewSet.resolveView(CDOURIUtil.extractRepositoryUUID((URI)uri));
        }
        return result;
    }

    protected CDOView getView(URI uri) {
        return CDOTextURIHandler.getView(this.resourceSet, uri);
    }

    public InputStream createInputStream(URI uri, Map<?, ?> options) throws IOException {
        URI translated = CDOTextURIHandler.translate(uri);
        CDOView view = this.getView(translated);
        if (view == null) {
            return this.getDelegateHandler(translated).createInputStream(translated, options);
        }
        try {
            CDOTextResource text = view.getTextResource(URI.decode((String)CDOURIUtil.extractResourcePath((URI)translated)));
            return new ClobInputStream(text.getContents(), text.getEncoding());
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }

    public OutputStream createOutputStream(URI uri, Map<?, ?> options) throws IOException {
        URI translated = CDOTextURIHandler.translate(uri);
        CDOView view = this.getView(translated);
        if (view == null) {
            return this.getDelegateHandler(translated).createOutputStream(translated, options);
        }
        ClobOutputStream clobOutput = null;
        try {
            CDOTextResource text = view.getTextResource(CDOURIUtil.extractResourcePath((URI)translated));
            clobOutput = new ClobOutputStream(text);
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
        return clobOutput;
    }

    public void delete(URI uri, Map<?, ?> options) throws IOException {
        URI translated = CDOTextURIHandler.translate(uri);
        this.getDelegateHandler(translated).delete(translated, options);
    }

    public boolean exists(URI uri, Map<?, ?> options) {
        URI translated = CDOTextURIHandler.translate(uri);
        return this.getDelegateHandler(translated).exists(translated, options);
    }

    public Map<String, ?> getAttributes(URI uri, Map<?, ?> options) {
        URI translated = CDOTextURIHandler.translate(uri);
        return this.getDelegateHandler(translated).getAttributes(translated, options);
    }

    public void setAttributes(URI uri, Map<String, ?> attributes, Map<?, ?> options) throws IOException {
        URI translated = CDOTextURIHandler.translate(uri);
        this.getDelegateHandler(translated).setAttributes(translated, attributes, options);
    }
}

