/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.cdo.internal.ui.customization.properties.storage;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.eclipse.emf.cdo.common.lob.CDOClob;
import org.eclipse.emf.cdo.eresource.CDOTextResource;

public class ClobOutputStream
extends ByteArrayOutputStream {
    private final String encoding;
    private CDOTextResource resource;

    public ClobOutputStream(CDOTextResource resource) {
        this.resource = resource;
        this.encoding = resource.getEncoding() == null ? "UTF-8" : resource.getEncoding();
    }

    @Override
    public void close() throws IOException {
        super.close();
        if (this.resource != null) {
            this.resource.setContents(this.createClob());
            this.resource = null;
        }
    }

    protected CDOClob createClob() throws IOException {
        String text = new String(this.toByteArray(), this.encoding);
        return new CDOClob((Reader)new StringReader(text));
    }
}

