/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.cdo.internal.ui.customization.properties.storage.action;

import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.eresource.CDOResourceFolder;
import org.eclipse.emf.cdo.eresource.CDOResourceNode;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.util.CDOURIUtil;
import org.eclipse.emf.cdo.util.CDOUtil;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.papyrus.cdo.internal.ui.customization.properties.storage.CDOTextURIHandler;
import org.eclipse.papyrus.views.properties.contexts.Context;

public class AbstractCDOContextAction {
    protected CDOTransaction createTransaction(EObject object) {
        CDOView view = null;
        Resource resource = object.eResource();
        view = resource instanceof CDOResource ? ((CDOResource)resource).cdoView() : CDOTextURIHandler.getView(resource.getResourceSet(), resource.getURI());
        CDOTransaction result = null;
        if (view != null) {
            result = view.getSession().openTransaction();
            CDOTextURIHandler.install(result.getResourceSet());
        }
        return result;
    }

    protected <T extends EObject> T getDoppelganger(T original, CDOView view) {
        Resource resource = original.eResource();
        if (resource instanceof CDOResource) {
            CDOID oid = CDOUtil.getCDOObject(original).cdoID();
            return (T)CDOUtil.getEObject((EObject)view.getObject(oid));
        }
        return (T)view.getResourceSet().getEObject(EcoreUtil.getURI(original), true);
    }

    protected CDOResourceFolder getContextFolder(Context context) {
        CDOResourceFolder result = null;
        Resource resource = context.eResource();
        if (resource instanceof CDOResource) {
            result = ((CDOResource)resource).getFolder();
        } else {
            CDOResourceNode node;
            CDOView view = CDOTextURIHandler.getView(resource.getResourceSet(), resource.getURI());
            if (view != null && (node = view.getResourceNode(URI.decode((String)CDOURIUtil.extractResourcePath((URI)CDOTextURIHandler.translate(resource.getURI()))))) != null) {
                result = node.getFolder();
            }
        }
        return result;
    }
}

