/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.cdo.internal.ui.editors;

import com.google.common.base.Optional;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.explorer.checkouts.CDOCheckout;
import org.eclipse.emf.cdo.transaction.CDOConflictResolver;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.ui.CDOInvalidRootAgent;
import org.eclipse.emf.cdo.util.CDOUtil;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.spi.cdo.CDOMergingConflictResolver;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.ui.parts.GraphicalEditor;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.NotationFactory;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.net4j.util.ReflectUtil;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.lifecycle.ILifecycle;
import org.eclipse.net4j.util.lifecycle.LifecycleEventAdapter;
import org.eclipse.papyrus.cdo.core.IResourceSetDisposalApprover;
import org.eclipse.papyrus.cdo.internal.ui.Activator;
import org.eclipse.papyrus.cdo.internal.ui.editors.DawnEditorAdapter;
import org.eclipse.papyrus.cdo.internal.ui.editors.PapyrusCDOEditorInput;
import org.eclipse.papyrus.cdo.internal.ui.editors.PapyrusTransactionListener;
import org.eclipse.papyrus.cdo.internal.ui.l10n.Messages;
import org.eclipse.papyrus.cdo.internal.ui.util.UIUtil;
import org.eclipse.papyrus.infra.core.editor.CoreMultiDiagramEditor;
import org.eclipse.papyrus.infra.core.sasheditor.editor.IComponentPage;
import org.eclipse.papyrus.infra.core.sasheditor.editor.IEditorPage;
import org.eclipse.papyrus.infra.core.sasheditor.editor.IPage;
import org.eclipse.papyrus.infra.core.sasheditor.editor.IPageLifeCycleEventsListener;
import org.eclipse.papyrus.infra.core.sasheditor.editor.IPageVisitor;
import org.eclipse.papyrus.infra.core.sasheditor.editor.ISashWindowsContainer;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.core.utils.AdapterUtils;
import org.eclipse.papyrus.infra.core.utils.EditorUtils;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;

public class PapyrusCDOEditorManager {
    public static final PapyrusCDOEditorManager INSTANCE = new PapyrusCDOEditorManager();
    private final BiMap<IEditorPart, CDOView> editors = HashBiMap.create();
    private final Map<IEditorPart, Map<IEditorPart, CDOInvalidRootAgent>> invalidRootAgents = new HashMap<IEditorPart, Map<IEditorPart, CDOInvalidRootAgent>>();
    private final Cache<IWorkbenchPage, EditorListener> editorListeners = CacheBuilder.newBuilder().weakKeys().build((CacheLoader)new CacheLoader<IWorkbenchPage, EditorListener>(){

        public EditorListener load(IWorkbenchPage key) {
            EditorListener result = new EditorListener();
            key.addPartListener((IPartListener)result);
            return result;
        }
    });
    private IResourceSetDisposalApprover disposalApprover = new ResourceSetDisposalApprover();

    private PapyrusCDOEditorManager() {
    }

    public IEditorPart openEditor(IWorkbenchPage page, CDOResource diResource) throws PartInitException {
        return this.openEditor(page, diResource.getURI(), diResource.getURI().trimFileExtension().lastSegment());
    }

    public IEditorPart openEditor(IWorkbenchPage page, URI uri, String name) throws PartInitException {
        return this.openEditor(page, (IEditorInput)new PapyrusCDOEditorInput(uri, name));
    }

    public IEditorPart openEditor(IWorkbenchPage page, IEditorInput input) throws PartInitException {
        URI uri = EditorUtils.getResourceURI((IEditorInput)input);
        IEditorPart result = page.openEditor(input, "org.eclipse.papyrus.infra.core.papyrusEditor");
        EditingDomain domain = (EditingDomain)result.getAdapter(EditingDomain.class);
        ResourceSet resourceSet = domain.getResourceSet();
        CDOView view = CDOUtil.getView((Notifier)resourceSet);
        this.add(view, result);
        if (view instanceof CDOTransaction) {
            CDOTransaction transaction = (CDOTransaction)view;
            transaction.options().addConflictResolver((CDOConflictResolver)new CDOMergingConflictResolver());
            ServicesRegistry services = (ServicesRegistry)result.getAdapter(ServicesRegistry.class);
            view.addListener((IListener)new PapyrusTransactionListener(services, resourceSet));
        }
        return result;
    }

    void add(final CDOView view, final IEditorPart editor) {
        this.editors.put((Object)editor, (Object)view);
        if (view.isReadOnly() && editor instanceof CoreMultiDiagramEditor) {
            final CoreMultiDiagramEditor coreEditor = (CoreMultiDiagramEditor)editor;
            ISashWindowsContainer sashWindowsContainer = coreEditor.getISashWindowsContainer();
            for (IEditorPart editorPart : sashWindowsContainer.getVisibleIEditorParts()) {
                this.addInvalidRootAgent((IEditorPart)coreEditor, editorPart, view);
            }
            sashWindowsContainer.addPageLifeCycleListener(new IPageLifeCycleEventsListener(){

                public void pageOpened(IPage page) {
                    if (page instanceof IEditorPage) {
                        IEditorPage editorPage = (IEditorPage)page;
                        PapyrusCDOEditorManager.this.addInvalidRootAgent((IEditorPart)coreEditor, editorPage.getIEditorPart(), view);
                    }
                }

                public void pageClosed(IPage page) {
                    if (page instanceof IEditorPage) {
                        IEditorPage editorPage = (IEditorPage)page;
                        PapyrusCDOEditorManager.this.removeInvalidRootAgent((IEditorPart)coreEditor, editorPage.getIEditorPart());
                    }
                }

                public void pageChanged(IPage page) {
                }

                public void pageDeactivated(IPage page) {
                }

                public void pageActivated(IPage page) {
                }

                public void pageAboutToBeOpened(IPage page) {
                }

                public void pageAboutToBeClosed(IPage page) {
                }
            });
        }
        view.addListener((IListener)new CDOViewListener(editor));
        try {
            ((EditorListener)this.editorListeners.get((Object)editor.getSite().getPage(), (Callable)new Callable<EditorListener>(){

                @Override
                public EditorListener call() throws Exception {
                    EditorListener listener = new EditorListener();
                    editor.getSite().getPage().addPartListener((IPartListener)listener);
                    return listener;
                }
            })).addEditor(editor);
        }
        catch (Exception e) {
            Activator.log.error((Throwable)e);
        }
    }

    private void addInvalidRootAgent(IEditorPart coreEditor, IEditorPart editorPart, final CDOView view) {
        final GraphicalViewer graphicalViewer = this.getGraphicalViewer(editorPart);
        if (graphicalViewer != null) {
            CDOInvalidRootAgent invalidRootAgent = new CDOInvalidRootAgent(view){
                private Map<Object, Resource> temporaryResources;
                {
                    super($anonymous0);
                    this.temporaryResources = new HashMap<Object, Resource>();
                }

                protected Object createEmptyRoot(CDOObject invalidRoot) {
                    Diagram diagram = NotationFactory.eINSTANCE.createDiagram();
                    diagram.setName("Unavailable");
                    ResourceImpl resource = new ResourceImpl(URI.createURI((String)"dummy://huhu"));
                    resource.getContents().add((Object)diagram);
                    view.getResourceSet().getResources().add((Object)resource);
                    this.temporaryResources.put(diagram, (Resource)resource);
                    return diagram;
                }

                protected void setRootToUI(Object root) {
                    EditPart oldRoot = graphicalViewer.getContents();
                    Resource resource = this.temporaryResources.remove(oldRoot);
                    if (resource != null) {
                        view.getResourceSet().getResources().remove((Object)resource);
                    }
                    graphicalViewer.setContents(root);
                }

                protected Object getRootFromUI() {
                    return graphicalViewer.getContents().getModel();
                }
            };
            Map<IEditorPart, CDOInvalidRootAgent> map = this.invalidRootAgents.get(coreEditor);
            if (map == null) {
                map = new HashMap<IEditorPart, CDOInvalidRootAgent>();
                this.invalidRootAgents.put(coreEditor, map);
            }
            map.put(editorPart, invalidRootAgent);
        }
    }

    private void removeInvalidRootAgent(IEditorPart coreEditor, IEditorPart editorPart) {
        CDOInvalidRootAgent invalidRootAgent;
        Map<IEditorPart, CDOInvalidRootAgent> map = this.invalidRootAgents.get(coreEditor);
        if (map != null && (invalidRootAgent = map.remove(editorPart)) != null) {
            invalidRootAgent.dispose();
        }
    }

    private GraphicalViewer getGraphicalViewer(IEditorPart editorPart) {
        if (editorPart instanceof GraphicalEditor) {
            GraphicalEditor graphicalEditor = (GraphicalEditor)editorPart;
            Method method = ReflectUtil.getMethod(GraphicalEditor.class, (String)"getGraphicalViewer", (Class[])new Class[0]);
            return (GraphicalViewer)ReflectUtil.invokeMethod((Method)method, (Object)graphicalEditor, (Object[])new Object[0]);
        }
        return null;
    }

    private void closed(IEditorPart coreEditor) {
        CDOView view = (CDOView)this.editors.remove((Object)coreEditor);
        DawnEditorAdapter.removeAdapter(coreEditor);
        Map<IEditorPart, CDOInvalidRootAgent> map = this.invalidRootAgents.remove(coreEditor);
        if (map != null) {
            for (CDOInvalidRootAgent invalidRootAgent : map.values()) {
                invalidRootAgent.dispose();
            }
        }
    }

    private class CDOViewListener
    extends LifecycleEventAdapter {
        private final IEditorPart editor;

        CDOViewListener(IEditorPart editor) {
            this.editor = editor;
        }

        protected void onDeactivated(ILifecycle lifecycle) {
            UIUtil.later(new Runnable(){

                @Override
                public void run() {
                    if (PapyrusCDOEditorManager.this.editors.containsKey((Object)CDOViewListener.this.editor)) {
                        CDOViewListener.this.editor.getSite().getPage().closeEditor(CDOViewListener.this.editor, false);
                    }
                }
            });
            lifecycle.removeListener((IListener)this);
        }
    }

    private class EditorListener
    implements IPartListener,
    IPageLifeCycleEventsListener {
        private final Set<IEditorPart> editors = Sets.newHashSet();

        private EditorListener() {
        }

        void addEditor(IEditorPart editor) {
            this.editors.add(editor);
            Optional sashContainer = AdapterUtils.adapt((Object)editor, ISashWindowsContainer.class);
            if (sashContainer.isPresent()) {
                ((ISashWindowsContainer)sashContainer.get()).addPageLifeCycleListener((IPageLifeCycleEventsListener)this);
            }
        }

        public void partClosed(IWorkbenchPart part) {
            Optional sashContainer;
            if (this.editors.remove(part)) {
                IEditorPart editor = (IEditorPart)part;
                PapyrusCDOEditorManager.this.closed(editor);
            }
            if ((sashContainer = AdapterUtils.adapt((Object)part, ISashWindowsContainer.class)).isPresent()) {
                ((ISashWindowsContainer)sashContainer.get()).removePageLifeCycleListener((IPageLifeCycleEventsListener)this);
                ((ISashWindowsContainer)sashContainer.get()).visit(new IPageVisitor(){

                    public void accept(IEditorPage page) {
                        EditorListener.this.pageClosed((IPage)page);
                    }

                    public void accept(IComponentPage page) {
                    }
                });
            }
        }

        public void pageClosed(IPage page) {
            if (page instanceof IEditorPage) {
                PapyrusCDOEditorManager.this.closed(((IEditorPage)page).getIEditorPart());
            }
        }

        public void partActivated(IWorkbenchPart part) {
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partDeactivated(IWorkbenchPart part) {
        }

        public void partOpened(IWorkbenchPart part) {
        }

        public void pageChanged(IPage newPage) {
        }

        public void pageOpened(IPage page) {
        }

        public void pageActivated(IPage page) {
        }

        public void pageDeactivated(IPage page) {
        }

        public void pageAboutToBeOpened(IPage page) {
        }

        public void pageAboutToBeClosed(IPage page) {
        }
    }

    private class ResourceSetDisposalApprover
    implements IResourceSetDisposalApprover {
        private ResourceSetDisposalApprover() {
        }

        public IResourceSetDisposalApprover.DisposeAction disposalRequested(CDOCheckout checkout, Collection<ResourceSet> resourceSets) {
            IResourceSetDisposalApprover.DisposeAction result = IResourceSetDisposalApprover.DisposeAction.CLOSE;
            final ArrayList dirty = Lists.newArrayList();
            for (ResourceSet next : resourceSets) {
                CDOView view = CDOUtil.getView((Notifier)next);
                IEditorPart editor = (IEditorPart)PapyrusCDOEditorManager.this.editors.inverse().get((Object)view);
                if (editor == null || !editor.isDirty()) continue;
                dirty.add(editor);
            }
            if (!dirty.isEmpty()) {
                Future<Integer> dlgResult = UIUtil.call(new Callable<Integer>(){

                    @Override
                    public Integer call() {
                        MessageDialog dlg = new MessageDialog(((IEditorPart)dirty.get(0)).getSite().getShell(), Messages.PapyrusCDOEditorManager_1, null, Messages.PapyrusCDOEditorManager_2, 6, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL}, 2);
                        return dlg.open();
                    }
                });
                try {
                    switch (dlgResult.get()) {
                        case 0: {
                            result = IResourceSetDisposalApprover.DisposeAction.SAVE;
                            break;
                        }
                        case 1: {
                            result = IResourceSetDisposalApprover.DisposeAction.CLOSE;
                            break;
                        }
                        case 2: {
                            result = IResourceSetDisposalApprover.DisposeAction.NONE;
                            break;
                        }
                    }
                }
                catch (Exception e) {
                    Activator.log.error((Throwable)e);
                }
            }
            return result;
        }
    }
}

