/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.cpp.cdtproject;

import java.util.Collection;
import java.util.List;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.settings.model.CIncludePathEntry;
import org.eclipse.cdt.core.settings.model.CMacroEntry;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICFolderDescription;
import org.eclipse.cdt.core.settings.model.ICLanguageSetting;
import org.eclipse.cdt.core.settings.model.ICLanguageSettingEntry;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescriptionManager;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IHoldsOptions;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.papyrus.C_Cpp.ExternLibrary;
import org.eclipse.papyrus.codegen.base.ModelElementsCreator;
import org.eclipse.papyrus.codegen.extensionpoints.ILangSupport;
import org.eclipse.papyrus.cpp.cdtproject.CCNamedProjectWizard;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.util.UMLUtil;

public class C_CppLanguageSupport
implements ILangSupport {
    private static final String ROOT = "root";
    private static final String C = "c";
    private static final String CPP = "cpp";
    private int dialogStatus;
    static EList<String> includePaths;
    static EList<String> libs;
    static EList<String> libPaths;
    static EList<String> macros;
    ModelElementsCreator creator;
    static IProject m_project;

    public IProject createProject(String projectName, String targetOS) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = root.getProject(projectName);
        this.dialogStatus = 0;
        try {
            IWorkbench wb = PlatformUI.getWorkbench();
            final CCNamedProjectWizard wiz = new CCNamedProjectWizard(projectName);
            wiz.setWindowTitle("create project " + projectName);
            wiz.init(wb, null);
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    WizardDialog wizDiag = new WizardDialog(Display.getCurrent().getActiveShell(), (IWizard)wiz);
                    wizDiag.create();
                    C_CppLanguageSupport.this.dialogStatus = wizDiag.open();
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
            project = null;
        }
        if (this.dialogStatus == 1) {
            return null;
        }
        if (project == null || !project.exists()) {
            throw new RuntimeException("Could not create CDT project. This might indicate that there is a problem with your CDT installation.");
        }
        this.setProject(project);
        this.setSettings(targetOS);
        return project;
    }

    public void setProject(IProject project) {
        m_project = project;
    }

    public IProject getProject() {
        return m_project;
    }

    public void setSettings(String targetOS) {
        try {
            ICProjectDescriptionManager mngr = CoreModel.getDefault().getProjectDescriptionManager();
            ICProjectDescription cdesc = mngr.getProjectDescription(m_project, true);
            ICConfigurationDescription[] iCConfigurationDescriptionArray = cdesc.getConfigurations();
            int n = iCConfigurationDescriptionArray.length;
            int n2 = 0;
            while (n2 < n) {
                ICConfigurationDescription configDescr = iCConfigurationDescriptionArray[n2];
                ICFolderDescription folderDescription = configDescr.getRootFolderDescription();
                ICLanguageSetting[] languageSettings = folderDescription.getLanguageSettings();
                ICLanguageSettingEntry[] icIncludePaths = new ICLanguageSettingEntry[includePaths.size()];
                int i = 0;
                while (i < includePaths.size()) {
                    icIncludePaths[i] = new CIncludePathEntry((String)includePaths.get(i), 8);
                    ++i;
                }
                if (targetOS != null) {
                    macros.add((Object)("OS_" + targetOS));
                }
                BasicEList icMacros = new BasicEList();
                int i2 = 0;
                while (i2 < macros.size()) {
                    icMacros.add((Object)new CMacroEntry((String)macros.get(i2), "", 0));
                    ++i2;
                }
                ICLanguageSetting[] iCLanguageSettingArray = languageSettings;
                int n3 = languageSettings.length;
                int n4 = 0;
                while (n4 < n3) {
                    ICLanguageSetting lang = iCLanguageSettingArray[n4];
                    String[] stringArray = lang.getSourceExtensions();
                    int n5 = stringArray.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        String ext = stringArray[n6];
                        if (ext.equals(CPP) || ext.equals(C)) {
                            ICLanguageSettingEntry[] icOldMacros;
                            lang.setSettingEntries(1, icIncludePaths);
                            ICLanguageSettingEntry[] iCLanguageSettingEntryArray = icOldMacros = lang.getSettingEntries(4);
                            int n7 = icOldMacros.length;
                            int n8 = 0;
                            while (n8 < n7) {
                                ICLanguageSettingEntry entry = iCLanguageSettingEntryArray[n8];
                                icMacros.add((Object)entry);
                                ++n8;
                            }
                            lang.setSettingEntries(4, (List)icMacros);
                            break;
                        }
                        ++n6;
                    }
                    ++n4;
                }
                IConfiguration main = ManagedBuildManager.getConfigurationForDescription((ICConfigurationDescription)configDescr);
                ITool cfTool = main.calculateTargetTool();
                IOption[] iOptionArray = cfTool.getOptions();
                int n9 = iOptionArray.length;
                int n10 = 0;
                while (n10 < n9) {
                    IOption opt = iOptionArray[n10];
                    if (opt.getValueType() == 6) {
                        main.setOption((IHoldsOptions)cfTool, opt, (String[])libs.toArray((Object[])new String[0]));
                    } else if (opt.getValueType() == 9) {
                        main.setOption((IHoldsOptions)cfTool, opt, (String[])libPaths.toArray((Object[])new String[0]));
                    }
                    ++n10;
                }
                mngr.setProjectDescription(m_project, cdesc, true, null);
                ++n2;
            }
            ManagedBuildManager.saveBuildInfo((IProject)m_project, (boolean)true);
        }
        catch (BuildException be) {
            throw new RuntimeException(be.getMessage());
        }
        catch (CoreException ce) {
            throw new RuntimeException(ce.getMessage());
        }
    }

    public void generateCode(IProgressMonitor monitor, PackageableElement element) {
        this.creator.createPackageableElement(element, monitor);
    }

    public void cleanCode(IProgressMonitor monitor, PackageableElement element) {
        this.creator.removePackageableElement(element, monitor);
    }

    public void resetConfigurationData() {
        includePaths = new UniqueEList();
        includePaths.add((Object)".");
        includePaths.add((Object)ROOT);
        libs = new UniqueEList();
        libPaths = new UniqueEList();
        macros = new UniqueEList();
    }

    public void gatherConfigData(Class implementation) {
        Element owner = implementation.getOwner();
        while (owner instanceof Package) {
            ExternLibrary cppLibrary = (ExternLibrary)UMLUtil.getStereotypeApplication((Element)owner, ExternLibrary.class);
            if (cppLibrary != null) {
                includePaths.addAll((Collection)cppLibrary.getIncludes());
                for (String libPath : cppLibrary.getLibPaths()) {
                    if (libPath.startsWith("/")) {
                        libPaths.add((Object)("${workspace_loc:" + libPath + "}"));
                        continue;
                    }
                    libPaths.add((Object)libPath);
                }
                libs.addAll((Collection)cppLibrary.getLibs());
                macros.addAll((Collection)cppLibrary.getMacros());
            }
            owner = owner.getOwner();
        }
    }
}

