/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.dd.dc;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum KnownColor implements Enumerator
{
    MAROON(0, "maroon", "#800000"),
    RED(1, "red", "#FF0000"),
    ORANGE(2, "orange", "#FFA500"),
    YELLOW(3, "yellow", "#FFFF00"),
    OLIVE(4, "olive", "#808000"),
    PURPLE(5, "purple", "#800080"),
    FUCHSIA(6, "fuchsia", "#FF00FF"),
    WHITE(7, "white", "#FFFFFF"),
    LIME(8, "lime", "#00FF00"),
    GREEN(9, "green", "#008000"),
    NAVY(10, "navy", "#000080"),
    BLUE(11, "blue", "#0000FF"),
    AQUA(12, "aqua", "#00FFFF"),
    TEAL(13, "teal", "#008080"),
    BLACK(14, "black", "#000000"),
    SILVER(15, "silver", "#C0C0C0"),
    GRAY(16, "gray", "#808080");

    public static final int MAROON_VALUE = 0;
    public static final int RED_VALUE = 1;
    public static final int ORANGE_VALUE = 2;
    public static final int YELLOW_VALUE = 3;
    public static final int OLIVE_VALUE = 4;
    public static final int PURPLE_VALUE = 5;
    public static final int FUCHSIA_VALUE = 6;
    public static final int WHITE_VALUE = 7;
    public static final int LIME_VALUE = 8;
    public static final int GREEN_VALUE = 9;
    public static final int NAVY_VALUE = 10;
    public static final int BLUE_VALUE = 11;
    public static final int AQUA_VALUE = 12;
    public static final int TEAL_VALUE = 13;
    public static final int BLACK_VALUE = 14;
    public static final int SILVER_VALUE = 15;
    public static final int GRAY_VALUE = 16;
    private static final KnownColor[] VALUES_ARRAY;
    public static final List<KnownColor> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new KnownColor[]{MAROON, RED, ORANGE, YELLOW, OLIVE, PURPLE, FUCHSIA, WHITE, LIME, GREEN, NAVY, BLUE, AQUA, TEAL, BLACK, SILVER, GRAY};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static KnownColor get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            KnownColor result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static KnownColor getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            KnownColor result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static KnownColor get(int value) {
        switch (value) {
            case 0: {
                return MAROON;
            }
            case 1: {
                return RED;
            }
            case 2: {
                return ORANGE;
            }
            case 3: {
                return YELLOW;
            }
            case 4: {
                return OLIVE;
            }
            case 5: {
                return PURPLE;
            }
            case 6: {
                return FUCHSIA;
            }
            case 7: {
                return WHITE;
            }
            case 8: {
                return LIME;
            }
            case 9: {
                return GREEN;
            }
            case 10: {
                return NAVY;
            }
            case 11: {
                return BLUE;
            }
            case 12: {
                return AQUA;
            }
            case 13: {
                return TEAL;
            }
            case 14: {
                return BLACK;
            }
            case 15: {
                return SILVER;
            }
            case 16: {
                return GRAY;
            }
        }
        return null;
    }

    private KnownColor(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

