/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.dd.dg;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ElementKind implements Enumerator
{
    CANVAS(0, "canvas", "canvas"),
    CIRCLE(1, "circle", "circle"),
    CLIP_PATH(2, "clipPath", "clipPath"),
    ELLIPSE(3, "ellipse", "ellipse"),
    GROUP(4, "group", "group"),
    IMAGE(5, "image", "image"),
    LINE(6, "line", "line"),
    MARKER(7, "marker", "marker"),
    PATH(8, "path", "path"),
    POLYGON(9, "polygon", "polygon"),
    POLYLINE(10, "polyline", "polyline"),
    RECTANGLE(11, "rectangle", "rectangle"),
    TEXT(12, "text", "text"),
    USE(13, "use", "use");

    public static final int CANVAS_VALUE = 0;
    public static final int CIRCLE_VALUE = 1;
    public static final int CLIP_PATH_VALUE = 2;
    public static final int ELLIPSE_VALUE = 3;
    public static final int GROUP_VALUE = 4;
    public static final int IMAGE_VALUE = 5;
    public static final int LINE_VALUE = 6;
    public static final int MARKER_VALUE = 7;
    public static final int PATH_VALUE = 8;
    public static final int POLYGON_VALUE = 9;
    public static final int POLYLINE_VALUE = 10;
    public static final int RECTANGLE_VALUE = 11;
    public static final int TEXT_VALUE = 12;
    public static final int USE_VALUE = 13;
    private static final ElementKind[] VALUES_ARRAY;
    public static final List<ElementKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ElementKind[]{CANVAS, CIRCLE, CLIP_PATH, ELLIPSE, GROUP, IMAGE, LINE, MARKER, PATH, POLYGON, POLYLINE, RECTANGLE, TEXT, USE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ElementKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ElementKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ElementKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ElementKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ElementKind get(int value) {
        switch (value) {
            case 0: {
                return CANVAS;
            }
            case 1: {
                return CIRCLE;
            }
            case 2: {
                return CLIP_PATH;
            }
            case 3: {
                return ELLIPSE;
            }
            case 4: {
                return GROUP;
            }
            case 5: {
                return IMAGE;
            }
            case 6: {
                return LINE;
            }
            case 7: {
                return MARKER;
            }
            case 8: {
                return PATH;
            }
            case 9: {
                return POLYGON;
            }
            case 10: {
                return POLYLINE;
            }
            case 11: {
                return RECTANGLE;
            }
            case 12: {
                return TEXT;
            }
            case 13: {
                return USE;
            }
        }
        return null;
    }

    private ElementKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

