/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.dd.dg.util;

import java.util.Map;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.eclipse.papyrus.dd.dg.Canvas;
import org.eclipse.papyrus.dd.dg.Circle;
import org.eclipse.papyrus.dd.dg.ClipPath;
import org.eclipse.papyrus.dd.dg.ClosePath;
import org.eclipse.papyrus.dd.dg.CubicCurveTo;
import org.eclipse.papyrus.dd.dg.DGPackage;
import org.eclipse.papyrus.dd.dg.Definition;
import org.eclipse.papyrus.dd.dg.Definitions;
import org.eclipse.papyrus.dd.dg.ElementKind;
import org.eclipse.papyrus.dd.dg.Ellipse;
import org.eclipse.papyrus.dd.dg.EllipticalArcTo;
import org.eclipse.papyrus.dd.dg.FontDecoration;
import org.eclipse.papyrus.dd.dg.Gradient;
import org.eclipse.papyrus.dd.dg.GradientStop;
import org.eclipse.papyrus.dd.dg.GraphicalElement;
import org.eclipse.papyrus.dd.dg.Group;
import org.eclipse.papyrus.dd.dg.Image;
import org.eclipse.papyrus.dd.dg.Line;
import org.eclipse.papyrus.dd.dg.LineTo;
import org.eclipse.papyrus.dd.dg.LinearGradient;
import org.eclipse.papyrus.dd.dg.MarkedElement;
import org.eclipse.papyrus.dd.dg.Marker;
import org.eclipse.papyrus.dd.dg.Matrix;
import org.eclipse.papyrus.dd.dg.MoveTo;
import org.eclipse.papyrus.dd.dg.Paint;
import org.eclipse.papyrus.dd.dg.PaintServer;
import org.eclipse.papyrus.dd.dg.Path;
import org.eclipse.papyrus.dd.dg.PathCommand;
import org.eclipse.papyrus.dd.dg.Pattern;
import org.eclipse.papyrus.dd.dg.Polygon;
import org.eclipse.papyrus.dd.dg.Polyline;
import org.eclipse.papyrus.dd.dg.QuadraticCurveTo;
import org.eclipse.papyrus.dd.dg.RadialGradient;
import org.eclipse.papyrus.dd.dg.Rectangle;
import org.eclipse.papyrus.dd.dg.RootCanvas;
import org.eclipse.papyrus.dd.dg.Rotate;
import org.eclipse.papyrus.dd.dg.Scale;
import org.eclipse.papyrus.dd.dg.Skew;
import org.eclipse.papyrus.dd.dg.Style;
import org.eclipse.papyrus.dd.dg.StyleRule;
import org.eclipse.papyrus.dd.dg.StyleSelector;
import org.eclipse.papyrus.dd.dg.StyleSheet;
import org.eclipse.papyrus.dd.dg.Text;
import org.eclipse.papyrus.dd.dg.TextAnchor;
import org.eclipse.papyrus.dd.dg.Transform;
import org.eclipse.papyrus.dd.dg.Translate;
import org.eclipse.papyrus.dd.dg.Use;

public class DGValidator
extends EObjectValidator {
    public static final DGValidator INSTANCE = new DGValidator();
    public static final String DIAGNOSTIC_SOURCE = "org.eclipse.papyrus.dd.dg";
    public static final int CANVAS__CANVAS_CANNOT_HAVE_TRANSFORMS = 1;
    public static final int GRAPHICAL_ELEMENT__REFERENCED_CLIPPATH_HAS_ID = 2;
    public static final int DEFINITION__ID_CANNOT_BE_EMPTY = 3;
    public static final int STYLE__VALID_FONT_SIZE = 4;
    public static final int STYLE__VALID_FILL_OPACITY = 5;
    public static final int STYLE__VALID_STROKE_WIDTH = 6;
    public static final int STYLE__VALID_DASH_LENGTH_SIZE = 7;
    public static final int STYLE__VALID_STROKE_OPACITY = 8;
    public static final int PAINT__REFERENCED_PAINT_SERVER_HAS_ID = 9;
    public static final int CIRCLE__NON_NEGATIVE_RADIUS = 10;
    public static final int GRADIENT_STOP__VALID_OFFSET = 11;
    public static final int GRADIENT_STOP__VALID_OPACITY = 12;
    public static final int IMAGE__SOURCE_CANNOT_BE_EMPTY = 13;
    public static final int MARKED_ELEMENT__REFERENCED_START_MARKER_HAS_ID = 14;
    public static final int MARKED_ELEMENT__REFERENCED_MID_MARKER_HAS_ID = 15;
    public static final int MARKED_ELEMENT__REFERENCED_END_MARKER_HAS_ID = 16;
    public static final int LINEAR_GRADIENT__VALID_GRADIENT_VECTOR = 17;
    public static final int PATH__FIRST_COMMAND_MUST_BE_MOVE = 18;
    public static final int RADIAL_GRADIENT__VALID_CENTER_POINT = 19;
    public static final int RADIAL_GRADIENT__VALID_FOCUS_POINT = 20;
    public static final int RADIAL_GRADIENT__VALID_RADIUS = 21;
    public static final int RECTANGLE__NON_NEGATIVE_CORNER_RADIUS = 22;
    public static final int SCALE__NONNEGATIVESCALE = 23;
    public static final int TEXT__DATA_CANNOT_BE_EMPTY = 24;
    public static final int USE__REFERENCED_ELEMENT_HAS_ID = 25;
    private static final int GENERATED_DIAGNOSTIC_CODE_COUNT = 25;
    protected static final int DIAGNOSTIC_CODE_COUNT = 25;

    public static boolean validate(EClass eClass, EObject eObject, DiagnosticChain diagnostics, Map<Object, Object> context, String validationDelegate, EOperation invariant, String expression, int severity, String source, int code) {
        return EObjectValidator.validate((EClass)eClass, (EObject)eObject, (DiagnosticChain)diagnostics, context, (String)validationDelegate, (EOperation)invariant, (String)expression, (int)severity, (String)source, (int)code);
    }

    protected EPackage getEPackage() {
        return DGPackage.eINSTANCE;
    }

    protected boolean validate(int classifierID, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
        switch (classifierID) {
            case 0: {
                return this.validateCanvas((Canvas)value, diagnostics, context);
            }
            case 1: {
                return this.validateGroup((Group)value, diagnostics, context);
            }
            case 2: {
                return this.validateGraphicalElement((GraphicalElement)value, diagnostics, context);
            }
            case 3: {
                return this.validateDefinition((Definition)value, diagnostics, context);
            }
            case 4: {
                return this.validateMoveTo((MoveTo)value, diagnostics, context);
            }
            case 5: {
                return this.validatePathCommand((PathCommand)value, diagnostics, context);
            }
            case 6: {
                return this.validateClipPath((ClipPath)value, diagnostics, context);
            }
            case 7: {
                return this.validateStyle((Style)value, diagnostics, context);
            }
            case 8: {
                return this.validatePaint((Paint)value, diagnostics, context);
            }
            case 9: {
                return this.validatePaintServer((PaintServer)value, diagnostics, context);
            }
            case 10: {
                return this.validateTransform((Transform)value, diagnostics, context);
            }
            case 11: {
                return this.validateCircle((Circle)value, diagnostics, context);
            }
            case 12: {
                return this.validateClosePath((ClosePath)value, diagnostics, context);
            }
            case 13: {
                return this.validateCubicCurveTo((CubicCurveTo)value, diagnostics, context);
            }
            case 14: {
                return this.validateDefinitions((Definitions)value, diagnostics, context);
            }
            case 15: {
                return this.validateStyleSheet((StyleSheet)value, diagnostics, context);
            }
            case 16: {
                return this.validateStyleRule((StyleRule)value, diagnostics, context);
            }
            case 17: {
                return this.validateStyleSelector((StyleSelector)value, diagnostics, context);
            }
            case 18: {
                return this.validateEllipse((Ellipse)value, diagnostics, context);
            }
            case 19: {
                return this.validateEllipticalArcTo((EllipticalArcTo)value, diagnostics, context);
            }
            case 20: {
                return this.validateQuadraticCurveTo((QuadraticCurveTo)value, diagnostics, context);
            }
            case 21: {
                return this.validateGradient((Gradient)value, diagnostics, context);
            }
            case 22: {
                return this.validateGradientStop((GradientStop)value, diagnostics, context);
            }
            case 23: {
                return this.validateImage((Image)value, diagnostics, context);
            }
            case 24: {
                return this.validateLine((Line)value, diagnostics, context);
            }
            case 25: {
                return this.validateMarkedElement((MarkedElement)value, diagnostics, context);
            }
            case 26: {
                return this.validateMarker((Marker)value, diagnostics, context);
            }
            case 27: {
                return this.validateLinearGradient((LinearGradient)value, diagnostics, context);
            }
            case 28: {
                return this.validateLineTo((LineTo)value, diagnostics, context);
            }
            case 29: {
                return this.validateMatrix((Matrix)value, diagnostics, context);
            }
            case 30: {
                return this.validatePath((Path)value, diagnostics, context);
            }
            case 31: {
                return this.validatePattern((Pattern)value, diagnostics, context);
            }
            case 32: {
                return this.validatePolygon((Polygon)value, diagnostics, context);
            }
            case 33: {
                return this.validatePolyline((Polyline)value, diagnostics, context);
            }
            case 34: {
                return this.validateRadialGradient((RadialGradient)value, diagnostics, context);
            }
            case 35: {
                return this.validateRectangle((Rectangle)value, diagnostics, context);
            }
            case 36: {
                return this.validateRootCanvas((RootCanvas)value, diagnostics, context);
            }
            case 37: {
                return this.validateRotate((Rotate)value, diagnostics, context);
            }
            case 38: {
                return this.validateScale((Scale)value, diagnostics, context);
            }
            case 39: {
                return this.validateSkew((Skew)value, diagnostics, context);
            }
            case 40: {
                return this.validateText((Text)value, diagnostics, context);
            }
            case 41: {
                return this.validateTranslate((Translate)value, diagnostics, context);
            }
            case 42: {
                return this.validateUse((Use)value, diagnostics, context);
            }
            case 43: {
                return this.validateFontDecoration((FontDecoration)((Object)value), diagnostics, context);
            }
            case 44: {
                return this.validateElementKind((ElementKind)((Object)value), diagnostics, context);
            }
            case 45: {
                return this.validateTextAnchor((TextAnchor)((Object)value), diagnostics, context);
            }
        }
        return true;
    }

    public boolean validateCanvas(Canvas canvas, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(canvas, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(canvas, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(canvas, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(canvas, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(canvas, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(canvas, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(canvas, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(canvas, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(canvas, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateDefinition_idCannotBeEmpty(canvas, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateGraphicalElement_referencedClippathHasId(canvas, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateCanvas_canvasCannotHaveTransforms(canvas, diagnostics, context);
        }
        return result;
    }

    public boolean validateCanvas_canvasCannotHaveTransforms(Canvas canvas, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return canvas.canvasCannotHaveTransforms(diagnostics, context);
    }

    public boolean validateGroup(Group group, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(group, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(group, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(group, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(group, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(group, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(group, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(group, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(group, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(group, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateDefinition_idCannotBeEmpty(group, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateGraphicalElement_referencedClippathHasId(group, diagnostics, context);
        }
        return result;
    }

    public boolean validateGraphicalElement(GraphicalElement graphicalElement, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(graphicalElement, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(graphicalElement, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(graphicalElement, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(graphicalElement, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(graphicalElement, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(graphicalElement, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(graphicalElement, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(graphicalElement, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(graphicalElement, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateDefinition_idCannotBeEmpty(graphicalElement, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateGraphicalElement_referencedClippathHasId(graphicalElement, diagnostics, context);
        }
        return result;
    }

    public boolean validateGraphicalElement_referencedClippathHasId(GraphicalElement graphicalElement, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return graphicalElement.referencedClippathHasId(diagnostics, context);
    }

    public boolean validateDefinition(Definition definition, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(definition, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(definition, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(definition, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(definition, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(definition, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(definition, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(definition, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(definition, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(definition, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateDefinition_idCannotBeEmpty(definition, diagnostics, context);
        }
        return result;
    }

    public boolean validateDefinition_idCannotBeEmpty(Definition definition, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return definition.idCannotBeEmpty(diagnostics, context);
    }

    public boolean validateClipPath(ClipPath clipPath, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(clipPath, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(clipPath, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(clipPath, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(clipPath, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(clipPath, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(clipPath, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(clipPath, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(clipPath, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(clipPath, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateDefinition_idCannotBeEmpty(clipPath, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateGraphicalElement_referencedClippathHasId(clipPath, diagnostics, context);
        }
        return result;
    }

    public boolean validateStyle(Style style, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(style, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(style, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(style, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(style, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(style, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(style, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(style, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(style, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(style, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateStyle_validFontSize(style, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateStyle_validFillOpacity(style, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateStyle_validStrokeWidth(style, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateStyle_validDashLengthSize(style, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateStyle_validStrokeOpacity(style, diagnostics, context);
        }
        return result;
    }

    public boolean validateStyle_validFontSize(Style style, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return style.validFontSize(diagnostics, context);
    }

    public boolean validateStyle_validFillOpacity(Style style, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return style.validFillOpacity(diagnostics, context);
    }

    public boolean validateStyle_validStrokeWidth(Style style, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return style.validStrokeWidth(diagnostics, context);
    }

    public boolean validateStyle_validDashLengthSize(Style style, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return style.validDashLengthSize(diagnostics, context);
    }

    public boolean validateStyle_validStrokeOpacity(Style style, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return style.validStrokeOpacity(diagnostics, context);
    }

    public boolean validatePaint(Paint paint, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(paint, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(paint, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(paint, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(paint, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(paint, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(paint, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(paint, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(paint, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(paint, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validatePaint_referencedPaintServerHasId(paint, diagnostics, context);
        }
        return result;
    }

    public boolean validatePaint_referencedPaintServerHasId(Paint paint, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return paint.referencedPaintServerHasId(diagnostics, context);
    }

    public boolean validatePaintServer(PaintServer paintServer, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(paintServer, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(paintServer, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(paintServer, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(paintServer, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(paintServer, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(paintServer, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(paintServer, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(paintServer, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(paintServer, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateDefinition_idCannotBeEmpty(paintServer, diagnostics, context);
        }
        return result;
    }

    public boolean validateTransform(Transform transform, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(transform, diagnostics, context);
    }

    public boolean validateDefinitions(Definitions definitions, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(definitions, diagnostics, context);
    }

    public boolean validateCubicCurveTo(CubicCurveTo cubicCurveTo, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(cubicCurveTo, diagnostics, context);
    }

    public boolean validatePathCommand(PathCommand pathCommand, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(pathCommand, diagnostics, context);
    }

    public boolean validateMarker(Marker marker, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(marker, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(marker, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(marker, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(marker, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(marker, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(marker, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(marker, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(marker, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(marker, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateDefinition_idCannotBeEmpty(marker, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateGraphicalElement_referencedClippathHasId(marker, diagnostics, context);
        }
        return result;
    }

    public boolean validateStyleSheet(StyleSheet styleSheet, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(styleSheet, diagnostics, context);
    }

    public boolean validateStyleRule(StyleRule styleRule, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(styleRule, diagnostics, context);
    }

    public boolean validateStyleSelector(StyleSelector styleSelector, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(styleSelector, diagnostics, context);
    }

    public boolean validateCircle(Circle circle, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(circle, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(circle, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(circle, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(circle, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(circle, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(circle, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(circle, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(circle, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(circle, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateDefinition_idCannotBeEmpty(circle, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateGraphicalElement_referencedClippathHasId(circle, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateCircle_nonNegativeRadius(circle, diagnostics, context);
        }
        return result;
    }

    public boolean validateCircle_nonNegativeRadius(Circle circle, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return circle.nonNegativeRadius(diagnostics, context);
    }

    public boolean validateClosePath(ClosePath closePath, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(closePath, diagnostics, context);
    }

    public boolean validateEllipse(Ellipse ellipse, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(ellipse, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(ellipse, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(ellipse, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(ellipse, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(ellipse, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(ellipse, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(ellipse, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(ellipse, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(ellipse, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateDefinition_idCannotBeEmpty(ellipse, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateGraphicalElement_referencedClippathHasId(ellipse, diagnostics, context);
        }
        return result;
    }

    public boolean validateEllipticalArcTo(EllipticalArcTo ellipticalArcTo, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(ellipticalArcTo, diagnostics, context);
    }

    public boolean validateQuadraticCurveTo(QuadraticCurveTo quadraticCurveTo, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(quadraticCurveTo, diagnostics, context);
    }

    public boolean validateGradient(Gradient gradient, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(gradient, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(gradient, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(gradient, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(gradient, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(gradient, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(gradient, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(gradient, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(gradient, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(gradient, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateDefinition_idCannotBeEmpty(gradient, diagnostics, context);
        }
        return result;
    }

    public boolean validateGradientStop(GradientStop gradientStop, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(gradientStop, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(gradientStop, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(gradientStop, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(gradientStop, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(gradientStop, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(gradientStop, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(gradientStop, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(gradientStop, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(gradientStop, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateGradientStop_validOffset(gradientStop, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateGradientStop_validOpacity(gradientStop, diagnostics, context);
        }
        return result;
    }

    public boolean validateGradientStop_validOffset(GradientStop gradientStop, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return gradientStop.validOffset(diagnostics, context);
    }

    public boolean validateGradientStop_validOpacity(GradientStop gradientStop, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return gradientStop.validOpacity(diagnostics, context);
    }

    public boolean validateImage(Image image, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(image, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(image, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(image, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(image, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(image, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(image, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(image, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(image, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(image, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateDefinition_idCannotBeEmpty(image, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateGraphicalElement_referencedClippathHasId(image, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateImage_sourceCannotBeEmpty(image, diagnostics, context);
        }
        return result;
    }

    public boolean validateImage_sourceCannotBeEmpty(Image image, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return image.sourceCannotBeEmpty(diagnostics, context);
    }

    public boolean validateLine(Line line, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(line, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(line, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(line, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(line, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(line, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(line, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(line, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(line, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(line, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateDefinition_idCannotBeEmpty(line, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateGraphicalElement_referencedClippathHasId(line, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateMarkedElement_referencedStartMarkerHasId(line, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateMarkedElement_referencedMidMarkerHasId(line, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateMarkedElement_referencedEndMarkerHasId(line, diagnostics, context);
        }
        return result;
    }

    public boolean validateMarkedElement(MarkedElement markedElement, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(markedElement, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(markedElement, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(markedElement, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(markedElement, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(markedElement, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(markedElement, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(markedElement, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(markedElement, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(markedElement, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateDefinition_idCannotBeEmpty(markedElement, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateGraphicalElement_referencedClippathHasId(markedElement, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateMarkedElement_referencedStartMarkerHasId(markedElement, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateMarkedElement_referencedMidMarkerHasId(markedElement, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateMarkedElement_referencedEndMarkerHasId(markedElement, diagnostics, context);
        }
        return result;
    }

    public boolean validateMarkedElement_referencedStartMarkerHasId(MarkedElement markedElement, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return markedElement.referencedStartMarkerHasId(diagnostics, context);
    }

    public boolean validateMarkedElement_referencedMidMarkerHasId(MarkedElement markedElement, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return markedElement.referencedMidMarkerHasId(diagnostics, context);
    }

    public boolean validateMarkedElement_referencedEndMarkerHasId(MarkedElement markedElement, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return markedElement.referencedEndMarkerHasId(diagnostics, context);
    }

    public boolean validateLinearGradient(LinearGradient linearGradient, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(linearGradient, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(linearGradient, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(linearGradient, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(linearGradient, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(linearGradient, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(linearGradient, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(linearGradient, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(linearGradient, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(linearGradient, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateDefinition_idCannotBeEmpty(linearGradient, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateLinearGradient_validGradientVector(linearGradient, diagnostics, context);
        }
        return result;
    }

    public boolean validateLinearGradient_validGradientVector(LinearGradient linearGradient, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return linearGradient.validGradientVector(diagnostics, context);
    }

    public boolean validateLineTo(LineTo lineTo, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(lineTo, diagnostics, context);
    }

    public boolean validateMatrix(Matrix matrix, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(matrix, diagnostics, context);
    }

    public boolean validateMoveTo(MoveTo moveTo, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(moveTo, diagnostics, context);
    }

    public boolean validatePath(Path path, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(path, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(path, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(path, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(path, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(path, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(path, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(path, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(path, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(path, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateDefinition_idCannotBeEmpty(path, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateGraphicalElement_referencedClippathHasId(path, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateMarkedElement_referencedStartMarkerHasId(path, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateMarkedElement_referencedMidMarkerHasId(path, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateMarkedElement_referencedEndMarkerHasId(path, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validatePath_firstCommandMustBeMove(path, diagnostics, context);
        }
        return result;
    }

    public boolean validatePath_firstCommandMustBeMove(Path path, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return path.firstCommandMustBeMove(diagnostics, context);
    }

    public boolean validatePattern(Pattern pattern, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(pattern, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(pattern, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(pattern, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(pattern, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(pattern, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(pattern, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(pattern, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(pattern, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(pattern, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateDefinition_idCannotBeEmpty(pattern, diagnostics, context);
        }
        return result;
    }

    public boolean validatePolygon(Polygon polygon, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(polygon, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(polygon, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(polygon, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(polygon, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(polygon, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(polygon, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(polygon, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(polygon, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(polygon, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateDefinition_idCannotBeEmpty(polygon, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateGraphicalElement_referencedClippathHasId(polygon, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateMarkedElement_referencedStartMarkerHasId(polygon, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateMarkedElement_referencedMidMarkerHasId(polygon, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateMarkedElement_referencedEndMarkerHasId(polygon, diagnostics, context);
        }
        return result;
    }

    public boolean validatePolyline(Polyline polyline, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(polyline, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(polyline, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(polyline, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(polyline, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(polyline, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(polyline, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(polyline, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(polyline, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(polyline, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateDefinition_idCannotBeEmpty(polyline, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateGraphicalElement_referencedClippathHasId(polyline, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateMarkedElement_referencedStartMarkerHasId(polyline, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateMarkedElement_referencedMidMarkerHasId(polyline, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateMarkedElement_referencedEndMarkerHasId(polyline, diagnostics, context);
        }
        return result;
    }

    public boolean validateRadialGradient(RadialGradient radialGradient, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(radialGradient, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(radialGradient, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(radialGradient, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(radialGradient, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(radialGradient, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(radialGradient, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(radialGradient, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(radialGradient, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(radialGradient, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateDefinition_idCannotBeEmpty(radialGradient, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateRadialGradient_validCenterPoint(radialGradient, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateRadialGradient_validFocusPoint(radialGradient, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateRadialGradient_validRadius(radialGradient, diagnostics, context);
        }
        return result;
    }

    public boolean validateRadialGradient_validCenterPoint(RadialGradient radialGradient, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return radialGradient.validCenterPoint(diagnostics, context);
    }

    public boolean validateRadialGradient_validFocusPoint(RadialGradient radialGradient, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return radialGradient.validFocusPoint(diagnostics, context);
    }

    public boolean validateRadialGradient_validRadius(RadialGradient radialGradient, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return radialGradient.validRadius(diagnostics, context);
    }

    public boolean validateRectangle(Rectangle rectangle, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(rectangle, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(rectangle, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(rectangle, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(rectangle, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(rectangle, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(rectangle, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(rectangle, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(rectangle, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(rectangle, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateDefinition_idCannotBeEmpty(rectangle, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateGraphicalElement_referencedClippathHasId(rectangle, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateRectangle_nonNegativeCornerRadius(rectangle, diagnostics, context);
        }
        return result;
    }

    public boolean validateRectangle_nonNegativeCornerRadius(Rectangle rectangle, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return rectangle.nonNegativeCornerRadius(diagnostics, context);
    }

    public boolean validateRootCanvas(RootCanvas rootCanvas, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(rootCanvas, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(rootCanvas, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(rootCanvas, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(rootCanvas, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(rootCanvas, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(rootCanvas, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(rootCanvas, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(rootCanvas, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(rootCanvas, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateDefinition_idCannotBeEmpty(rootCanvas, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateGraphicalElement_referencedClippathHasId(rootCanvas, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateCanvas_canvasCannotHaveTransforms(rootCanvas, diagnostics, context);
        }
        return result;
    }

    public boolean validateRotate(Rotate rotate, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(rotate, diagnostics, context);
    }

    public boolean validateScale(Scale scale, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(scale, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(scale, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(scale, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(scale, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(scale, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(scale, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(scale, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(scale, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(scale, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateScale_nonnegativescale(scale, diagnostics, context);
        }
        return result;
    }

    public boolean validateScale_nonnegativescale(Scale scale, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return scale.nonnegativescale(diagnostics, context);
    }

    public boolean validateSkew(Skew skew, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(skew, diagnostics, context);
    }

    public boolean validateText(Text text, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(text, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(text, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(text, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(text, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(text, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(text, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(text, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(text, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(text, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateDefinition_idCannotBeEmpty(text, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateGraphicalElement_referencedClippathHasId(text, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateText_dataCannotBeEmpty(text, diagnostics, context);
        }
        return result;
    }

    public boolean validateText_dataCannotBeEmpty(Text text, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return text.dataCannotBeEmpty(diagnostics, context);
    }

    public boolean validateTranslate(Translate translate, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(translate, diagnostics, context);
    }

    public boolean validateUse(Use use, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(use, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(use, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(use, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(use, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(use, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(use, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(use, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(use, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(use, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateDefinition_idCannotBeEmpty(use, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateGraphicalElement_referencedClippathHasId(use, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateUse_referencedElementHasId(use, diagnostics, context);
        }
        return result;
    }

    public boolean validateUse_referencedElementHasId(Use use, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return use.referencedElementHasId(diagnostics, context);
    }

    public boolean validateFontDecoration(FontDecoration fontDecoration, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateElementKind(ElementKind elementKind, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateTextAnchor(TextAnchor textAnchor, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public ResourceLocator getResourceLocator() {
        return super.getResourceLocator();
    }
}

