/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.eastadl.dependability;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ControllabilityClassKind implements Enumerator
{
    C1(0, "C1", "C1"),
    C2(1, "C2", "C2"),
    C3(2, "C3", "C3"),
    C0(3, "C0", "C0");

    public static final int C1_VALUE = 0;
    public static final int C2_VALUE = 1;
    public static final int C3_VALUE = 2;
    public static final int C0_VALUE = 3;
    private static final ControllabilityClassKind[] VALUES_ARRAY;
    public static final List<ControllabilityClassKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ControllabilityClassKind[]{C1, C2, C3, C0};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ControllabilityClassKind get(int value) {
        switch (value) {
            case 0: {
                return C1;
            }
            case 1: {
                return C2;
            }
            case 2: {
                return C3;
            }
            case 3: {
                return C0;
            }
        }
        return null;
    }

    public static ControllabilityClassKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ControllabilityClassKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ControllabilityClassKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ControllabilityClassKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    private ControllabilityClassKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String getName() {
        return this.name;
    }

    public int getValue() {
        return this.value;
    }

    public String toString() {
        return this.literal;
    }
}

