/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.eastadl.dependability.safetyconstraints;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ASILKind implements Enumerator
{
    ASIL_A(0, "ASIL_A", "ASIL_A"),
    ASIL_D(1, "ASIL_D", "ASIL_D"),
    ASIL_C(2, "ASIL_C", "ASIL_C"),
    ASIL_B(3, "ASIL_B", "ASIL_B"),
    QM(4, "QM", "QM");

    public static final int ASIL_A_VALUE = 0;
    public static final int ASIL_D_VALUE = 1;
    public static final int ASIL_C_VALUE = 2;
    public static final int ASIL_B_VALUE = 3;
    public static final int QM_VALUE = 4;
    private static final ASILKind[] VALUES_ARRAY;
    public static final List<ASILKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ASILKind[]{ASIL_A, ASIL_D, ASIL_C, ASIL_B, QM};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ASILKind get(int value) {
        switch (value) {
            case 0: {
                return ASIL_A;
            }
            case 1: {
                return ASIL_D;
            }
            case 2: {
                return ASIL_C;
            }
            case 3: {
                return ASIL_B;
            }
            case 4: {
                return QM;
            }
        }
        return null;
    }

    public static ASILKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ASILKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ASILKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ASILKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    private ASILKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String getName() {
        return this.name;
    }

    public int getValue() {
        return this.value;
    }

    public String toString() {
        return this.literal;
    }
}

