/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.eastadl.structure.featuremodeling;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum VariabilityDependencyKind implements Enumerator
{
    NEEDS(0, "needs", "needs"),
    OPTIONAL_ALTERNATIVE(1, "optionalAlternative", "optionalAlternative"),
    CUSTOM(2, "custom", "custom"),
    MANDATORY_ALTERNATIVE(3, "mandatoryAlternative", "mandatoryAlternative"),
    SUGGESTS(4, "suggests", "suggests"),
    IMPEDES(5, "impedes", "impedes");

    public static final int NEEDS_VALUE = 0;
    public static final int OPTIONAL_ALTERNATIVE_VALUE = 1;
    public static final int CUSTOM_VALUE = 2;
    public static final int MANDATORY_ALTERNATIVE_VALUE = 3;
    public static final int SUGGESTS_VALUE = 4;
    public static final int IMPEDES_VALUE = 5;
    private static final VariabilityDependencyKind[] VALUES_ARRAY;
    public static final List<VariabilityDependencyKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new VariabilityDependencyKind[]{NEEDS, OPTIONAL_ALTERNATIVE, CUSTOM, MANDATORY_ALTERNATIVE, SUGGESTS, IMPEDES};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static VariabilityDependencyKind get(int value) {
        switch (value) {
            case 0: {
                return NEEDS;
            }
            case 1: {
                return OPTIONAL_ALTERNATIVE;
            }
            case 2: {
                return CUSTOM;
            }
            case 3: {
                return MANDATORY_ALTERNATIVE;
            }
            case 4: {
                return SUGGESTS;
            }
            case 5: {
                return IMPEDES;
            }
        }
        return null;
    }

    public static VariabilityDependencyKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            VariabilityDependencyKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static VariabilityDependencyKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            VariabilityDependencyKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    private VariabilityDependencyKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String getName() {
        return this.name;
    }

    public int getValue() {
        return this.value;
    }

    public String toString() {
        return this.literal;
    }
}

