/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.layers.runtime;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.papyrus.infra.gmfdiag.common.model.NotationModel;
import org.eclipse.papyrus.layers.runtime.Activator;
import org.eclipse.papyrus.layers.runtime.ILayersStackApplicationEventListener;
import org.eclipse.papyrus.layers.runtime.INotationDiagramRemovedEventListener;
import org.eclipse.papyrus.layers.runtime.LayerStackSynchronizer;
import org.eclipse.papyrus.layers.runtime.LayersStackApplicationEventNotifier;
import org.eclipse.papyrus.layers.runtime.NotationDiagramRemovedFromResourceEventNotifier;
import org.eclipse.papyrus.layers.runtime.model.ILayersModelRootEventListener;
import org.eclipse.papyrus.layers.runtime.model.LayersModel;
import org.eclipse.papyrus.layers.runtime.model.LayersModelEventRootNotifier;
import org.eclipse.papyrus.layers.stackmodel.layers.LayersStack;
import org.eclipse.papyrus.layers.stackmodel.layers.LayersStackApplication;

public class LayerStackApplicationSynchronizer
implements ILayersModelRootEventListener,
ILayersStackApplicationEventListener,
INotationDiagramRemovedEventListener {
    protected State state;
    protected LayersModel layersModel;
    protected NotationModel notationModel;
    protected Map<Diagram, LayerStackSynchronizer> synchronizers = new HashMap<Diagram, LayerStackSynchronizer>();
    protected NotationDiagramRemovedFromResourceEventNotifier notationDiagramRemovedNotifier;
    protected LayersStackApplicationEventNotifier layersStackApplicationEventNotifier;
    protected LayersModelEventRootNotifier layersModelEventRootNotifier;

    public LayerStackApplicationSynchronizer(LayersModel layersModel, NotationModel notationModel) {
        this.layersModel = layersModel;
        this.notationModel = notationModel;
        this.initState();
    }

    private void initState() {
        if (this.layersModel.lookupLayerStackApplication() != null) {
            this.transitionInitToApplicationCreatedState();
        } else {
            this.transitionInitToNoApplicationState();
        }
    }

    private void transitionInitToApplicationCreatedState() {
        this.activateLayersModelAndDiagramDeletionNotifiers();
        this.activateLayersModelRootNotifier();
        this.createSynchronizerForExistingStacks();
        this.state = State.ApplicationCreated;
    }

    private void transitionNoApplicationToApplicationCreatedState() {
        this.activateLayersModelAndDiagramDeletionNotifiers();
        this.activateLayersModelRootNotifier();
        this.state = State.ApplicationCreated;
    }

    private void transitionInitToNoApplicationState() {
        this.activateLayersModelRootNotifier();
        this.state = State.NoApplication;
    }

    private void transitionApplicationCreatedToNoApplicationState() {
        this.deactivateLayersModelAndDiagramDeletionNotifiers();
        this.state = State.NoApplication;
    }

    private void createSynchronizerForExistingStacks() {
        LayersStackApplication application = this.layersModel.lookupLayerStackApplication();
        if (application == null) {
            return;
        }
        for (LayersStack stack : application.getLayersStacks()) {
            if (stack.getDiagram() == null) continue;
            this.addLayerStackSynchronizer(stack);
        }
    }

    public Map<Diagram, LayerStackSynchronizer> getSynchronizers() {
        return this.synchronizers;
    }

    public LayersModel getLayersModel() {
        return this.layersModel;
    }

    public NotationModel getNotationModel() {
        return this.notationModel;
    }

    protected void activate() {
        this.initState();
    }

    private void activateLayersModelRootNotifier() {
        this.layersModelEventRootNotifier = new LayersModelEventRootNotifier(this.layersModel);
        this.layersModelEventRootNotifier.addEventListener(this);
    }

    private void deactivateLayersModelRootNotifier() {
        if (this.layersModelEventRootNotifier != null) {
            this.layersModelEventRootNotifier.removeEventListener(this);
            this.layersModelEventRootNotifier = null;
        }
    }

    private void activateLayersModelAndDiagramDeletionNotifiers() {
        this.notationDiagramRemovedNotifier = new NotationDiagramRemovedFromResourceEventNotifier(this.notationModel);
        this.notationDiagramRemovedNotifier.addLayersModelEventListener(this);
        this.layersStackApplicationEventNotifier = new LayersStackApplicationEventNotifier(this.layersModel);
        this.layersStackApplicationEventNotifier.addLayersModelEventListener(this);
    }

    protected void deactivateLayersModelAndDiagramDeletionNotifiers() {
        if (this.notationDiagramRemovedNotifier != null) {
            this.notationDiagramRemovedNotifier.removeLayersModelEventListener(this);
            this.notationDiagramRemovedNotifier = null;
        }
        if (this.layersStackApplicationEventNotifier != null) {
            this.layersStackApplicationEventNotifier.removeLayersModelEventListener(this);
            this.layersStackApplicationEventNotifier = null;
        }
    }

    protected void deactivate() {
        this.deactivateLayersModelAndDiagramDeletionNotifiers();
        this.deactivateLayersModelRootNotifier();
    }

    public void dispose() {
        this.deactivate();
        this.layersModel = null;
        this.notationModel = null;
        this.state = State.disposed;
    }

    protected boolean isDisposed() {
        return this.state == State.disposed;
    }

    @Override
    public void layerStackAdded(Notification msg) {
        if (Activator.log.isDebugEnabled()) {
            Activator.log.debug("LayerStackApplicationSynchronizer.layerStackAdded : " + msg.getNewValue());
        }
        LayersStack stack = LayersStackApplicationEventNotifier.getAddedLayerStack(msg);
        this.addLayerStackSynchronizer(stack);
    }

    private void addLayerStackSynchronizer(LayersStack stack) {
        if (this.lookupLayersStackSynchronizer(stack.getDiagram()) != null) {
            return;
        }
        LayerStackSynchronizer layerStackSynchronizer = new LayerStackSynchronizer(stack);
        this.putLayersStackSynchronizer(layerStackSynchronizer);
    }

    protected LayerStackSynchronizer lookupLayersStackSynchronizer(Diagram diagram) {
        return this.synchronizers.get(diagram);
    }

    protected void putLayersStackSynchronizer(LayerStackSynchronizer layerStackSynchronizer) {
        this.synchronizers.put(layerStackSynchronizer.getDiagram(), layerStackSynchronizer);
    }

    @Override
    public void layerStackRemoved(Notification msg) {
        if (Activator.log.isDebugEnabled()) {
            Activator.log.debug("LayerStack is removed" + msg.getOldValue());
        }
        LayersStack stack = LayersStackApplicationEventNotifier.getRemovedLayerStack(msg);
        LayerStackSynchronizer synchronizer = this.synchronizers.remove(stack.getDiagram());
        synchronizer.dispose();
    }

    @Override
    public void diagramRemoved(Notification msg) {
        if (Activator.log.isDebugEnabled()) {
            Activator.log.debug(String.valueOf(this.getClass().getSimpleName()) + ".diagramRemoved() - " + msg.getOldValue());
        }
        if (this.state != State.ApplicationCreated) {
            return;
        }
        Diagram diagram = NotationDiagramRemovedFromResourceEventNotifier.getRemovedDiagram(msg);
        this.getLayersModel().lookupLayerStackApplication().removeLayersStackFor(diagram);
        LayerStackSynchronizer synchronizer = this.synchronizers.remove(diagram);
        if (synchronizer != null) {
            Activator.log.info(String.valueOf(this.getClass().getSimpleName()) + ".diagramRemoved() - synchronizer not completly cleaned. Finish the job.");
            synchronizer.dispose();
        }
    }

    @Override
    public void layersModelRootAdded(Notification msg) {
        if (this.state == State.NoApplication) {
            this.transitionNoApplicationToApplicationCreatedState();
        }
    }

    @Override
    public void layersModelRootRemoved(Notification msg) {
        if (this.state == State.ApplicationCreated) {
            this.transitionApplicationCreatedToNoApplicationState();
        }
    }

    protected static enum State {
        NoApplication,
        ApplicationCreated,
        disposed;

    }
}

