/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.layers.runtime;

import org.eclipse.emf.common.util.URI;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.NotationFactory;
import org.eclipse.papyrus.infra.core.resource.IModel;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.gmfdiag.common.model.NotationModel;
import org.eclipse.papyrus.layers.runtime.LayersStackAndApplicationLifeCycleEventNotifier;
import org.eclipse.papyrus.layers.runtime.NotationDiagramHelper;
import org.eclipse.papyrus.layers.runtime.TraceLayersStackApplicationEventListener;
import org.eclipse.papyrus.layers.runtime.model.LayersModel;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class LayersStackAndApplicationLifeCycleEventNotifierTest {
    protected static final String PROJECT_MODEL_URI = "org.eclipse.papyrus.infra.core/tmp/model1.di";
    protected ModelSet modelSet;

    @Before
    public void setUp() throws Exception {
        ModelSet mngr = new ModelSet();
        LayersModel layersModel = new LayersModel();
        mngr.registerModel((IModel)layersModel);
        NotationModel notationModel = new NotationModel();
        mngr.registerModel((IModel)notationModel);
        URI uri = URI.createPlatformResourceURI((String)PROJECT_MODEL_URI, (boolean)true);
        mngr.createModels(uri);
        this.modelSet = mngr;
    }

    @After
    public void tearDown() throws Exception {
        this.modelSet.unload();
    }

    @Test
    public void testLayersStackAndApplicationLifeCycleEventNotifier() {
        LayersModel layersModel = (LayersModel)this.modelSet.getModel("org.eclipse.papyrus.layers.runtime.model.LayersModel");
        LayersStackAndApplicationLifeCycleEventNotifier notifier = new LayersStackAndApplicationLifeCycleEventNotifier(layersModel);
        Assert.assertNotNull((String)"application created", (Object)notifier);
        notifier.dispose();
    }

    @Test
    public void testDispose() {
        LayersModel layersModel = (LayersModel)this.modelSet.getModel("org.eclipse.papyrus.layers.runtime.model.LayersModel");
        LayersStackAndApplicationLifeCycleEventNotifier synchronizer = new LayersStackAndApplicationLifeCycleEventNotifier(layersModel);
        Assert.assertFalse((String)"application created", (boolean)synchronizer.isDisposed());
        synchronizer.dispose();
        Assert.assertTrue((String)"object is disposed", (boolean)synchronizer.isDisposed());
    }

    @Test
    public void testIsDisposed() {
        LayersModel layersModel = (LayersModel)this.modelSet.getModel("org.eclipse.papyrus.layers.runtime.model.LayersModel");
        LayersStackAndApplicationLifeCycleEventNotifier synchronizer = new LayersStackAndApplicationLifeCycleEventNotifier(layersModel);
        Assert.assertFalse((String)"application created", (boolean)synchronizer.isDisposed());
        synchronizer.dispose();
        Assert.assertTrue((String)"object is disposed", (boolean)synchronizer.isDisposed());
    }

    @Test
    @Ignore
    public void testAddLayersModelEventListener() {
        Assert.fail((String)"Not yet implemented");
    }

    @Test
    @Ignore
    public void testRemoveLayersModelEventListener() {
        Assert.fail((String)"Not yet implemented");
    }

    @Test
    @Ignore
    public void testAddLayersStackApplicationLifeCycleEventListener() {
        Assert.fail((String)"Not yet implemented");
    }

    @Test
    @Ignore
    public void testRemoveLayersStackApplicationLifeCycleEventListener() {
        Assert.fail((String)"Not yet implemented");
    }

    @Test
    public void testModelSetCreation() {
        NotationModel notationModel = (NotationModel)this.modelSet.getModel("org.eclipse.papyrus.infra.core.resource.notation.NotationModel");
        Assert.assertNotNull((String)"NotationModel is created", (Object)notationModel);
        notationModel.addDiagram(NotationFactory.eINSTANCE.createDiagram());
        Assert.assertNotNull((String)"Diagram is in the roots", (Object)notationModel.getResource().getContents().get(0));
        LayersModel layersModel = (LayersModel)this.modelSet.getModel("org.eclipse.papyrus.layers.runtime.model.LayersModel");
        Assert.assertNotNull((String)"LayerModel is created", (Object)((Object)layersModel));
        Assert.assertNotNull((String)"LayerStackApplication is created", (Object)layersModel.getLayerStackApplication());
    }

    @Test
    public void testLayerStackAdded() {
        NotationModel notationModel = (NotationModel)this.modelSet.getModel("org.eclipse.papyrus.infra.core.resource.notation.NotationModel");
        LayersModel layersModel = (LayersModel)this.modelSet.getModel("org.eclipse.papyrus.layers.runtime.model.LayersModel");
        Diagram diagram = NotationFactory.eINSTANCE.createDiagram();
        notationModel.addDiagram(diagram);
        NotationDiagramHelper helper = new NotationDiagramHelper(layersModel, diagram);
        TraceLayersStackApplicationEventListener traces = new TraceLayersStackApplicationEventListener();
        LayersStackAndApplicationLifeCycleEventNotifier notifier = new LayersStackAndApplicationLifeCycleEventNotifier(layersModel);
        notifier.addLayersModelEventListener(traces);
        helper.attachLayersStack();
        Assert.assertTrue((String)"event catched", (boolean)traces.traces.contains("layerStackAdded"));
        notifier.dispose();
    }

    @Test
    public void testLayerStackRemoved() {
        NotationModel notationModel = (NotationModel)this.modelSet.getModel("org.eclipse.papyrus.infra.core.resource.notation.NotationModel");
        LayersModel layersModel = (LayersModel)this.modelSet.getModel("org.eclipse.papyrus.layers.runtime.model.LayersModel");
        Diagram diagram = NotationFactory.eINSTANCE.createDiagram();
        notationModel.addDiagram(diagram);
        NotationDiagramHelper helper = new NotationDiagramHelper(layersModel, diagram);
        TraceLayersStackApplicationEventListener traces = new TraceLayersStackApplicationEventListener();
        LayersStackAndApplicationLifeCycleEventNotifier notifier = new LayersStackAndApplicationLifeCycleEventNotifier(layersModel);
        notifier.addLayersModelEventListener(traces);
        helper.attachLayersStack();
        traces.traces.clear();
        helper.removeLayersStack();
        Assert.assertTrue((String)"event catched", (boolean)traces.traces.contains("layerStackRemoved"));
        notifier.dispose();
    }
}

