/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.layers.runtime.utils;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.layers.stackmodel.LayersException;
import org.eclipse.papyrus.layers.stackmodel.layers.BooleanInstance;
import org.eclipse.papyrus.layers.stackmodel.layers.Layer;
import org.eclipse.papyrus.layers.stackmodel.layers.LayersFactory;
import org.eclipse.papyrus.layers.stackmodel.layers.LayersPackage;
import org.eclipse.papyrus.layers.stackmodel.layers.TopLayerOperator;
import org.eclipse.papyrus.layers.stackmodel.layers.util.ECoreUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ECoreUtilsTest {
    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testIsAncestorInstanceOf() {
        TopLayerOperator layerOperator = LayersFactory.eINSTANCE.createTopLayerOperator();
        Layer layer = LayersFactory.eINSTANCE.createLayer();
        layerOperator.getLayers().add((Object)layer);
        BooleanInstance instance2 = LayersFactory.eINSTANCE.createBooleanInstance();
        layer.getPropertyValueMap().put((Object)"prop1", (Object)instance2);
        Assert.assertTrue((String)"ancestor found", (boolean)ECoreUtils.isAncestorInstanceOf((EObject)instance2, (EClass)LayersPackage.eINSTANCE.getTypeInstance()));
        Assert.assertTrue((String)"ancestor found", (boolean)ECoreUtils.isAncestorInstanceOf((EObject)instance2, (EClass)LayersPackage.eINSTANCE.getLayer()));
        Assert.assertTrue((String)"ancestor found", (boolean)ECoreUtils.isAncestorInstanceOf((EObject)instance2, (EClass)LayersPackage.eINSTANCE.getTopLayerOperator()));
        Assert.assertTrue((String)"ancestor found", (boolean)ECoreUtils.isAncestorInstanceOf((EObject)instance2, (EClass)LayersPackage.eINSTANCE.getLayerOperator()));
        Assert.assertFalse((String)"no ancestor found", (boolean)ECoreUtils.isAncestorInstanceOf((EObject)instance2, (EClass)LayersPackage.eINSTANCE.getLayersStack()));
    }

    @Test
    public void testLookupAncestorOfType() throws LayersException {
        TopLayerOperator layerOperator = LayersFactory.eINSTANCE.createTopLayerOperator();
        Layer layer = LayersFactory.eINSTANCE.createLayer();
        layerOperator.getLayers().add((Object)layer);
        BooleanInstance instance2 = LayersFactory.eINSTANCE.createBooleanInstance();
        layer.getPropertyValueMap().put((Object)"prop1", (Object)instance2);
        Assert.assertEquals((String)"ancestor found", (Object)instance2, (Object)ECoreUtils.lookupAncestorOfType((EObject)instance2, (EClass)LayersPackage.eINSTANCE.getTypeInstance()));
        Assert.assertEquals((String)"ancestor found", (Object)layer, (Object)ECoreUtils.lookupAncestorOfType((EObject)instance2, (EClass)LayersPackage.eINSTANCE.getLayer()));
        Assert.assertEquals((String)"ancestor found", (Object)layerOperator, (Object)ECoreUtils.lookupAncestorOfType((EObject)instance2, (EClass)LayersPackage.eINSTANCE.getTopLayerOperator()));
        Assert.assertEquals((String)"ancestor found", (Object)layerOperator, (Object)ECoreUtils.lookupAncestorOfType((EObject)instance2, (EClass)LayersPackage.eINSTANCE.getLayerOperator()));
        try {
            ECoreUtils.lookupAncestorOfType((EObject)instance2, (EClass)LayersPackage.eINSTANCE.getLayersStack());
            Assert.fail((String)"Exception is thrown");
        }
        catch (LayersException layersException) {
            // empty catch block
        }
    }
}

