/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.migration.rsa.blackbox;

import java.util.Collection;
import java.util.LinkedList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.m2m.qvt.oml.blackbox.java.Operation;
import org.eclipse.m2m.qvt.oml.util.IContext;
import org.eclipse.uml2.common.util.CacheAdapter;
import org.eclipse.uml2.uml.CallEvent;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Collaboration;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.LiteralString;
import org.eclipse.uml2.uml.OpaqueExpression;
import org.eclipse.uml2.uml.SignalEvent;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.UMLPackage;

public class RTMappings {
    @Operation(contextual=true, kind=Operation.Kind.MAPPING, withExecutionContext=true)
    public static Class toClass(IContext context, Collaboration collaboration) {
        return RTMappings.refactorType(context, (EObject)collaboration, UMLPackage.eINSTANCE.getClass_(), Class.class);
    }

    @Operation(contextual=true, kind=Operation.Kind.MAPPING, withExecutionContext=true)
    public static SignalEvent toSignalEvent(IContext context, CallEvent callEvent) {
        return RTMappings.refactorType(context, (EObject)callEvent, UMLPackage.eINSTANCE.getSignalEvent(), SignalEvent.class);
    }

    @Operation(contextual=true, kind=Operation.Kind.MAPPING, withExecutionContext=false)
    public static LiteralString toLiteralString(OpaqueExpression expression) {
        return RTMappings.refactorType(null, (EObject)expression, UMLPackage.eINSTANCE.getLiteralString(), LiteralString.class);
    }

    private static <T extends Element> T refactorType(IContext context, EObject sourceElement, EClass targetEClass, java.lang.Class<T> resultType) {
        Element result = (Element)resultType.cast(UMLFactory.eINSTANCE.create(targetEClass));
        for (EStructuralFeature sourceFeature : sourceElement.eClass().getEAllStructuralFeatures()) {
            EStructuralFeature targetFeature = result.eClass().getEStructuralFeature(sourceFeature.getName());
            if (targetFeature == null || !targetFeature.isChangeable() || !sourceElement.eIsSet(sourceFeature)) continue;
            result.eSet(targetFeature, sourceElement.eGet(sourceFeature));
        }
        Collection incomingReferences = CacheAdapter.getInstance().getInverseReferences(sourceElement);
        for (EStructuralFeature.Setting setting : incomingReferences) {
            EStructuralFeature feature = setting.getEStructuralFeature();
            if (!feature.isChangeable() || !feature.getEType().isInstance((Object)result)) continue;
            if (feature.isMany()) {
                int index;
                Object value = setting.get(true);
                if (!(value instanceof Collection)) continue;
                LinkedList<Element> copy = new LinkedList<Element>((Collection)value);
                while ((index = copy.indexOf(sourceElement)) >= 0) {
                    copy.remove(index);
                    copy.add(index, result);
                }
                setting.set(copy);
                continue;
            }
            setting.set((Object)result);
        }
        return (T)result;
    }
}

