/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.migration.rsa.wizard.pages;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.papyrus.infra.widgets.util.FileUtil;
import org.eclipse.papyrus.migration.rsa.Activator;
import org.eclipse.papyrus.migration.rsa.RSAToPapyrusParameters.Config;
import org.eclipse.papyrus.migration.rsa.RSAToPapyrusParameters.RSAToPapyrusParametersFactory;
import org.eclipse.papyrus.migration.rsa.constants.TransformationWizardConstants;

public class DialogData {
    protected Collection<Object> selectedFiles;
    protected Collection<Object> systemSelectedFiles;
    protected Collection<Object> transformationFiles;
    protected Config config = RSAToPapyrusParametersFactory.eINSTANCE.createConfig();
    protected Collection<String> unselectedFiles;
    public IDialogSettings dialogSection = Activator.getDefault().getDialogSettings().getSection("org.eclipse.papyrus.migration.rsaWizard.lastUnselection");
    protected Collection<Object> uncheckedFiles;
    protected Collection<Object> importedProjects;

    public DialogData() {
        if (this.dialogSection == null) {
            this.dialogSection = Activator.getDefault().getDialogSettings().addNewSection("org.eclipse.papyrus.migration.rsaWizard.lastUnselection");
        }
        this.systemSelectedFiles = new LinkedList<Object>();
    }

    public void setSelectedFiles(Collection<Object> selectedFiles) {
        this.selectedFiles = selectedFiles;
    }

    public void setSystemSelectedFiles(Collection<String> systemPaths) {
        for (String filePath : systemPaths) {
            File file = new File(filePath);
            if (file == null || this.systemSelectedFiles.contains(file)) continue;
            this.systemSelectedFiles.add(file);
        }
    }

    public void setTransformationFiles(Collection<Object> transformationFiles) {
        this.transformationFiles = transformationFiles;
    }

    public String[] getExtensions() {
        return TransformationWizardConstants.EXTENSIONS;
    }

    public String[] getExtensionsNames() {
        return TransformationWizardConstants.EXTENSIONS_NAMES;
    }

    public Collection<Object> getSelectedFiles() {
        return this.selectedFiles;
    }

    public Collection<Object> getSystemSelectedFiles() {
        return this.systemSelectedFiles;
    }

    public Collection<Object> getAllSelectedFiles() {
        LinkedList<Object> allSelectedFiles = new LinkedList<Object>();
        if (this.selectedFiles != null && this.selectedFiles.size() > 0) {
            allSelectedFiles.addAll(this.selectedFiles);
        }
        return allSelectedFiles;
    }

    public Config getConfig() {
        return this.config;
    }

    public Collection<Object> getTransformationFiles() {
        return this.transformationFiles;
    }

    public void setUncheckedFiles(Collection<Object> uncheckedFiles) {
        this.uncheckedFiles = uncheckedFiles;
    }

    public void setImportedProjects(Collection<Object> importedProjects) {
        this.importedProjects = importedProjects;
    }

    public Collection<Object> getImportedProjects() {
        return this.importedProjects;
    }

    public void setSelectionMap() {
        File file;
        String filePath;
        IFile ifile;
        String ifilePath;
        this.unselectedFiles = this.getUnSelectionArray() != null ? new LinkedList<String>(Arrays.asList(this.getUnSelectionArray())) : new LinkedList<String>();
        for (Object object : this.uncheckedFiles) {
            if (object instanceof IFile && !this.unselectedFiles.contains(ifilePath = FileUtil.getPath((IFile)(ifile = (IFile)object), (boolean)true))) {
                this.unselectedFiles.add(ifilePath);
            }
            if (!(object instanceof File) || this.unselectedFiles.contains(filePath = (file = (File)object).getAbsolutePath())) continue;
            this.unselectedFiles.add(filePath);
        }
        for (Object object : this.transformationFiles) {
            if (object instanceof IFile && this.unselectedFiles.contains(ifilePath = FileUtil.getPath((IFile)(ifile = (IFile)object), (boolean)true))) {
                this.unselectedFiles.remove(ifilePath);
            }
            if (!(object instanceof File) || !this.unselectedFiles.contains(filePath = (file = (File)object).getAbsolutePath())) continue;
            this.unselectedFiles.remove(filePath);
        }
        this.dialogSection.put("selectionPeferences", this.unselectedFiles.toArray(new String[this.unselectedFiles.size()]));
    }

    public String[] getUnSelectionArray() {
        return this.dialogSection.getArray("selectionPeferences");
    }
}

