/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.async.fuml.Semantics.CommonBehaviors.Communications;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.papyrus.infra.core.Activator;
import org.eclipse.papyrus.moka.MokaConstants;
import org.eclipse.papyrus.moka.async.fuml.Semantics.CommonBehaviors.Communications.AsyncEventPool;
import org.eclipse.papyrus.moka.async.fuml.debug.AsyncControlDelegate;
import org.eclipse.papyrus.moka.async.fuml.debug.AsyncDebug;
import org.eclipse.papyrus.moka.fuml.FUMLExecutionEngine;
import org.eclipse.papyrus.moka.fuml.Semantics.Actions.CompleteActions.AcceptEventActionEventAccepter;
import org.eclipse.papyrus.moka.fuml.Semantics.CommonBehaviors.BasicBehaviors.ParameterValue;
import org.eclipse.papyrus.moka.fuml.Semantics.CommonBehaviors.Communications.ClassifierBehaviorExecution;
import org.eclipse.papyrus.moka.fuml.Semantics.CommonBehaviors.Communications.EventAccepter;
import org.eclipse.papyrus.moka.fuml.Semantics.CommonBehaviors.Communications.ObjectActivation;
import org.eclipse.papyrus.moka.fuml.Semantics.CommonBehaviors.Communications.SignalInstance;
import org.eclipse.papyrus.moka.fuml.Semantics.Loci.LociL1.ChoiceStrategy;
import org.eclipse.papyrus.moka.fuml.standardlibrary.library.io.StandardOutputChannelImpl;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.console.IOConsoleOutputStream;
import org.eclipse.uml2.uml.AcceptEventAction;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Signal;
import org.eclipse.uml2.uml.SignalEvent;
import org.eclipse.uml2.uml.Trigger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsyncObjectActivation
extends ObjectActivation
implements Runnable {
    protected ObjectActivationState currentState = null;
    protected final Class classifier;
    protected final List<ParameterValue> inputs;
    protected AsyncEventPool evtPool;
    protected boolean hasBeenWaiting = false;
    protected IOConsoleOutputStream out;

    public AsyncObjectActivation(Class classifier, List<ParameterValue> inputs) {
        this.classifier = classifier;
        this.inputs = inputs;
        this.evtPool = new AsyncEventPool(this);
    }

    @Override
    public void run() {
        this.currentState = ObjectActivationState.RUNNING;
        try {
            this.startBehavior(this.classifier, this.inputs);
        }
        catch (Exception e) {
            Activator.log.error((Throwable)e);
            if (!MokaConstants.SILENT_MODE) {
                Display.getDefault().syncExec(new Runnable(){

                    public void run() {
                        MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Moka", (String)"An unexpected error occurred during execution. See error log for details.");
                    }
                });
            }
            ((AsyncControlDelegate)FUMLExecutionEngine.eInstance.getControlDelegate()).notifyThreadTermination(this);
        }
        while (!FUMLExecutionEngine.eInstance.isTerminated() && this.currentState.equals((Object)ObjectActivationState.RUNNING)) {
            try {
                this.dispatchNextEvent();
            }
            catch (Exception e) {
                Activator.log.error((Throwable)e);
                if (!MokaConstants.SILENT_MODE) {
                    Display.getDefault().syncExec(new Runnable(){

                        public void run() {
                            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Moka", (String)"An unexpected error occurred during execution. See error log for details.");
                        }
                    });
                }
                ((AsyncControlDelegate)FUMLExecutionEngine.eInstance.getControlDelegate()).notifyThreadTermination(this);
            }
            if (!this.waitingEventAccepters.isEmpty()) continue;
            this.currentState = ObjectActivationState.STOPPED;
        }
        ((AsyncControlDelegate)FUMLExecutionEngine.eInstance.getControlDelegate()).notifyThreadTermination(this);
    }

    public ObjectActivationState getCurrentState() {
        return this.currentState;
    }

    public synchronized void send(SignalInstance signalInstance) {
        SignalInstance copy = (SignalInstance)signalInstance.copy();
        this.evtPool.send(copy);
        AsyncDebug.println("[SignalInstance sent] " + signalInstance.type.getName());
    }

    public SignalInstance getNextEvent() {
        if (this.evtPool.isEmpty()) {
            this.currentState = ObjectActivationState.WAITING;
            this.hasBeenWaiting = true;
            ((AsyncControlDelegate)FUMLExecutionEngine.eInstance.getControlDelegate()).notifyWaitingStateEntered(this);
        }
        SignalInstance signalInstance = this.evtPool.getNextEvent();
        this.currentState = ObjectActivationState.RUNNING;
        if (signalInstance != null) {
            AsyncDebug.println("[consumed SignalInstance] " + signalInstance.type.getName());
        }
        return signalInstance;
    }

    public void startBehavior(Class classifier, List<ParameterValue> inputs) {
        if (classifier == null) {
            AsyncDebug.println("Starting behavior for all classifiers...");
            List types = this.object.types;
            for (Class type : types) {
                if (!(type instanceof Behavior | type.getClassifierBehavior() != null)) continue;
                this.startBehavior(type, new ArrayList<ParameterValue>());
            }
        } else {
            AsyncDebug.println("Starting behavior for " + classifier.getName() + "...");
            boolean notYetStarted = true;
            int i = 1;
            while (notYetStarted & i <= this.classifierBehaviorExecutions.size()) {
                notYetStarted = ((ClassifierBehaviorExecution)this.classifierBehaviorExecutions.get((int)(i - 1))).classifier != classifier;
                ++i;
            }
            if (notYetStarted) {
                ClassifierBehaviorExecution newExecution = new ClassifierBehaviorExecution();
                newExecution.objectActivation = this;
                this.classifierBehaviorExecutions.add(newExecution);
                newExecution.execute(classifier, inputs);
            }
        }
    }

    public void stop() {
        super.stop();
        this.currentState = ObjectActivationState.STOPPED;
    }

    public void dispatchNextEvent() {
        SignalInstance signalInstance = this.getNextEvent();
        AsyncDebug.println("[dispatchNextEvent] signalInstance = " + signalInstance);
        ArrayList<Integer> matchingEventAccepterIndexes = new ArrayList<Integer>();
        List waitingEventAccepters = this.waitingEventAccepters;
        int i = 0;
        while (i < waitingEventAccepters.size()) {
            EventAccepter eventAccepter = (EventAccepter)waitingEventAccepters.get(i);
            if (eventAccepter.match(signalInstance).booleanValue()) {
                matchingEventAccepterIndexes.add(i);
            }
            ++i;
        }
        if (matchingEventAccepterIndexes.size() > 0) {
            int j = ((ChoiceStrategy)this.object.locus.factory.getStrategy("choice")).choose(Integer.valueOf(matchingEventAccepterIndexes.size()));
            EventAccepter selectedEventAccepter = (EventAccepter)this.waitingEventAccepters.get((Integer)matchingEventAccepterIndexes.get(j - 1));
            this.waitingEventAccepters.remove(selectedEventAccepter);
            if (this.hasBeenWaiting) {
                this.hasBeenWaiting = false;
                if (selectedEventAccepter instanceof AcceptEventActionEventAccepter) {
                    ((AsyncControlDelegate)FUMLExecutionEngine.eInstance.getControlDelegate()).notifyWaitingStateExit(this, (AcceptEventActionEventAccepter)selectedEventAccepter);
                }
            }
            selectedEventAccepter.accept(signalInstance);
        } else {
            if (this.out == null) {
                this.out = StandardOutputChannelImpl.getConsole().newOutputStream();
            }
            String expectedSignals = "";
            for (EventAccepter eventAccepter : this.waitingEventAccepters) {
                if (!(eventAccepter instanceof AcceptEventActionEventAccepter)) continue;
                AcceptEventActionEventAccepter acceptEventAccepter = (AcceptEventActionEventAccepter)eventAccepter;
                AcceptEventAction acceptEventAction = (AcceptEventAction)acceptEventAccepter.actionActivation.node;
                for (Trigger trigger : acceptEventAction.getTriggers()) {
                    if (!(trigger.getEvent() instanceof SignalEvent)) continue;
                    SignalEvent signalEvent = (SignalEvent)trigger.getEvent();
                    Signal signal = signalEvent.getSignal();
                    if (!expectedSignals.isEmpty()) {
                        expectedSignals = String.valueOf(expectedSignals) + ", ";
                    }
                    expectedSignals = String.valueOf(expectedSignals) + signal.getName();
                }
            }
            final SignalInstance finalSignalInstance = signalInstance;
            final String finalExpectedSignals = expectedSignals;
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    try {
                        AsyncObjectActivation.this.out.setColor(new Color(null, new RGB(200, 120, 10)));
                        AsyncObjectActivation.this.out.write("[ WARNING : Lost signal " + ((Classifier)finalSignalInstance.getTypes().get(0)).getName() + " (classifier behavior of " + AsyncObjectActivation.this.classifier.getName() + " was waiting for " + finalExpectedSignals + ") ]\n");
                        AsyncObjectActivation.this.out.flush();
                    }
                    catch (IOException e) {
                        Activator.log.error((Throwable)e);
                    }
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ObjectActivationState {
        RUNNING,
        STOPPED,
        WAITING;

    }
}

