/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.composites.Semantics.CompositeStructures.InvocationActions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.moka.composites.Semantics.Classes.Kernel.CS_OpaqueExpressionEvaluation;
import org.eclipse.papyrus.moka.composites.Semantics.CompositeStructures.InvocationActions.CS_ConstructStrategy;
import org.eclipse.papyrus.moka.composites.Semantics.CompositeStructures.StructuredClasses.CS_InteractionPoint;
import org.eclipse.papyrus.moka.composites.Semantics.CompositeStructures.StructuredClasses.CS_Link;
import org.eclipse.papyrus.moka.composites.Semantics.CompositeStructures.StructuredClasses.CS_Object;
import org.eclipse.papyrus.moka.composites.Semantics.CompositeStructures.StructuredClasses.CS_Reference;
import org.eclipse.papyrus.moka.fuml.Semantics.Classes.Kernel.Evaluation;
import org.eclipse.papyrus.moka.fuml.Semantics.Classes.Kernel.FeatureValue;
import org.eclipse.papyrus.moka.fuml.Semantics.Classes.Kernel.Object_;
import org.eclipse.papyrus.moka.fuml.Semantics.Classes.Kernel.Reference;
import org.eclipse.papyrus.moka.fuml.Semantics.Classes.Kernel.Value;
import org.eclipse.papyrus.moka.fuml.Semantics.Loci.LociL1.Locus;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Connector;
import org.eclipse.uml2.uml.ConnectorEnd;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.MultiplicityElement;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.StructuralFeature;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.ValueSpecification;

public class CS_DefaultConstructStrategy
extends CS_ConstructStrategy {
    public Locus locus;
    public Association defaultAssociation;
    public List<Class> generatedRealizingClasses = new ArrayList<Class>();

    @Override
    public Object_ construct(Operation constructor, CS_Object context) {
        this.locus = context.locus;
        return this.constructObject(context, (Class)constructor.getType());
    }

    public Object_ constructObject(CS_Object context, Class type) {
        CS_Reference referenceToContext = new CS_Reference();
        referenceToContext.referent = context;
        referenceToContext.compositeReferent = context;
        EList allAttributes = type.getAllAttributes();
        int i = 1;
        while (i <= allAttributes.size()) {
            Property p = (Property)allAttributes.get(i - 1);
            if (p.getDefaultValue() != null) {
                ValueSpecification defaultValueSpecification = p.getDefaultValue();
                Evaluation evaluation = (Evaluation)context.locus.factory.instantiateVisitor((Element)defaultValueSpecification);
                evaluation.specification = defaultValueSpecification;
                evaluation.locus = context.locus;
                if (evaluation instanceof CS_OpaqueExpressionEvaluation) {
                    List<Value> evaluations = ((CS_OpaqueExpressionEvaluation)evaluation).executeExpressionBehavior();
                    int j = 0;
                    while (j < evaluations.size()) {
                        this.addStructuralFeatureValue(referenceToContext, p, evaluations.get(j));
                        ++j;
                    }
                } else {
                    Value defaultValue = evaluation.evaluate();
                    this.addStructuralFeatureValue(referenceToContext, p, defaultValue);
                }
            } else if (this.canInstantiate(p)) {
                int j = 1;
                while (j <= p.getLower()) {
                    Object_ value;
                    if (p instanceof Port && p.getType() instanceof Interface) {
                        value = this.instantiateInterface((Interface)p.getType(), this.locus);
                        this.addStructuralFeatureValue(referenceToContext, p, (Value)value);
                    } else {
                        value = context.locus.instantiate((Class)p.getType());
                        value = this.constructObject((CS_Object)value, (Class)p.getType());
                        this.addStructuralFeatureValue(referenceToContext, p, (Value)value);
                        if (((Class)p.getType()).isActive()) {
                            value.startBehavior((Class)p.getType(), new ArrayList());
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        EList allMembers = type.getMembers();
        i = 1;
        while (i <= allMembers.size()) {
            NamedElement member = (NamedElement)allMembers.get(i - 1);
            if (member instanceof Connector) {
                Connector connector = (Connector)member;
                if (this.isArrayPattern(connector)) {
                    this.generateArrayPattern(referenceToContext, connector);
                } else if (this.isStarPattern(connector)) {
                    this.generateStarPattern(referenceToContext, connector);
                }
            }
            ++i;
        }
        return referenceToContext.referent;
    }

    public void addStructuralFeatureValue(CS_Reference context, Property feature, Value value) {
        FeatureValue featureValue = context.getFeatureValue((StructuralFeature)feature);
        if (featureValue != null) {
            List values = featureValue.values;
            if (feature instanceof Port) {
                CS_InteractionPoint interactionPoint = new CS_InteractionPoint();
                interactionPoint.definingPort = (Port)feature;
                interactionPoint.referent = (CS_Object)value;
                interactionPoint.owner = context;
                values.add(interactionPoint);
            } else if (value instanceof CS_Object) {
                CS_Reference reference = new CS_Reference();
                reference.compositeReferent = (CS_Object)value;
                reference.referent = (CS_Object)value;
                values.add(reference);
            } else {
                values.add(value);
            }
        }
    }

    public void generateArrayPattern(CS_Reference context, Connector connector) {
        ConnectorEnd end1 = (ConnectorEnd)connector.getEnds().get(0);
        ConnectorEnd end2 = (ConnectorEnd)connector.getEnds().get(1);
        List<Reference> end1Values = this.getValuesFromConnectorEnd(context, end1);
        List<Reference> end2Values = this.getValuesFromConnectorEnd(context, end2);
        int i = 0;
        while (i < end1Values.size()) {
            CS_Link link = new CS_Link();
            link.type = connector.getType() == null ? this.getDefaultAssociation() : connector.getType();
            ArrayList<Value> valuesForEnd1 = new ArrayList<Value>();
            valuesForEnd1.add((Value)end1Values.get(i));
            ArrayList<Value> valuesForEnd2 = new ArrayList<Value>();
            valuesForEnd2.add((Value)end2Values.get(i));
            link.setFeatureValue((StructuralFeature)link.type.getOwnedEnds().get(0), valuesForEnd1, -1);
            link.setFeatureValue((StructuralFeature)link.type.getOwnedEnds().get(1), valuesForEnd2, -1);
            link.addTo(context.referent.locus);
            ++i;
        }
    }

    public List<Reference> getValuesFromConnectorEnd(CS_Reference context, ConnectorEnd end) {
        ArrayList<Reference> endValues;
        block6: {
            block5: {
                endValues = new ArrayList<Reference>();
                if (end.getPartWithPort() == null) break block5;
                FeatureValue valueForPart = context.getFeatureValue((StructuralFeature)end.getPartWithPort());
                if (valueForPart == null) break block6;
                int i = 0;
                while (i < valueForPart.values.size()) {
                    Reference reference = (Reference)valueForPart.values.get(i);
                    FeatureValue valueForPort = reference.getFeatureValue((StructuralFeature)((Port)end.getRole()));
                    if (valueForPort != null) {
                        int j = 0;
                        while (j < valueForPort.values.size()) {
                            endValues.add((Reference)valueForPort.values.get(j));
                            ++j;
                        }
                    }
                    ++i;
                }
                break block6;
            }
            FeatureValue valueForRole = context.getFeatureValue((StructuralFeature)((Property)end.getRole()));
            if (valueForRole != null) {
                int i = 0;
                while (i < valueForRole.values.size()) {
                    endValues.add((Reference)valueForRole.values.get(i));
                    ++i;
                }
            }
        }
        return endValues;
    }

    public void generateStarPattern(CS_Reference context, Connector connector) {
        ConnectorEnd end1 = (ConnectorEnd)connector.getEnds().get(0);
        ConnectorEnd end2 = (ConnectorEnd)connector.getEnds().get(1);
        List<Reference> end1Values = this.getValuesFromConnectorEnd(context, end1);
        List<Reference> end2Values = this.getValuesFromConnectorEnd(context, end2);
        int i = 0;
        while (i < end1Values.size()) {
            int j = 0;
            while (j < end2Values.size()) {
                CS_Link link = new CS_Link();
                link.type = connector.getType() == null ? this.getDefaultAssociation() : connector.getType();
                ArrayList<Value> valuesForEnd1 = new ArrayList<Value>();
                valuesForEnd1.add((Value)end1Values.get(i));
                ArrayList<Value> valuesForEnd2 = new ArrayList<Value>();
                valuesForEnd2.add((Value)end2Values.get(j));
                link.setFeatureValue((StructuralFeature)link.type.getOwnedEnds().get(0), valuesForEnd1, -1);
                link.setFeatureValue((StructuralFeature)link.type.getOwnedEnds().get(1), valuesForEnd2, -1);
                link.addTo(context.referent.locus);
                ++j;
            }
            ++i;
        }
    }

    public boolean canInstantiate(Property p) {
        if (p.isComposite() && p.getType() != null) {
            if (p.getType() instanceof Class) {
                return !((Class)p.getType()).isAbstract();
            }
            if (p.getType() instanceof Interface) {
                return p instanceof Port;
            }
        }
        return false;
    }

    public int getCardinality(ConnectorEnd end) {
        int lowerOfRole = ((MultiplicityElement)end.getRole()).getLower();
        if (lowerOfRole == 0) {
            return 0;
        }
        if (end.getPartWithPort() == null) {
            return lowerOfRole;
        }
        int lowerOfPart = end.getPartWithPort().getLower();
        return lowerOfRole * lowerOfPart;
    }

    public boolean isArrayPattern(Connector c) {
        if (c.getEnds().size() == 2 && ((ConnectorEnd)c.getEnds().get(0)).getLower() == 1 && ((ConnectorEnd)c.getEnds().get(1)).getLower() == 1 && this.canInstantiate((Property)((ConnectorEnd)c.getEnds().get(0)).getRole()) && this.canInstantiate((Property)((ConnectorEnd)c.getEnds().get(1)).getRole())) {
            int cardinality2;
            int cardinality1 = this.getCardinality((ConnectorEnd)c.getEnds().get(0));
            return cardinality1 == (cardinality2 = this.getCardinality((ConnectorEnd)c.getEnds().get(1)));
        }
        return false;
    }

    public boolean isStarPattern(Connector c) {
        int lowerBoundofEnd1;
        int cardinalityOfEnd1;
        if (c.getEnds().size() == 2 && this.canInstantiate((Property)((ConnectorEnd)c.getEnds().get(0)).getRole()) && this.canInstantiate((Property)((ConnectorEnd)c.getEnds().get(1)).getRole()) && (cardinalityOfEnd1 = this.getCardinality((ConnectorEnd)c.getEnds().get(0))) == (lowerBoundofEnd1 = ((ConnectorEnd)c.getEnds().get(0)).getLower())) {
            int lowerBoundofEnd2;
            int cardinalityOfEnd2 = this.getCardinality((ConnectorEnd)c.getEnds().get(1));
            return cardinalityOfEnd2 == (lowerBoundofEnd2 = ((ConnectorEnd)c.getEnds().get(1)).getLower());
        }
        return false;
    }

    public Association getDefaultAssociation() {
        if (this.defaultAssociation == null) {
            this.defaultAssociation = UMLFactory.eINSTANCE.createAssociation();
            this.defaultAssociation.setName("DefaultGeneratedAssociation");
            Property end1 = this.defaultAssociation.createOwnedEnd("x", null);
            end1.setLower(0);
            end1.setUpper(-1);
            end1.setIsOrdered(true);
            end1.setIsUnique(true);
            Property end2 = this.defaultAssociation.createOwnedEnd("y", null);
            end2.setLower(0);
            end2.setUpper(-1);
            end2.setIsOrdered(true);
            end2.setIsUnique(true);
        }
        return this.defaultAssociation;
    }

    public Object_ instantiateInterface(Interface interface_, Locus locus) {
        Class realizingClass = this.getRealizingClass(interface_);
        Object_ object = locus.instantiate(realizingClass);
        return object;
    }

    public Class getRealizingClass(Interface interface_) {
        Class realizingClass = null;
        String realizingClassName = String.valueOf(interface_.getQualifiedName()) + "GeneratedRealizingClass";
        int i = 1;
        while (i <= this.generatedRealizingClasses.size() && realizingClass == null) {
            Class cddRealizingClass = this.generatedRealizingClasses.get(i - 1);
            if (cddRealizingClass.getName().equals(realizingClassName)) {
                realizingClass = cddRealizingClass;
            }
            ++i;
        }
        if (realizingClass == null) {
            realizingClass = this.generateRealizingClass(interface_, realizingClassName);
            this.generatedRealizingClasses.add(realizingClass);
        }
        return realizingClass;
    }

    public Class generateRealizingClass(Interface interface_, String className) {
        Class realizingClass = UMLFactory.eINSTANCE.createClass();
        realizingClass.setName(className);
        realizingClass.createInterfaceRealization("", interface_);
        return realizingClass;
    }
}

