/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.debug;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.UnknownHostException;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IRegisterGroup;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.papyrus.infra.core.Activator;
import org.eclipse.papyrus.moka.communication.Marshaller;
import org.eclipse.papyrus.moka.communication.event.Start_Event;
import org.eclipse.papyrus.moka.communication.event.isuspendresume.Resume_Event;
import org.eclipse.papyrus.moka.communication.event.isuspendresume.Suspend_Event;
import org.eclipse.papyrus.moka.communication.event.iterminate.Terminate_Event;
import org.eclipse.papyrus.moka.communication.request.RequestMessage;
import org.eclipse.papyrus.moka.communication.request.ibreakpointlistener.AddBreakpoint_Request;
import org.eclipse.papyrus.moka.communication.request.ibreakpointlistener.RemoveBreakpoint_Request;
import org.eclipse.papyrus.moka.communication.request.idisconnect.Disconnect_Request;
import org.eclipse.papyrus.moka.communication.request.istackframe.GetVariables_Request;
import org.eclipse.papyrus.moka.communication.request.isuspendresume.Resume_Request;
import org.eclipse.papyrus.moka.communication.request.isuspendresume.Suspend_Request;
import org.eclipse.papyrus.moka.communication.request.iterminate.Terminate_Request;
import org.eclipse.papyrus.moka.communication.request.ithread.GetStackFrames_Request;
import org.eclipse.papyrus.moka.communication.request.ivalue.GetValueString_Request;
import org.eclipse.papyrus.moka.communication.request.ivariable.GetReferenceTypeName_Request;
import org.eclipse.papyrus.moka.communication.request.ivariable.GetValue_Request;
import org.eclipse.papyrus.moka.debug.MokaBreakpoint;
import org.eclipse.papyrus.moka.debug.MokaDebugElement;
import org.eclipse.papyrus.moka.debug.MokaThread;
import org.eclipse.papyrus.moka.debug.MokaValue;
import org.eclipse.papyrus.moka.debug.MokaVariable;

public class MokaDebugTarget
extends MokaDebugElement
implements IDebugTarget {
    protected ILaunch launch;
    protected Socket requestSocket;
    protected PrintWriter requestWriter;
    protected Socket replySocket;
    protected BufferedReader replyReader;
    protected Socket eventSocket;
    protected BufferedReader eventReader;
    protected EventDispatchJob eventDispatchJob;
    protected boolean isStarted = false;
    protected String name = null;
    protected MokaThread[] threads = new MokaThread[0];
    protected IProcess executionEngineProcess;
    protected boolean isDisconnected = false;
    protected boolean isSuspended = false;
    protected boolean isTerminated = false;

    public MokaDebugTarget(ILaunch launch, IProcess process) throws CoreException {
        super(null);
        this.launch = launch;
        this.debugTarget = this;
        this.executionEngineProcess = process;
        DebugPlugin.getDefault().getBreakpointManager().addBreakpointListener((IBreakpointListener)this);
    }

    public void connect(int requestPort, int replyPort, int eventPort) throws DebugException {
        try {
            this.requestSocket = new Socket("localhost", requestPort);
            this.requestWriter = new PrintWriter(this.requestSocket.getOutputStream());
            this.replySocket = new Socket("localhost", replyPort);
            this.replyReader = new BufferedReader(new InputStreamReader(this.replySocket.getInputStream()));
            this.eventSocket = new Socket("localhost", eventPort);
            this.eventReader = new BufferedReader(new InputStreamReader(this.eventSocket.getInputStream()));
        }
        catch (UnknownHostException e) {
            this.abort("Unable to connect to Execution Engine", e);
        }
        catch (IOException e) {
            this.abort("Unable to connect to Execution Engine", e);
        }
        this.eventDispatchJob = new EventDispatchJob();
        this.eventDispatchJob.schedule();
    }

    @Override
    public ILaunch getLaunch() {
        return this.launch;
    }

    public IProcess getProcess() {
        return this.executionEngineProcess;
    }

    public IThread[] getThreads() throws DebugException {
        return this.threads;
    }

    public boolean hasThreads() throws DebugException {
        return this.isStarted && !this.isTerminated() && this.getThreads() != null && this.getThreads().length > 0;
    }

    public String getName() throws DebugException {
        if (this.name != null) {
            return this.name;
        }
        return "";
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean supportsBreakpoint(IBreakpoint breakpoint) {
        return breakpoint.getModelIdentifier().equals("org.eclipse.papyrus.moka");
    }

    public void breakpointAdded(IBreakpoint breakpoint) {
        if (this.supportsBreakpoint(breakpoint)) {
            try {
                if (breakpoint.isEnabled()) {
                    try {
                        MokaBreakpoint mokaBreakpoint = (MokaBreakpoint)breakpoint;
                        AddBreakpoint_Request request = new AddBreakpoint_Request(mokaBreakpoint);
                        this.sendRequest(request);
                        String string = this.replyReader.readLine();
                    }
                    catch (IOException e) {
                        Activator.log.error((Throwable)e);
                    }
                }
            }
            catch (CoreException e) {
                Activator.log.error((Throwable)e);
            }
        }
    }

    public void breakpointRemoved(IBreakpoint breakpoint, IMarkerDelta delta) {
        if (this.supportsBreakpoint(breakpoint)) {
            try {
                MokaBreakpoint mokaBreakpoint = (MokaBreakpoint)breakpoint;
                RemoveBreakpoint_Request request = new RemoveBreakpoint_Request(mokaBreakpoint);
                this.sendRequest(request);
                String string = this.replyReader.readLine();
            }
            catch (CoreException e) {
                Activator.log.error((Throwable)e);
            }
            catch (IOException e) {
                Activator.log.error((Throwable)e);
            }
        }
    }

    public void breakpointChanged(IBreakpoint breakpoint, IMarkerDelta delta) {
        if (this.supportsBreakpoint(breakpoint)) {
            try {
                if (breakpoint.isEnabled() && DebugPlugin.getDefault().getBreakpointManager().isEnabled()) {
                    this.breakpointAdded(breakpoint);
                } else {
                    this.breakpointRemoved(breakpoint, delta);
                }
            }
            catch (CoreException e) {
                Activator.log.error((Throwable)e);
            }
        }
    }

    public boolean canDisconnect() {
        return false;
    }

    public void disconnect() throws DebugException {
        try {
            Disconnect_Request request = new Disconnect_Request();
            this.sendRequest(request);
            String ack = this.replyReader.readLine();
            this.isDisconnected = true;
        }
        catch (CoreException e) {
            Activator.log.error((Throwable)e);
        }
        catch (IOException e) {
            Activator.log.error((Throwable)e);
        }
    }

    public boolean isDisconnected() {
        return this.isDisconnected;
    }

    public boolean supportsStorageRetrieval() {
        return false;
    }

    public IMemoryBlock getMemoryBlock(long startAddress, long length) throws DebugException {
        return null;
    }

    public boolean canResume() {
        return this.isSuspended;
    }

    public boolean canSuspend() {
        return this.launch.getLaunchMode().equals("debug") && !this.isSuspended && !this.isTerminated();
    }

    public boolean isSuspended() {
        return this.isSuspended;
    }

    public void resume() throws DebugException {
        this.resume(this, 32);
    }

    protected void handle_Resume_Event(String message) {
        Resume_Event event = Marshaller.getInstance().resume_event_unmarshal(message);
        this.isSuspended = false;
        this.threads = event.getThreads();
        this.fireEvent(event.getDebugEvent());
    }

    public void resume(IDebugElement debugElement, int resumeDetail) throws DebugException {
        Resume_Request request = new Resume_Request(debugElement, resumeDetail);
        try {
            this.sendRequest(request);
        }
        catch (DebugException e) {
            this.abort("Failed to resume execution of the given debug element", e);
        }
    }

    public void suspend() throws DebugException {
        if (!this.isSuspended) {
            this.suspend(this, 32);
        }
    }

    public void suspend(IDebugElement debugElement, int suspendDetail) throws DebugException {
        Suspend_Request request = new Suspend_Request(debugElement, suspendDetail);
        try {
            this.sendRequest(request);
        }
        catch (DebugException e) {
            this.abort("Failed to suspend execution of the given debug element", e);
        }
    }

    protected void handle_Suspend_Event(String message) {
        Suspend_Event event = Marshaller.getInstance().suspend_event_unmarshal(message);
        this.isSuspended = true;
        this.threads = event.getThreads();
        int suspendEventDetail = event.getDebugEvent().getDetail();
        if (suspendEventDetail == 8 || suspendEventDetail == 16) {
            MokaThread thread = (MokaThread)((Object)event.getDebugEvent().getSource());
            thread.stepEnded();
        }
        this.fireEvent(event.getDebugEvent());
    }

    public boolean canTerminate() {
        return !this.isTerminated;
    }

    public boolean isTerminated() {
        return this.isTerminated;
    }

    protected void terminated() {
        this.isTerminated = true;
        this.isSuspended = false;
        DebugPlugin.getDefault().getBreakpointManager().removeBreakpointListener((IBreakpointListener)this);
        try {
            this.fireEvent(new Terminate_Event(this, this.getThreads()).getDebugEvent());
        }
        catch (DebugException e) {
            this.fireEvent(new Terminate_Event(this, null).getDebugEvent());
        }
    }

    public void terminate() throws DebugException {
        this.terminate(this);
    }

    public void terminate(IDebugElement debugElement) throws DebugException {
        Terminate_Request request = new Terminate_Request(debugElement);
        try {
            this.sendRequest(request);
        }
        catch (DebugException e) {
            this.abort("Failed to terminate execution of the given debug element", e);
        }
    }

    protected void handle_Terminate_Event(String event) {
        Terminate_Event terminateEvent = Marshaller.getInstance().terminate_event_unmarshal(event);
        if (terminateEvent.getSource() instanceof IDebugTarget) {
            this.isTerminated = true;
        } else {
            this.threads = (MokaThread[])terminateEvent.getThreads();
            this.fireEvent(terminateEvent.getDebugEvent());
        }
    }

    protected void handle_Start_Event(String message) {
        Start_Event event = Marshaller.getInstance().start_event_unmarshal(message);
        this.threads = event.getThreads();
        this.fireEvent(event.getDebugEvent());
        this.installDeferredBreakpoints();
        try {
            if (!this.isStarted) {
                this.resume();
                this.isStarted = true;
            }
        }
        catch (DebugException e) {
            Activator.log.error((Throwable)e);
        }
    }

    protected void installDeferredBreakpoints() {
        if (!DebugPlugin.getDefault().getBreakpointManager().isEnabled()) {
            return;
        }
        IBreakpoint[] breakpoints = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints("org.eclipse.papyrus.moka");
        int i = 0;
        while (i < breakpoints.length) {
            this.breakpointAdded(breakpoints[i]);
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendRequest(RequestMessage request) throws DebugException {
        Socket socket = this.requestSocket;
        synchronized (socket) {
            this.requestWriter.println(request.marshall());
            this.requestWriter.flush();
        }
    }

    public IStackFrame[] getStackFrames(IThread thread) throws DebugException {
        IStackFrame[] stackFrames = new IStackFrame[]{};
        if (!thread.isSuspended()) {
            return stackFrames;
        }
        this.sendRequest(new GetStackFrames_Request(thread));
        try {
            String reply = this.replyReader.readLine();
            stackFrames = Marshaller.getInstance().getStackFrames_reply_unmarshal(reply).getStackFrames();
        }
        catch (IOException e) {
            this.abort("Failed to retrieve stack frames", e);
        }
        return stackFrames;
    }

    public MokaVariable[] getVariables(IDebugElement stackFrameOrValue) throws DebugException {
        MokaVariable[] variables = new MokaVariable[]{};
        this.sendRequest(new GetVariables_Request(stackFrameOrValue));
        try {
            String reply = this.replyReader.readLine();
            variables = Marshaller.getInstance().getVariables_reply_unmarshal(reply).getVariables();
        }
        catch (IOException e) {
            this.abort("Failed to retrieve variables", e);
        }
        return variables;
    }

    public IRegisterGroup[] getRegisterGroups(IStackFrame stackFrame) throws DebugException {
        return new IRegisterGroup[0];
    }

    public MokaValue getValue(MokaVariable variable) throws DebugException {
        MokaValue value = null;
        this.sendRequest(new GetValue_Request(variable));
        try {
            String reply = this.replyReader.readLine();
            value = Marshaller.getInstance().getValue_reply_unmarshal(reply).getValue();
        }
        catch (IOException e) {
            this.abort("Failed to retrieve variable value", e);
        }
        return value;
    }

    public String getReferenceTypeName(IDebugElement debugElement) throws DebugException {
        String referenceTypeName = null;
        this.sendRequest(new GetReferenceTypeName_Request(debugElement));
        try {
            String reply = this.replyReader.readLine();
            referenceTypeName = Marshaller.getInstance().getReferenceTypeName_reply_unmarshal(reply).getReferenceTypeName();
        }
        catch (IOException e) {
            this.abort("Failed to retrieve variable value", e);
        }
        return referenceTypeName;
    }

    public String getValueString(IValue value) throws DebugException {
        String textualRepresentation = null;
        this.sendRequest(new GetValueString_Request(value));
        try {
            String reply = this.replyReader.readLine();
            textualRepresentation = Marshaller.getInstance().getValueString_reply_unmarshal(reply).getValueString();
        }
        catch (IOException e) {
            this.abort("Failed to retrieve textual representation of value", e);
        }
        return textualRepresentation;
    }

    class EventDispatchJob
    extends Job {
        public EventDispatchJob() {
            super("Moka Event Dispatch");
            this.setSystem(true);
        }

        protected IStatus run(IProgressMonitor monitor) {
            String event = "";
            while (!MokaDebugTarget.this.isTerminated() && event != null) {
                try {
                    event = MokaDebugTarget.this.eventReader.readLine();
                    if (event == null) continue;
                    MokaDebugTarget.this.isSuspended = false;
                    if (event.startsWith("event_start")) {
                        MokaDebugTarget.this.handle_Start_Event(event);
                        continue;
                    }
                    if (event.startsWith("event_resume")) {
                        MokaDebugTarget.this.handle_Resume_Event(event);
                        continue;
                    }
                    if (event.startsWith("event_suspend")) {
                        MokaDebugTarget.this.handle_Suspend_Event(event);
                        continue;
                    }
                    if (!event.startsWith("event_terminate")) continue;
                    MokaDebugTarget.this.handle_Terminate_Event(event);
                }
                catch (IOException e) {
                    MokaDebugTarget.this.terminated();
                }
            }
            MokaDebugTarget.this.terminated();
            return Status.OK_STATUS;
        }
    }
}

