/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.engine;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IRegisterGroup;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.moka.communication.Marshaller;
import org.eclipse.papyrus.moka.communication.event.EventMessage;
import org.eclipse.papyrus.moka.communication.event.Start_Event;
import org.eclipse.papyrus.moka.communication.event.isuspendresume.Resume_Event;
import org.eclipse.papyrus.moka.communication.event.isuspendresume.Suspend_Event;
import org.eclipse.papyrus.moka.communication.event.iterminate.Terminate_Event;
import org.eclipse.papyrus.moka.communication.reply.Ack;
import org.eclipse.papyrus.moka.communication.reply.ReplyMessage;
import org.eclipse.papyrus.moka.communication.reply.istackframe.GetVariables_Reply;
import org.eclipse.papyrus.moka.communication.reply.ithread.GetStackFrames_Reply;
import org.eclipse.papyrus.moka.communication.reply.ivalue.GetValueString_Reply;
import org.eclipse.papyrus.moka.communication.reply.ivariable.GetReferenceTypeName_Reply;
import org.eclipse.papyrus.moka.communication.reply.ivariable.GetValue_Reply;
import org.eclipse.papyrus.moka.communication.request.ibreakpointlistener.AddBreakpoint_Request;
import org.eclipse.papyrus.moka.communication.request.ibreakpointlistener.RemoveBreakpoint_Request;
import org.eclipse.papyrus.moka.communication.request.istackframe.GetVariables_Request;
import org.eclipse.papyrus.moka.communication.request.isuspendresume.Resume_Request;
import org.eclipse.papyrus.moka.communication.request.isuspendresume.Suspend_Request;
import org.eclipse.papyrus.moka.communication.request.iterminate.Terminate_Request;
import org.eclipse.papyrus.moka.communication.request.ithread.GetStackFrames_Request;
import org.eclipse.papyrus.moka.communication.request.ivalue.GetValueString_Request;
import org.eclipse.papyrus.moka.communication.request.ivariable.GetReferenceTypeName_Request;
import org.eclipse.papyrus.moka.communication.request.ivariable.GetValue_Request;
import org.eclipse.papyrus.moka.debug.MokaBreakpoint;
import org.eclipse.papyrus.moka.debug.MokaDebugTarget;
import org.eclipse.papyrus.moka.debug.MokaValue;
import org.eclipse.papyrus.moka.debug.MokaVariable;
import org.eclipse.papyrus.moka.engine.IExecutionEngine;

public abstract class AbstractExecutionEngine
implements IExecutionEngine {
    protected EObject eObjectToExecute;
    protected String mode = "run";
    protected MokaDebugTarget debugTarget;
    protected ServerSocket requestServer;
    protected ServerSocket replyServer;
    protected Socket replySocket;
    protected ServerSocket eventServer;
    protected Socket requestSocket;
    protected PrintWriter replyWriter;
    protected BufferedReader requestReader;
    protected Socket eventSocket;
    protected PrintWriter eventWriter;
    protected boolean isTerminated = false;

    @Override
    public void init(EObject eObjectToExecute, String[] args, MokaDebugTarget debugTarget, int requestPort, int replyPort, int eventPort) throws UnknownHostException, IOException {
        this.debugTarget = debugTarget;
        this.requestServer = new ServerSocket(requestPort);
        this.replyServer = new ServerSocket(replyPort);
        this.eventServer = new ServerSocket(eventPort);
        this.mode = "debug";
        this.eObjectToExecute = eObjectToExecute;
        this.initializeArguments(args);
    }

    public MokaDebugTarget getDebugTarget() {
        return this.debugTarget;
    }

    public boolean isTerminated() {
        return this.isTerminated;
    }

    @Override
    public abstract void initializeArguments(String[] var1);

    @Override
    public void start() throws IOException {
        if (this.eObjectToExecute != null) {
            String request = "";
            this.requestSocket = this.requestServer.accept();
            this.requestReader = new BufferedReader(new InputStreamReader(this.requestSocket.getInputStream()));
            this.replySocket = this.replyServer.accept();
            this.replyWriter = new PrintWriter(this.replySocket.getOutputStream());
            this.eventSocket = this.eventServer.accept();
            this.eventWriter = new PrintWriter(this.eventSocket.getOutputStream());
            this.sendEvent(new Start_Event(this.debugTarget, this.getThreads()));
            while (!this.isTerminated && request != null) {
                try {
                    request = this.requestReader.readLine();
                    if (request == null) continue;
                    if (request.startsWith("request_addBreakpoint")) {
                        this.addBreakpoint_reply(request);
                        continue;
                    }
                    if (request.startsWith("request_removeBreakpoint")) {
                        this.removeBreakpoint_reply(request);
                        continue;
                    }
                    if (request.startsWith("request_disconnect")) {
                        this.disconnect_reply();
                        continue;
                    }
                    if (request.startsWith("request_resume")) {
                        this.resume_reply(request);
                        continue;
                    }
                    if (request.startsWith("request_suspend")) {
                        this.suspend_reply(request);
                        continue;
                    }
                    if (request.startsWith("request_terminate")) {
                        this.terminate_reply(request);
                        continue;
                    }
                    if (request.startsWith("request_getStackFrames")) {
                        this.getStackFrames_reply(request);
                        continue;
                    }
                    if (request.startsWith("request_getVariables")) {
                        this.getVariables_reply(request);
                        continue;
                    }
                    if (request.startsWith("request_getValue")) {
                        this.getValue_reply(request);
                        continue;
                    }
                    if (request.startsWith("request_getReferenceTypeName")) {
                        this.getReferenceTypeName_reply(request);
                        continue;
                    }
                    if (!request.startsWith("request_getValueString")) continue;
                    this.getValueString_reply(request);
                }
                catch (IOException e) {
                    this.isTerminated = true;
                }
            }
            this.sendEvent(new Terminate_Event(this.debugTarget, this.getThreads()));
        }
    }

    protected void addBreakpoint_reply(String request) {
        AddBreakpoint_Request breakpointRequest = Marshaller.getInstance().addBreakpoint_request_unmarshal(request);
        this.addBreakpoint(breakpointRequest.getBreakpoint());
        Ack reply = new Ack();
        this.reply(reply);
    }

    @Override
    public abstract void addBreakpoint(MokaBreakpoint var1);

    protected void removeBreakpoint_reply(String request) {
        RemoveBreakpoint_Request breakpointRequest = Marshaller.getInstance().removeBreakpoint_request_unmarshal(request);
        this.removeBreakpoint(breakpointRequest.getBreakpoint());
        Ack reply = new Ack();
        this.reply(reply);
    }

    @Override
    public abstract void removeBreakpoint(MokaBreakpoint var1);

    protected void disconnect_reply() {
        this.disconnect();
        Ack reply = new Ack();
        this.reply(reply);
    }

    @Override
    public abstract void disconnect();

    @Override
    public IMemoryBlock getMemoryBlock(long startAddress, long length) {
        return null;
    }

    protected void resume_reply(String message) {
        Resume_Request request = Marshaller.getInstance().resume_request_unmarshal(message);
        Resume_Event event = new Resume_Event(request.getDebugElement(), request.getResumeDetail(), this.getThreads());
        this.sendEvent(event);
        this.resume(request);
    }

    @Override
    public abstract void resume(Resume_Request var1);

    protected void suspend_reply(String message) {
        Suspend_Request request = Marshaller.getInstance().suspend_request_unmarshal(message);
        this.suspend(request);
        Suspend_Event event = new Suspend_Event(request.getDebugElement(), request.getSuspendDetail(), this.getThreads());
        this.sendEvent(event);
    }

    @Override
    public abstract void suspend(Suspend_Request var1);

    protected void terminate_reply(String message) {
        Terminate_Request request = Marshaller.getInstance().terminate_request_unmarshal(message);
        this.terminate(request);
    }

    @Override
    public abstract void terminate(Terminate_Request var1);

    protected void getStackFrames_reply(String message) {
        GetStackFrames_Request request = Marshaller.getInstance().getStackFrames_request_unmarshal(message);
        GetStackFrames_Reply reply = new GetStackFrames_Reply(this.getStackFrames(request.getThread()));
        this.reply(reply);
    }

    @Override
    public abstract IStackFrame[] getStackFrames(IThread var1);

    protected void getVariables_reply(String message) {
        GetVariables_Request request = Marshaller.getInstance().getVariables_request_unmarshal(message);
        GetVariables_Reply reply = new GetVariables_Reply((MokaVariable[])this.getVariables(request.getStackFrameOrValue()));
        this.reply(reply);
    }

    @Override
    public IVariable[] getVariables(IDebugElement stackFrameOrValue) {
        return new MokaVariable[0];
    }

    @Override
    public IRegisterGroup[] getRegisterGroups(IStackFrame stackFrame) {
        return new IRegisterGroup[0];
    }

    protected void getValue_reply(String message) {
        GetValue_Request request = Marshaller.getInstance().getValue_request_unmarshal(message);
        GetValue_Reply reply = new GetValue_Reply((MokaValue)this.getValue(request.getVariable()));
        this.reply(reply);
    }

    @Override
    public IValue getValue(IVariable variable) {
        return null;
    }

    protected void getReferenceTypeName_reply(String message) {
        GetReferenceTypeName_Request request = Marshaller.getInstance().getReferenceTypeName_request_unmarshal(message);
        GetReferenceTypeName_Reply reply = new GetReferenceTypeName_Reply(this.getReferenceTypeName(request.getVariableOrValue()));
        this.reply(reply);
    }

    @Override
    public String getReferenceTypeName(IDebugElement debugElement) {
        return "";
    }

    protected void getValueString_reply(String message) {
        GetValueString_Request request = Marshaller.getInstance().getValueString_request_unmarshal(message);
        GetValueString_Reply reply = new GetValueString_Reply(this.getValueString(request.getValue()));
        this.reply(reply);
    }

    @Override
    public String getValueString(IValue value) {
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reply(ReplyMessage reply) {
        Socket socket = this.replySocket;
        synchronized (socket) {
            this.replyWriter.println(reply.marshal());
            this.replyWriter.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendEvent(EventMessage event) {
        Socket socket = this.eventSocket;
        synchronized (socket) {
            this.eventWriter.println(event.marshal());
            this.eventWriter.flush();
        }
    }

    public void setIsTerminated(boolean isTerminated) {
        this.isTerminated = true;
    }
}

