/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.launch;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.UnknownHostException;
import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate;
import org.eclipse.debug.core.model.LaunchConfigurationDelegate;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.moka.Activator;
import org.eclipse.papyrus.moka.debug.MokaDebugTarget;
import org.eclipse.papyrus.moka.debug.MokaProcess;
import org.eclipse.papyrus.moka.engine.IExecutionEngine;
import org.eclipse.papyrus.moka.engine.MokaExecutionEngineJob;
import org.eclipse.papyrus.moka.launch.EditorUtils;
import org.eclipse.ui.IEditorPart;

public class MokaLaunchDelegate
extends LaunchConfigurationDelegate
implements ILaunchConfigurationDelegate {
    public static String URI_ATTRIBUTE_NAME = "URI_ATTRIBUTE";
    public static String FRAGMENT_ATTRIBUTE_NAME = "FRAGMENT_ATTRIBUTE";
    public static String ARGS_ATTRIBUTE_NAME = "ARGS_ATTRIBUTE";

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        IExecutionEngine engine = this.instantiateExecutionEngine();
        if (engine == null) {
            this.abort("Could not instantiate execution engine", null);
        }
        MokaExecutionEngineJob engineJob = new MokaExecutionEngineJob("Execution Engine Job", engine);
        String resourceURI = configuration.getAttribute(URI_ATTRIBUTE_NAME, "");
        String uriFragment = configuration.getAttribute(FRAGMENT_ATTRIBUTE_NAME, "");
        String arguments = configuration.getAttribute(ARGS_ATTRIBUTE_NAME, "");
        String[] args = arguments.split("\\s+");
        IEditorPart part = EditorUtils.getEditorPart(resourceURI);
        ServicesRegistry servicesRegistry = (ServicesRegistry)part.getAdapter(ServicesRegistry.class);
        ResourceSet resourceSet = null;
        try {
            resourceSet = (ResourceSet)servicesRegistry.getService(ModelSet.class);
        }
        catch (ServiceException e1) {
            resourceSet = new ResourceSetImpl();
            org.eclipse.papyrus.infra.core.Activator.log.error((Throwable)e1);
        }
        Resource resource = resourceSet.getResource(URI.createURI((String)resourceURI), true);
        EObject eObjectToExecute = resource.getEObject(uriFragment);
        int requestPort = -1;
        int replyPort = -1;
        int eventPort = -1;
        requestPort = MokaLaunchDelegate.findFreePort();
        eventPort = MokaLaunchDelegate.findFreePort();
        replyPort = MokaLaunchDelegate.findFreePort();
        if (requestPort == -1 || replyPort == -1 || eventPort == -1) {
            this.abort("Unable to find free port", null);
        }
        MokaProcess process = new MokaProcess(launch, engineJob, "Moka runtime process", new HashMap<String, String>());
        MokaDebugTarget target = new MokaDebugTarget(launch, process);
        try {
            engine.init(eObjectToExecute, args, target, requestPort, replyPort, eventPort);
            target.connect(requestPort, replyPort, eventPort);
            launch.addDebugTarget((IDebugTarget)target);
            engineJob.setDebugTarget(target);
            engineJob.schedule();
        }
        catch (UnknownHostException e) {
            org.eclipse.papyrus.infra.core.Activator.log.equals(e);
        }
        catch (IOException e) {
            org.eclipse.papyrus.infra.core.Activator.log.equals(e);
        }
    }

    protected IExecutionEngine instantiateExecutionEngine() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] config = registry.getConfigurationElementsFor("org.eclipse.papyrus.moka.engine");
        try {
            IConfigurationElement e = null;
            String selectedExecutionEngine = Activator.getDefault().getPreferenceStore().getString("Default execution engine");
            if (selectedExecutionEngine == null || selectedExecutionEngine.equals("")) {
                e = config[0];
            } else {
                int i = 0;
                while (i < config.length) {
                    if (config[i].getNamespaceIdentifier().equals(selectedExecutionEngine)) {
                        e = config[i];
                    }
                    ++i;
                }
            }
            Object o = e.createExecutableExtension("class");
            return (IExecutionEngine)o;
        }
        catch (CoreException ex) {
            org.eclipse.papyrus.infra.core.Activator.log.equals((Object)ex);
        }
        catch (Exception ex) {
            org.eclipse.papyrus.infra.core.Activator.log.equals(ex);
        }
        return null;
    }

    protected static int findFreePort() {
        ServerSocket socket = null;
        try {
            socket = new ServerSocket(0);
            int n = socket.getLocalPort();
            return n;
        }
        catch (IOException iOException) {
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException iOException) {}
            }
        }
        return -1;
    }

    protected void abort(String message, Throwable e) throws CoreException {
        throw new CoreException((IStatus)new Status(4, "org.eclipse.papyrus.moka", 0, message, e));
    }
}

