/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.req.reqif.integration.command;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.uml.tools.profile.definition.PapyrusDefinitionAnnotation;
import org.eclipse.papyrus.uml.tools.profile.definition.ProfileRedefinition;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;

public class DefineProfileCommand
extends AbstractTransactionalCommand {
    private PapyrusDefinitionAnnotation papyrusAnnotation;
    private Profile rootProfile;
    private boolean saveConstraint;
    protected BasicDiagnostic diagnostic;

    public DefineProfileCommand(TransactionalEditingDomain domain, PapyrusDefinitionAnnotation papyrusAnnotation, Profile rootProfile, boolean saveConstraint) {
        super(domain, "DefineProfileCommand", null);
        this.rootProfile = rootProfile;
        this.papyrusAnnotation = papyrusAnnotation;
        this.saveConstraint = saveConstraint;
    }

    public static List<EPackage> defineProfiles(Package thePackage, boolean saveConstraintInDef) {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("ECORE_TAGGED_VALUES", "PROCESS");
        options.put("DERIVED_FEATURES", "REPORT");
        options.put("DUPLICATE_FEATURE_INHERITANCE", "PROCESS");
        options.put("DUPLICATE_FEATURES", "PROCESS");
        options.put("DUPLICATE_OPERATIONS", "REPORT");
        options.put("DUPLICATE_OPERATION_INHERITANCE", "REPORT");
        options.put("REDEFINING_OPERATIONS", "REPORT");
        options.put("REDEFINING_PROPERTIES", "REPORT");
        options.put("SUBSETTING_PROPERTIES", "REPORT");
        options.put("UNION_PROPERTIES", "PROCESS");
        options.put("SUPER_CLASS_ORDER", "REPORT");
        options.put("ANNOTATION_DETAILS", "REPORT");
        String handleConstraints = saveConstraintInDef ? "PROCESS" : "IGNORE";
        options.put("INVARIANT_CONSTRAINTS", handleConstraints);
        options.put("VALIDATION_DELEGATES", handleConstraints);
        options.put("INVOCATION_DELEGATES", handleConstraints);
        options.put("OPERATION_BODIES", handleConstraints);
        options.put("COMMENTS", "IGNORE");
        options.put("FOREIGN_DEFINITIONS", "PROCESS");
        options.put("UNTYPED_PROPERTIES", "PROCESS");
        LinkedList<EPackage> result = new LinkedList<EPackage>();
        if (thePackage instanceof Profile) {
            EPackage profileDefinition = ((Profile)thePackage).define(options, null, null);
            result.add(profileDefinition);
        }
        for (Package p : thePackage.getNestedPackages()) {
            List<EPackage> profileDefinitions = DefineProfileCommand.defineProfiles(p, saveConstraintInDef);
            result.addAll(profileDefinitions);
        }
        return result;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        IStatus result;
        List<EPackage> profileDefinitions = DefineProfileCommand.defineProfiles((Package)this.rootProfile, this.saveConstraint);
        try {
            ProfileRedefinition.redefineProfile((Package)this.rootProfile, (PapyrusDefinitionAnnotation)this.papyrusAnnotation);
            ProfileRedefinition.cleanProfile((Package)this.rootProfile);
            result = this.postValidate(profileDefinitions);
        }
        catch (ExecutionException ex) {
            throw ex;
        }
        catch (Exception e) {
            throw new ExecutionException("An error occurred during the profile definition", (Throwable)e);
        }
        return new CommandResult(result);
    }

    protected IStatus postValidate(List<EPackage> profileDefinitions) throws ExecutionException {
        EditingDomain domain = EMFHelper.resolveEditingDomain((EObject)this.rootProfile);
        AdapterFactory adapterFactory = domain instanceof AdapterFactoryEditingDomain ? ((AdapterFactoryEditingDomain)domain).getAdapterFactory() : null;
        Diagnostician diagnostician = this.createDiagnostician(adapterFactory, (IProgressMonitor)new NullProgressMonitor());
        this.diagnostic = diagnostician.createDefaultDiagnostic((EObject)this.rootProfile);
        Map context = diagnostician.createDefaultContext();
        for (EPackage ePackage : profileDefinitions) {
            diagnostician.validate((EObject)ePackage, (DiagnosticChain)this.diagnostic, context);
        }
        if (this.diagnostic.getSeverity() == 4) {
            return new Status(4, "org.eclipse.papyrus.uml.profile", "The defined profile is invalid");
        }
        if (this.diagnostic.getSeverity() == 2) {
            return new Status(2, "org.eclipse.papyrus.uml.profile", "The profile has been successfully defined");
        }
        return Status.OK_STATUS;
    }

    public Diagnostic getDiagnostic() {
        return this.diagnostic;
    }

    protected Diagnostician createDiagnostician(final AdapterFactory adapterFactory, final IProgressMonitor progressMonitor) {
        return new Diagnostician(){

            public String getObjectLabel(EObject eObject) {
                IItemLabelProvider itemLabelProvider;
                if (adapterFactory != null && !eObject.eIsProxy() && (itemLabelProvider = (IItemLabelProvider)adapterFactory.adapt((Notifier)eObject, IItemLabelProvider.class)) != null) {
                    return itemLabelProvider.getText((Object)eObject);
                }
                return super.getObjectLabel(eObject);
            }

            public boolean validate(EClass eClass, EObject eObject, DiagnosticChain diagnostics, Map<Object, Object> context) {
                progressMonitor.worked(1);
                return super.validate(eClass, eObject, diagnostics, context);
            }
        };
    }

    public List<IFile> getAffectedFiles() {
        IFile f = WorkspaceSynchronizer.getFile((Resource)this.rootProfile.eResource());
        return f != null ? Collections.singletonList(f) : Collections.emptyList();
    }
}

