/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.req.sysml.assistant.command;

import java.text.DecimalFormat;
import java.util.Iterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.papyrus.req.sysml.preferences.Activator;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.Stereotype;

public class PapyrusReqSysMLRequirementCreateCommand
extends RecordingCommand {
    protected Element selectedElement;

    public PapyrusReqSysMLRequirementCreateCommand(TransactionalEditingDomain domain, Element selectedElements) {
        super(domain, "PapyrusReqSysMLRequirementCreateCommand");
        this.selectedElement = selectedElements;
    }

    protected void createRequirement(Package owner, String text) {
        Class requirement = owner.createOwnedClass("tmpName", false);
        Stereotype reqStereotype = requirement.getApplicableStereotype("SysML::Requirements::Requirement");
        requirement.applyStereotype(reqStereotype);
        String id = PapyrusReqSysMLRequirementCreateCommand.getNewIDReq(owner);
        requirement.setName(id);
        requirement.setValue(reqStereotype, "id", (Object)id);
    }

    public static String getNewIDReq(Package owner) {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        String prefix = store.getString("REQUIREMENT_ID_PREFIX");
        int digit = store.getInt("REQUIREMENT_ID_DIGIT");
        int i = 0;
        DecimalFormat df = new DecimalFormat();
        df.setMinimumIntegerDigits(digit);
        String value = df.format(i);
        boolean IDexist = true;
        while (IDexist) {
            IDexist = false;
            value = df.format(++i);
            EList packelements = owner.getPackagedElements();
            Iterator iterator = packelements.iterator();
            while (iterator.hasNext() && !IDexist) {
                PackageableElement packageableElement = (PackageableElement)iterator.next();
                Stereotype reqStereotype = packageableElement.getAppliedStereotype("SysML::Requirements::Requirement");
                if (reqStereotype == null || packageableElement.getValue(reqStereotype, "id") == null) continue;
                String existedID = (String)packageableElement.getValue(reqStereotype, "id");
                String newID = String.valueOf(prefix) + value;
                if (!newID.equals(existedID)) continue;
                IDexist = true;
            }
        }
        return String.valueOf(prefix) + value;
    }

    protected void doExecute() {
        if (this.selectedElement instanceof Package) {
            this.createRequirement((Package)this.selectedElement, "");
        }
    }
}

