/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.req.sysml.assistant.handler;

import java.util.ArrayList;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.infra.core.editor.IMultiDiagramEditor;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForHandlers;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.PlatformUI;
import org.eclipse.uml2.uml.Element;

public abstract class PapyrusReqSysMLAbstractHandler
extends AbstractHandler {
    protected TransactionalEditingDomain transactionalEditingDomain = null;
    protected IMultiDiagramEditor papyrusEditor;

    protected void setPapyrusEnvironment(ExecutionEvent event) {
        try {
            this.papyrusEditor = (IMultiDiagramEditor)ServiceUtilsForHandlers.getInstance().getService(IMultiDiagramEditor.class, (Object)event);
            this.transactionalEditingDomain = (TransactionalEditingDomain)ServiceUtilsForHandlers.getInstance().getService(TransactionalEditingDomain.class, (Object)event);
        }
        catch (ServiceException ex) {
            System.err.println((Object)ex);
        }
    }

    protected Element getSelection() {
        Element selectedElement = null;
        ISelectionService selectionService = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService();
        ISelection selection = selectionService.getSelection();
        if (selection instanceof IStructuredSelection) {
            EObject selectedEObject;
            Object selectedobject = ((IStructuredSelection)selection).getFirstElement();
            if (selectedobject instanceof GraphicalEditPart) {
                Object graphicalElement = ((GraphicalEditPart)selectedobject).getModel();
                if (graphicalElement instanceof View && ((View)graphicalElement).getElement() instanceof Element) {
                    selectedElement = (Element)((View)graphicalElement).getElement();
                }
            } else if (selectedobject instanceof IAdaptable && (selectedEObject = (EObject)((IAdaptable)selectedobject).getAdapter(EObject.class)) instanceof Element) {
                selectedElement = (Element)selectedEObject;
            }
        }
        return selectedElement;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.setPapyrusEnvironment(event);
        return null;
    }

    protected ArrayList<Element> getSelectionSet() {
        ArrayList<Element> selectedSet = new ArrayList<Element>();
        ISelectionService selectionService = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService();
        ISelection selection = selectionService.getSelection();
        if (selection instanceof IStructuredSelection) {
            for (Object currentSelection : (IStructuredSelection)selection) {
                EObject selectedEObject;
                if (currentSelection instanceof GraphicalEditPart) {
                    Object graphicalElement = ((GraphicalEditPart)currentSelection).getModel();
                    if (!(graphicalElement instanceof View) || !(((View)graphicalElement).getElement() instanceof Element)) continue;
                    selectedSet.add((Element)((View)graphicalElement).getElement());
                    continue;
                }
                if (!(currentSelection instanceof IAdaptable) || !((selectedEObject = (EObject)((IAdaptable)currentSelection).getAdapter(EObject.class)) instanceof Element)) continue;
                selectedSet.add((Element)selectedEObject);
            }
        }
        return selectedSet;
    }
}

