/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.texteditor.cdt.handler;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.AbstractEMFOperation;
import org.eclipse.papyrus.commands.CheckedOperationHistory;
import org.eclipse.papyrus.cpp.codegen.utils.LocateCppProject;
import org.eclipse.papyrus.infra.core.resource.NotFoundException;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.IPageManager;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.ISashWindowsContentProvider;
import org.eclipse.papyrus.infra.core.sasheditor.di.contentprovider.DiSashModelManager;
import org.eclipse.papyrus.infra.core.sasheditor.editor.ISashWindowsContainer;
import org.eclipse.papyrus.infra.core.sashwindows.di.PageRef;
import org.eclipse.papyrus.infra.core.sashwindows.di.SashPanel;
import org.eclipse.papyrus.infra.core.sashwindows.di.TabFolder;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.core.utils.ServiceUtils;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForHandlers;
import org.eclipse.papyrus.texteditor.cdt.Activator;
import org.eclipse.papyrus.texteditor.cdt.modelresource.TextEditorModelSharedResource;
import org.eclipse.papyrus.texteditor.model.texteditormodel.TextEditorModel;
import org.eclipse.papyrus.texteditor.model.texteditormodel.TextEditorModelFactory;
import org.eclipse.papyrus.uml.diagram.common.handlers.CmdHandler;
import org.eclipse.swt.widgets.Display;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.Transition;

public class PapyrusCDTEditorHandler
extends CmdHandler {
    public boolean isEnabled() {
        this.updateSelectedEObject();
        if (this.selectedEObject instanceof Class || this.selectedEObject instanceof Operation || this.selectedEObject instanceof Transition) {
            URI uri = this.selectedEObject.eResource().getURI();
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            if (uri.segmentCount() < 2) {
                return false;
            }
            IProject modelProject = root.getProject(uri.segment(1));
            return modelProject.exists();
        }
        return false;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        try {
            final ServicesRegistry serviceRegistry = ServiceUtilsForHandlers.getInstance().getServiceRegistry(event);
            TransactionalEditingDomain domain = ServiceUtils.getInstance().getTransactionalEditingDomain((Object)serviceRegistry);
            AbstractEMFOperation command = new AbstractEMFOperation(domain, "Create CDT editor"){

                protected IStatus doExecute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                    try {
                        PapyrusCDTEditorHandler.this.doExecute(serviceRegistry);
                    }
                    catch (ServiceException e) {
                        Activator.log.error((Throwable)e);
                        return Status.CANCEL_STATUS;
                    }
                    catch (NotFoundException e) {
                        Activator.log.error((Throwable)e);
                        return Status.CANCEL_STATUS;
                    }
                    return Status.OK_STATUS;
                }
            };
            CheckedOperationHistory.getInstance().execute((IUndoableOperation)command, (IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            Activator.log.error("Can't create a CDT editor", (Throwable)e);
        }
        catch (ServiceException e) {
            Activator.log.error("Service exception during creation of CDT editor", (Throwable)e);
        }
        return null;
    }

    public void doExecute(final ServicesRegistry serviceRegistry) throws ServiceException, NotFoundException {
        final IPageManager pageMngr = ServiceUtils.getInstance().getIPageManager((Object)serviceRegistry);
        Classifier classifierToEdit = this.getClassifierToEdit();
        if (LocateCppProject.getTargetProject((PackageableElement)classifierToEdit, (boolean)true) == null) {
            return;
        }
        TextEditorModel editorModel = this.getEditorModel(serviceRegistry, classifierToEdit);
        if (editorModel == null) {
            editorModel = this.createEditorModel(serviceRegistry, classifierToEdit);
        }
        editorModel.setSelectedObject(this.selectedEObject);
        final TextEditorModel editorModelFinal = editorModel;
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (pageMngr.isOpen((Object)editorModelFinal)) {
                    pageMngr.selectPage((Object)editorModelFinal);
                } else {
                    pageMngr.openPage((Object)editorModelFinal);
                }
                try {
                    DiSashModelManager modelMngr = (DiSashModelManager)ServiceUtils.getInstance().getService(DiSashModelManager.class, (Object)serviceRegistry);
                    ISashWindowsContentProvider sashContentProvider = modelMngr.getISashWindowsContentProvider();
                    Object rootModel = sashContentProvider.getRootModel();
                    if (rootModel instanceof TabFolder) {
                        ISashWindowsContainer sashContainer = ServiceUtils.getInstance().getISashWindowsContainer((Object)serviceRegistry);
                        int index = PapyrusCDTEditorHandler.lookupIndex((TabFolder)rootModel, editorModelFinal);
                        if (index != -1) {
                            sashContentProvider.createFolder(sashContainer.getSelectedTabFolderModel(), index, sashContainer.getSelectedTabFolderModel(), 131072);
                        }
                    } else {
                        boolean cfr_ignored_0 = rootModel instanceof SashPanel;
                    }
                }
                catch (ServiceException serviceException) {}
            }
        });
    }

    protected TextEditorModel createEditorModel(ServicesRegistry serviceRegistry, Classifier classifierToEdit) throws ServiceException, NotFoundException {
        TextEditorModel editorModel = TextEditorModelFactory.eINSTANCE.createTextEditorModel();
        editorModel.setEditedObject((EObject)classifierToEdit);
        editorModel.setType("CDTEditorInPapyrus");
        editorModel.setName("CDT " + classifierToEdit.getName());
        TextEditorModelSharedResource model = (TextEditorModelSharedResource)ServiceUtils.getInstance().getModelSet((Object)serviceRegistry).getModelChecked("org.eclipse.papyrus.exteditor.cdt.CDTEditorModelSharedResource");
        model.addTextEditorModel(editorModel);
        return editorModel;
    }

    protected Classifier getClassifierToEdit() {
        if (this.selectedEObject instanceof Operation) {
            return (Classifier)((Operation)this.selectedEObject).getFeaturingClassifiers().get(0);
        }
        if (this.selectedEObject instanceof Transition) {
            return ((Transition)this.selectedEObject).getContainer().getStateMachine().getContext();
        }
        if (this.selectedEObject instanceof Classifier) {
            return (Classifier)this.selectedEObject;
        }
        return null;
    }

    protected TextEditorModel getEditorModel(ServicesRegistry serviceRegistry, Classifier classifierToEdit) throws ServiceException, NotFoundException {
        TextEditorModelSharedResource model = (TextEditorModelSharedResource)ServiceUtils.getInstance().getModelSet((Object)serviceRegistry).getModelChecked("org.eclipse.papyrus.exteditor.cdt.CDTEditorModelSharedResource");
        return model.getTextEditorModel((EObject)classifierToEdit);
    }

    public static int lookupIndex(TabFolder folder, Object model) {
        int index = 0;
        for (PageRef pr : folder.getChildren()) {
            if (pr.getPageIdentifier() == model) {
                return index;
            }
            ++index;
        }
        return -1;
    }
}

