/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.texteditor.cdt.listener;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.papyrus.infra.core.listenerservice.IPapyrusListener;
import org.eclipse.papyrus.texteditor.cdt.listener.OperationHistoryListener;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.DirectedRelationship;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Feature;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Parameter;

public class ModelListener
implements IPapyrusListener {
    public static boolean syncFromEditor;
    static EList<Classifier> regenList;

    static {
        regenList = new UniqueEList();
    }

    public void notifyChanged(Notification notification) {
        Object notifier = notification.getNotifier();
        int eventType = notification.getEventType();
        if (syncFromEditor) {
            return;
        }
        if (eventType == 8 || eventType == 9) {
            return;
        }
        OperationHistoryListener.init();
        try {
            if (notifier instanceof Classifier) {
                Classifier classifier = (Classifier)notifier;
                if (eventType == 4 || eventType == 22) {
                    regenList.add((Object)classifier);
                }
            } else if (notifier instanceof Feature) {
                Feature feature = (Feature)notifier;
                Element owner = feature.getOwner();
                if (owner instanceof Classifier) {
                    regenList.add((Object)((Classifier)owner));
                }
            } else if (notifier instanceof Parameter) {
                Element owner;
                Parameter parameter = (Parameter)notifier;
                if (parameter.getOperation() != null && (owner = parameter.getOperation().getOwner()) instanceof Classifier) {
                    regenList.add((Object)((Classifier)owner));
                }
            } else if (notifier instanceof DirectedRelationship) {
                DirectedRelationship dr = (DirectedRelationship)notifier;
                for (Element client : dr.getSources()) {
                    if (!(client instanceof Classifier)) continue;
                    regenList.add((Object)((Classifier)client));
                }
            } else {
                boolean cfr_ignored_0 = notifier instanceof Package;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

