/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.texteditor.cdt.sync;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.IASTNodeSelector;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IFunctionDeclaration;
import org.eclipse.cdt.core.model.IParent;
import org.eclipse.cdt.core.model.ISourceRange;
import org.eclipse.cdt.core.model.ISourceReference;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.ui.CDTUITools;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.papyrus.infra.core.Activator;
import org.eclipse.ui.IEditorInput;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Operation;

public class RevealCurrentOperation {
    protected IEditorInput m_input;
    protected Classifier m_classifier;
    protected String m_projectName;

    public RevealCurrentOperation(IEditorInput input, Classifier classifier, String projectName) {
        this.m_input = input;
        this.m_classifier = classifier;
        this.m_projectName = projectName;
    }

    public Element obtainSelectedElement(ITextSelection selection) {
        ICElement ice = CDTUITools.getEditorInputCElement((IEditorInput)this.m_input);
        if (ice instanceof ITranslationUnit) {
            ICProject project = CoreModel.getDefault().getCModel().getCProject(this.m_projectName);
            IIndex index = null;
            try {
                index = CCorePlugin.getIndexManager().getIndex(project);
                index.acquireReadLock();
                ITranslationUnit itu = (ITranslationUnit)ice;
                IASTTranslationUnit ast = itu.getAST(index, 2);
                IASTNodeSelector selector = ast.getNodeSelector(null);
                String opName = this.findOperation(itu, selector, (IParent)itu, selection);
                if (opName != null) {
                    Operation operation;
                    int sep = opName.lastIndexOf("::");
                    if (sep != -1) {
                        opName = opName.substring(sep + 2);
                    }
                    if ((operation = this.m_classifier.getOperation(opName, null, null)) != null) {
                        Operation operation2 = operation;
                        return operation2;
                    }
                }
            }
            catch (CModelException e) {
                Activator.getDefault().getLog().log(e.getStatus());
            }
            catch (Exception e) {
                System.err.println(e);
            }
            finally {
                if (index != null) {
                    index.releaseReadLock();
                }
            }
        }
        return this.m_classifier;
    }

    public String findOperation(ITranslationUnit itu, IASTNodeSelector selector, IParent parent, ITextSelection selection) throws CModelException {
        ICElement[] iCElementArray = parent.getChildren();
        int n = iCElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICElement child = iCElementArray[n2];
            if (child instanceof IParent) {
                return this.findOperation(itu, selector, (IParent)child, selection);
            }
            ISourceRange range = null;
            if (child instanceof ISourceReference) {
                range = ((ISourceReference)child).getSourceRange();
            }
            if (child instanceof IFunctionDeclaration) {
                String name = ((IFunctionDeclaration)child).getElementName();
                int pos = selection.getOffset();
                if (pos >= range.getStartPos() && pos < range.getStartPos() + range.getLength()) {
                    return name;
                }
            }
            ++n2;
        }
        return null;
    }
}

