/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.alf.transaction.commands;

import org.eclipse.core.runtime.AssertionFailedException;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.papyrus.uml.alf.AlfCompiler;
import org.eclipse.papyrus.uml.alf.MappingError;
import org.eclipse.papyrus.uml.alf.ParsingError;
import org.eclipse.papyrus.uml.alf.libraries.helper.AlfUtil;
import org.eclipse.papyrus.uml.alf.text.representation.AlfTextualRepresentation;
import org.eclipse.papyrus.uml.alf.transaction.commands.AlfCommand;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.NamedElement;

public class CompileCommand
extends AlfCommand {
    protected CompileCommand(AlfTextualRepresentation modelElementState) {
        super("Compilation", modelElementState);
    }

    protected void doExecute() {
        NamedElement context = this.modelElementState.getOwner();
        Model root = context.getModel();
        if (root != null) {
            AlfCompiler alfCompiler = new AlfCompiler(this.modelElementState.getOwner(), AlfUtil.getInstance().getStandardProfile(root), AlfUtil.getInstance().getActionLanguageProfile(root));
            try {
                alfCompiler.compile(this.modelElementState.getContent());
            }
            catch (ParsingError e) {
                e.printStackTrace();
                throw new WrappedException((Exception)((Object)e));
            }
            catch (MappingError e) {
                e.printStackTrace();
                throw new WrappedException((Exception)((Object)e));
            }
            catch (AssertionFailedException e) {
                e.printStackTrace();
            }
        }
    }
}

